const { createApp } = Vue;

createApp({
    data() {
        return {
            allData: [],
            loading: true, // Mulai dengan true
            showModal: false,
            isEdit: false,
            filters: {
                search: '',
                lokasi: '',
                sortBy: 'no_reg'
            },
            form: {
                id: null,
                no_reg: '',
                nama_barang: '',
                qty: 1,
                lokasi: '',
                keterangan: ''
            },
            uploadedFile: null,
            imagePreview: null,
            toast: { show: false, message: '', isError: false }
        }
    },
    computed: {
        uniqueLocations() {
            if (!this.allData) return [];
            return [...new Set(this.allData.map(item => item.lokasi))].sort();
        },
        filteredData() {
            if (!this.allData) return [];
            let data = this.allData.filter(item => {
                const s = this.filters.search.toLowerCase();
                const nama = item.nama_barang ? item.nama_barang.toLowerCase() : '';
                const lokasi = item.lokasi || '';
                return nama.includes(s) &&
                       (!this.filters.lokasi || lokasi === this.filters.lokasi);
            });
            
            return data.sort((a, b) => {
                if (this.filters.sortBy === 'qty') return b.qty - a.qty;
                return String(a[this.filters.sortBy]).localeCompare(String(b[this.filters.sortBy]));
            });
        },
        totalQty() {
            return this.filteredData.reduce((sum, item) => sum + parseInt(item.qty || 0), 0);
        }
    },
    mounted() {
        // Berikan sedikit delay agar library crud.js dan jQuery siap
        setTimeout(() => {
            this.fetchData();
        }, 500);
    },
    methods: {
    loadData() {
        // Menggunakan fungsi ambil() dari crud.js
        const res = ambil('inventaris_masjid', 'brand', xbrand, xbrand);
        this.listData = typeof res === 'string' ? JSON.parse(res) : res;
    },

    saveInventaris() {
        // Persiapkan data untuk JSON
        const dataJson = {
            no_reg: this.form.no_reg,
            nama_barang: this.form.nama_barang,
            lokasi: this.form.lokasi,
            qty: this.form.qty
        };

        let targetId = 0;

        if (this.isEdit) {
            // PAKAI FUNGSI rubahjson() dari crud.js
            rubahjson('inventaris_masjid', dataJson, this.form.id, 'id');
            targetId = this.form.id;
        } else {
            // PAKAI FUNGSI tambahjson() dari crud.js
            targetId = tambahjson('inventaris_masjid', dataJson);
        }

        // Jika berhasil (targetId > 0) dan ada foto yang dipilih
        if (targetId > 0) {
            if (this.selectedFile) {
                this.prosesUploadFoto(targetId);
            } else {
                this.selesaiSimpan();
            }
        }
    },

    prosesUploadFoto(id) {
        let formData = new FormData();
        formData.append('action', 'upload_foto');
        formData.append('id', id);
        formData.append('foto_barang_file', this.selectedFile);

        $.ajax({
            url: "crud.php",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: () => { this.selesaiSimpan(); }
        });
    },

    selesaiSimpan() {
        alert('Data berhasil disimpan');
        this.bsModal.hide();
        this.loadData();
        this.fileName = '';
        this.selectedFile = null;
    },

    hapusData(id) {
        if (confirm('Hapus item ini?')) {
            // PAKAI FUNGSI hapus() dari crud.js
            const res = hapus('inventaris_masjid', 'id', id);
            if (res == "1") {
                this.loadData();
            }
        }
    }
}
}).mount('#app');