// Ganti URL ini sesuai dengan folder proyek Anda di htdocs XAMPP/server lokal Anda
// crud.js - FIXED VERSION

function hapus(table, idField, idValue) {
    let result = 0;
    $.ajax({
        type: "POST",
        async: false,
        url: BASE_URL + "crud.php",
        data: {
            action: 'hapus',
            table: table,
            idField: idField,
            idValue: idValue,
            xbrand: typeof xbrand !== 'undefined' ? xbrand : '',
            xcab: typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            console.log('Hapus Response:', response);
            result = response;
        },
        error: function(error) {
            console.error('Hapus Error:', error);
        }
    });
    return result;
}

function tambahjson(table, dataObject) {
    let result = 0;
    
    // Gabungkan data objek dengan data sistem
    let postData = Object.assign({}, dataObject);
    postData.action = 'tambahjson';
    postData.table = table;
    postData.xbrand = typeof xbrand !== 'undefined' ? xbrand : '';
    postData.xcab = typeof xcab !== 'undefined' ? xcab : '';

    $.ajax({
        type: "POST",
        async: false,
        url: BASE_URL + "crud.php",
        data: postData, // Kirim sebagai object langsung, JANGAN di-stringify
        success: function(response) {
            console.log('Tambah Response:', response);
            result = response;
        },
        error: function(error) {
            console.error('Tambah Error:', error);
            result = 0;
        }
    });

    return result;
}

function rubahjson(table, dataObject, id, ff) {
    let result = 0;

    // Gabungkan data objek dengan data sistem
    let postData = Object.assign({}, dataObject);
    postData.action = 'rubahjson';
    postData.table = table;
    postData.id = id;
    postData.ff = ff; // Legacy parameter, biarkan saja
    postData.xbrand = typeof xbrand !== 'undefined' ? xbrand : '';
    postData.xcab = typeof xcab !== 'undefined' ? xcab : '';

    $.ajax({
        type: "POST",
        async: false,
        url: BASE_URL + "crud.php",
        data: postData, // Kirim sebagai object langsung
        success: function(response) {
            console.log('Update Response:', response);
            result = response;
        },
        error: function(error) {
            console.error('Update Error:', error);
        }
    });

    return result;
}

function ambil_select(table, sql) {
    let result = "[]";
    $.ajax({
        type: "POST",
        async: false,
        url: BASE_URL + "crud.php",
        data: {
            action: 'ambil_select',
            sql: sql,
            xbrand: typeof xbrand !== 'undefined' ? xbrand : '',
            xcab: typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            // Jika response sudah object (auto-parsed by jQuery), stringify balik
            // agar konsisten dengan logika parsing di file HTML
            if (typeof response === 'object') {
                result = JSON.stringify(response);
            } else {
                result = response;
            }
        },
        error: function(xhr, status, error) {
            console.error("AJAX Error:", error);
            result = "[]";
        }
    });
    return result;
}

// Fungsi helper lainnya (ambil, yambil_select, dll) 
// disederhanakan karena logika utamanya sama
function yambil_select(table, sql) {
    return ambil_select(table, sql);
}

function ambil(table, field, value1, value2) {
    let result = [];
    if (!value2) { value2 = value1 };
    $.ajax({
        type: "POST",
        async: false,
        url: BASE_URL + "crud.php",
        data: {
            action: 'ambil',
            table: table,
            field: field,
            value: [value1, value2],
            xbrand: typeof xbrand !== 'undefined' ? xbrand : '',
            xcab: typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            result = response;
        },
        error: function(error) {
            console.error(error);
        }
    });
    return result;
}