<?php
// File: sinkronisasi_lokal.php
// Lokasi: Server Lokal

// --- Konfigurasi ---
$url_api_cloud = "https://www.bepos.my.id/pos/ambil.php?brand=001&cab=002";

// --- Konfigurasi Database Lokal ---
include 'data.php';

$host_lokal = $servername;
$user_lokal = $username; // Seringkali 'root'
$pass_lokal = $password; // Seringkali kosong
$db_lokal   = $dbname;

$pesan = "Klik tombol untuk memulai sinkronisasi.";

// --- Logika Sinkronisasi ---
if (isset($_POST['sync_now'])) {
    // 1. Ambil data JSON dari API di cloud
    $json_data = @file_get_contents($url_api_cloud);

    if ($json_data === FALSE) {
        $pesan = "<p style='color:red;'>Gagal mengambil data dari server cloud. Pastikan URL API benar dan server cloud dapat diakses.</p>";
    } else {
        $data_mahasiswa = json_decode($json_data, true);

        // Buat koneksi ke DB Lokal
        $conn_lokal = new mysqli($host_lokal, $user_lokal, $pass_lokal, $db_lokal);
        if ($conn_lokal->connect_error) {
            $pesan = "<p style='color:red;'>Koneksi ke database lokal gagal: " . $conn_lokal->connect_error . "</p>";
        } else {
            // 2. Kosongkan tabel mahasiswa di lokal
            $conn_lokal->query("TRUNCATE TABLE mahasiswa");

            // 3. Insert data baru ke tabel lokal
            $stmt = $conn_lokal->prepare("INSERT INTO mahasiswa (nim, nama, jurusan, angkatan, brand, cab) VALUES (?, ?, ?, ?, '001', '002')");
            
            $jumlah_sukses = 0;
            foreach ($data_mahasiswa as $mhs) {
                $stmt->bind_param("sssi", $mhs['nim'], $mhs['nama'], $mhs['jurusan'], $mhs['angkatan']);
                $stmt->execute();
                $jumlah_sukses++;
            }
            
            $pesan = "<p style='color:green;'>Sinkronisasi berhasil! " . $jumlah_sukses . " data mahasiswa telah diperbarui.</p>";
            $stmt->close();
            $conn_lokal->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Uji Sinkronisasi Data</title>
    <style>
        body { font-family: sans-serif; max-width: 600px; margin: 40px auto; }
        .container { border: 1px solid #ccc; padding: 20px; border-radius: 5px; }
        button { padding: 10px 20px; font-size: 16px; cursor: pointer; }
        .pesan { margin-top: 20px; padding: 15px; background-color: #f0f0f0; border: 1px solid #ddd; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Sinkronisasi Data Mahasiswa</h1>
        <p>Halaman ini akan mengambil data dari server cloud dan menyimpannya ke database lokal dengan metode "Empty and Insert".</p>
        
        <form method="post">
            <button type="submit" name="sync_now">Sinkronkan Sekarang!</button>
        </form>

        <div class="pesan">
            <strong>Status:</strong> <?php echo $pesan; ?>
        </div>
    </div>
</body>
</html>