<?php
header("Access-Control-Allow-Origin: *"); // Mengizinkan semua domain. Ganti '*' dengan domain spesifik untuk keamanan lebih.
header("Access-Control-Allow-Methods: POST, GET, OPTIONS"); // Mengizinkan metode request yang digunakan.
header("Access-Control-Allow-Headers: Content-Type, X-Requested-With"); // Mengizinkan header tertentu.
// File: ambil.php (Versi Fleksibel)
// Lokasi: Server Cloud (cPanel)

header('Content-Type: application/json');
include 'data.php';

$host_lokal = $servername;
$user_lokal = $username; // Seringkali 'root'
$pass_lokal = $password; // Seringkali kosong
$db_lokal   = $dbname;



// --- Konfigurasi Database Cloud ---
$host_cloud = $servername;;
$user_cloud = $username;;
$pass_cloud = $password;
$db_cloud   = $dbname;

// --- Daftar Tabel yang Diizinkan untuk Disinkronisasi (PENTING UNTUK KEAMANAN) ---
$allowed_tables = ['mahasiswa', 'menus', 'users', 'pos', 'meja', 'masterd'];

// --- Logika API Fleksibel ---

// 1. Validasi Input Dasar
if (!isset($_GET['file'])) {
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Parameter file diperlukan.']);
    exit;
}

$table = $_GET['file'];

// 2. Cek Keamanan Tabel
// if (!in_array($table, $allowed_tables)) {
//     http_response_code(403); // Forbidden
//     echo json_encode(['error' => 'Akses ke tabel ini tidak diizinkan.']);
//     exit;
// }

// 3. Koneksi ke Database
$conn = new mysqli($host_cloud, $user_cloud, $pass_cloud, $db_cloud);
if ($conn->connect_error) {
    http_response_code(500); // Internal Server Error
    echo json_encode(['error' => 'Koneksi ke database cloud gagal.']);
    exit;
}

// 4. Membangun Query SQL secara Dinamis
$sql = "SELECT * FROM `$table` WHERE 1=1"; // Klausa WHERE 1=1 untuk mempermudah penambahan kondisi
$params = [];
$types = "";

if (isset($_GET['brand']) && !empty($_GET['brand'])) {
    // 💡 Modifikasi di sini: tambahkan "OR brand = ''" di dalam kurung
    $sql .= " AND (brand = ? OR brand = '')"; 
    $params[] = $_GET['brand'];
    $types .= "s"; 
}

if (isset($_GET['cab']) && !empty($_GET['cab'])) {
    // 💡 Modifikasi di sini: tambahkan "OR cab = ''" di dalam kurung
    $sql .= " AND (cab = ? OR cab = '')";
    $params[] = $_GET['cab'];
    $types .= "s";
}

// 5. Eksekusi Query dengan Prepared Statement
$stmt = $conn->prepare($sql);

// Bind parameter hanya jika ada parameter yang perlu di-bind
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// 6. Kembalikan Hasil sebagai JSON
echo json_encode($data);

$stmt->close();
$conn->close();
?>
