const { exec } = require('child_process');
const fs = require('fs');
const archiver = require('archiver');
const path = require('path');

// --- Konfigurasi Database (ambil dari file data.php Anda) ---
const dbConfig = {
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'pos_m',
};

// --- Konfigurasi Backup ---
const backupFileName = `backup-${dbConfig.database}-${Date.now()}`;
const sqlFilePath = path.join(__dirname, `${backupFileName}.sql`);
const zipFilePath = path.join(__dirname, `${backupFileName}.zip`);

// --- Perintah mysqldump ---
// Hati-hati dengan injeksi shell, pastikan input aman.
const dumpCommand = `mysqldump --host=${dbConfig.host} --user=${dbConfig.user} ${dbConfig.password ? `--password=${dbConfig.password}` : ''} ${dbConfig.database} > ${sqlFilePath}`;

// 1. Jalankan mysqldump untuk membuat file .sql
console.log('Memulai proses backup database...');
exec(dumpCommand, (error, stdout, stderr) => {
    if (error) {
        console.error(`Error saat menjalankan mysqldump: ${error.message}`);
        return;
    }
    if (stderr) {
        // mysqldump seringkali mengeluarkan peringatan ke stderr yang bisa diabaikan
        console.warn(`Peringatan dari mysqldump: ${stderr}`);
    }

    console.log(`Backup database berhasil dibuat: ${path.basename(sqlFilePath)}`);

    // 2. Buat file .zip dari file .sql
    const output = fs.createWriteStream(zipFilePath);
    const archive = archiver('zip', {
        zlib: { level: 9 } // Atur level kompresi
    });

    output.on('close', function() {
        console.log(`File SQL berhasil dikompresi ke: ${path.basename(zipFilePath)}`);
        console.log(`Total ukuran zip: ${archive.pointer()} bytes`);

        // 3. (Opsional) Hapus file .sql setelah di-zip
        fs.unlink(sqlFilePath, (err) => {
            if (err) {
                console.error(`Gagal menghapus file SQL sementara: ${err}`);
            } else {
                console.log('File SQL sementara berhasil dihapus.');
            }
        });
    });

    archive.on('error', function(err) {
        throw err;
    });

    // Pipe output arsip ke file
    archive.pipe(output);

    // Tambahkan file .sql ke dalam arsip
    archive.file(sqlFilePath, { name: `${backupFileName}.sql` });

    // Selesaikan proses pengarsipan
    archive.finalize();
});