// Toolbox.js

const Toolbox = {
    emits: ['add-element', 'save-layout', 'reset-layout'],
    methods: {
        addElement(type) {
            this.$emit('add-element', type);
        },
        saveLayout() {
            this.$emit('save-layout');
        },
        resetLayout() {
            this.$emit('reset-layout');
        }
    },
    template: `
        <div id="toolbox" class="ve-floating-window">
            <div class="ve-window-header"><i class="fa-solid fa-toolbox"></i> Toolbox</div>
            <div class="ve-window-content">
                <div class="toolbox-actions">
                    <button @click="saveLayout" class="tool-action-btn primary"><i class="fa-solid fa-save"></i> Simpan</button>
                    <button @click="resetLayout" class="tool-action-btn secondary"><i class="fa-solid fa-undo"></i> Reset</button>
                </div>
                <hr class="toolbox-divider">
                <div class="toolbox-elements">
                    <button @click="addElement('div')" title="Wadah (Div)"><i class="fa-solid fa-box-archive"></i> Div</button>
                    <button @click="addElement('h1')" title="Judul H1"><i class="fa-solid fa-heading"></i> H1</button>
                    <button @click="addElement('p')" title="Paragraf"><i class="fa-solid fa-paragraph"></i> P</button>
                    <button @click="addElement('img')" title="Gambar"><i class="fa-solid fa-image"></i> Img</button>
                </div>
            </div>
        </div>
    `
};