// crud2.js

/**
 * Mengambil record secara sinkron (menunggu) berdasarkan range nilai field.
 * Peringatan: Penggunaan fungsi sinkron dapat memblokir UI browser dan
 * umumnya tidak direkomendasikan. Gunakan dengan hati-hati.
 *
 * @param {string} table - Nama tabel database.
 * @param {string} field - Nama kolom untuk filter.
 * @param {*} value1 - Nilai awal range.
 * @param {*} value2 - Nilai akhir range (jika kosong, akan disamakan dengan value1).
 * @returns {Object[]|null} Array objek data jika berhasil, atau null jika terjadi error.
 */
function ambil_sync(table, field, value1, value2) {

    let resultData = null; // Variabel untuk menyimpan hasil
    const finalValue2 = (value2 === undefined || value2 === null) ? value1 : value2;

    $.ajax({
        type: "POST",
        url: "crud2.php", // Mengarah ke file PHP baru
        async: false,     // KUNCI: Membuat panggilan ini menjadi sinkron (menunggu)
        data: {
            action: 'ambil',
            table: table,
            field: field,
            value: [value1, finalValue2],
            xbrand: window.xbrand, // Mengambil variabel global
            xcab: window.xcab      // Mengambil variabel global
        },
        dataType: 'json',
        success: function (response) {
            // Jika berhasil, simpan respons ke variabel resultData
            resultData = response;
        },
        error: function (xhr, status, error) {
            // Jika error, catat di konsol dan resultData akan tetap null
            console.error("AJAX Sync Error (ambil_sync):", status, error, xhr.responseText);
        }
    });

    // Kembalikan data yang telah didapat
    return resultData;
}