<?php

phpinfo();
// Path ke file DBF
$dbf_file = 'e:\2000\transaks\terimai.dbf';
$nomor_terima_dicari = '0006510/0423';

// Cek apakah file DBF ada dan bisa dibaca
if (!file_exists($dbf_file)) {
    die("Error: File DBF tidak ditemukan di path: $dbf_file\n");
}

if (!is_readable($dbf_file)) {
    die("Error: File DBF tidak bisa dibaca. Periksa hak akses.\n");
}

// Buka koneksi ke database dBase
// Mode '0' berarti read-only
$dbf_conn = dbase_open($dbf_file, 0);

if (!$dbf_conn) {
    die("Error: Tidak bisa membuka file DBF: " . dbase_errormsg() . "\n");
}

// Dapatkan jumlah record dalam file DBF
$num_records = dbase_numrecords($dbf_conn);

if ($num_records === false) {
    die("Error: Tidak bisa mendapatkan jumlah record: " . dbase_errormsg() . "\n");
}

echo "Membaca file: $dbf_file\n";
echo "Mencari nomor terima: $nomor_terima_dicari\n";
echo "-------------------------------------------\n";

$record_ditemukan = false;

// Loop melalui setiap record
for ($i = 1; $i <= $num_records; $i++) {
    // Dapatkan record sebagai array asosiatif
    $record = dbase_get_record_with_names($dbf_conn, $i);

    if ($record === false) {
        echo "Warning: Tidak bisa membaca record ke-$i: " . dbase_errormsg() . "\n";
        continue;
    }

    // Periksa apakah field 'TERIMA' ada di record
    // Nama field di DBF biasanya uppercase, tapi dbase_get_record_with_names
    // mengembalikan key dalam uppercase. Kita akan periksa beberapa variasi umum.
    $field_terima_value = null;
    if (isset($record['TERIMA'])) {
        $field_terima_value = trim($record['TERIMA']); // trim untuk menghapus spasi ekstra
    } elseif (isset($record['terima'])) {
        $field_terima_value = trim($record['terima']);
    } else {
        if ($i === 1) { // Hanya tampilkan error nama field sekali
            echo "Warning: Field 'TERIMA' tidak ditemukan di header. Daftar field yang ada: " . implode(", ", array_keys($record)) . "\n";
            echo "Pastikan nama field 'TERIMA' sudah benar (case sensitive atau tidak tergantung konversi).\n";
        }
        // Jika field TERIMA tidak ada, kita tidak bisa melakukan filter
        // Anda mungkin perlu menyesuaikan nama field 'TERIMA', 'BARANG', 'NAMA'
        // sesuai dengan struktur file DBF Anda (cek case-sensitivenya)
    }

    // Jika field 'TERIMA' ditemukan dan nilainya cocok
    if ($field_terima_value !== null && $field_terima_value == $nomor_terima_dicari) {
        $record_ditemukan = true;

        // Ambil nilai field yang diinginkan
        // Sesuaikan nama field jika perlu (misal, 'BARANG' atau 'barang')
        $terima = $field_terima_value;
        $barang = isset($record['BARANG']) ? trim($record['BARANG']) : (isset($record['barang']) ? trim($record['barang']) : 'N/A');
        $nama = isset($record['NAMA']) ? trim($record['NAMA']) : (isset($record['nama']) ? trim($record['nama']) : 'N/A');

        echo "Record Ditemukan:\n";
        echo "  TERIMA: " . $terima . "\n";
        echo "  BARANG: " . $barang . "\n";
        echo "  NAMA  : " . $nama . "\n";
        echo "-------------------------------------------\n";
        // Jika Anda hanya ingin mencari satu record pertama yang cocok, Anda bisa uncomment baris berikut:
        // break;
    }
}

if (!$record_ditemukan) {
    echo "Record dengan nomor terima '$nomor_terima_dicari' tidak ditemukan.\n";
}

// Tutup koneksi ke database dBase
dbase_close($dbf_conn);

?>