// proses.js
window.prosesMethods = {
    async loadAppConfiguration(vueInstance) {
        
        try {
            const response = await $.ajax({
                url: 'crud.php',
                type: 'POST',
                // MODIFIKASI: Tambahkan id_config ke data yang dikirim
                data: {
                    action: 'get_app_config',
                    brand: window.xbrand,
                    cab: window.xcab,
                    id_config: window.id_config // Tambahkan baris ini
                },
                dataType: 'text'
            });
            let configData;
            try {
                configData = JSON.parse(response);
            } catch (e) {
                console.error('Gagal mem-parse konfigurasi JSON dari server (saat refresh):', response, e);
                alert('Gagal memuat ulang konfigurasi aplikasi: JSON tidak valid.');
                return;
            }

            if (configData && Array.isArray(configData)) {
                vueInstance.menus = configData;
                if (!vueInstance.menus.find(menu => menu.id === 'setup_config')) {
                    vueInstance.menus.push({
                        id: 'setup_config',
                        name: 'Setup Konfigurasi',
                        icon: 'fas fa-cog',
                        link_external: 'setup.html'
                    });
                }
                console.log("Konfigurasi aplikasi berhasil di-refresh/dimuat ulang.");
            } else {
                console.error('Data konfigurasi dari server (saat refresh) tidak valid:', configData);
            }
        } catch (error) {
            console.error('Error mengambil ulang konfigurasi aplikasi:', error);
            alert('Gagal mengambil ulang konfigurasi aplikasi dari server.');
        }
    },

    async saveAppConfiguration(vueInstance) {
        if (vueInstance.isLoadingConfig) {
            console.warn("Sedang memuat konfigurasi, penyimpanan dibatalkan.");
            return false;
        }

        const activeTab = vueInstance.openTabs.find(tab => tab.id === vueInstance.activeTabId);
        if (!activeTab) {
            alert("Tidak ada tab aktif. Tidak ada layout untuk disimpan.");
            return false;
        }

        const menuConfigToSave = activeTab.menuConfig;
        const nodeId = menuConfigToSave.id;

        if (!menuConfigToSave || !nodeId) {
             alert("Konfigurasi untuk tab aktif tidak valid atau tidak memiliki ID.");
             return false;
        }
        
        console.log(`Menyimpan perubahan layout untuk node: ${nodeId}`);

        try {
            // Ubah seluruh objek konfigurasi menu untuk node ini menjadi string JSON
            const stringifiedNodeConfig = JSON.stringify(menuConfigToSave, null, 2);

            // Siapkan payload untuk fungsi rubahjson.
            // Kita akan mengupdate kolom 'json' di tabel 'node'.
            const payload = {
                json: stringifiedNodeConfig 
            };
            
            // Panggil window.rubahjson untuk mengupdate record di tabel 'node'
            // dimana kolom 'node' cocok dengan 'nodeId' dari menu.
            const response = await window.rubahjson(
                'node',         // Nama tabel target
                payload,        // Data yang akan diupdate: { json: "..." }
                nodeId,         // Nilai untuk klausa WHERE (ID node)
                'node'          // Nama kolom untuk klausa WHERE (field 'node')
            );

           
            if (response.success) {
                console.log('Konfigurasi node berhasil disimpan ke database.');
                vueInstance.unsavedLayoutChanges = false; // Reset flag setelah berhasil
                return true;
            } else {
                alert('Gagal menyimpan konfigurasi: ' + (response.error || 'Unknown error'));
                console.error('Gagal menyimpan konfigurasi:', response);
                return false;
            }
        } catch (error) {
            alert('Error saat menyimpan konfigurasi node. Cek konsol untuk detail.');
            console.error('Error AJAX saat menyimpan konfigurasi node:', error);
            return false;
        }
    },

    initializeNewTabData(selectedMenu, newTabId) {
        // ========== MULAI BLOK PERBAIKAN ==========
        // Buat objek dasar yang LENGKAP dengan semua kemungkinan properti
        const newTab = {
            id: newTabId,
            menuId: selectedMenu.id,
            menuConfig: JSON.parse(JSON.stringify(selectedMenu)),
            type: 'standard', // Default type
            iframeUrl: null,
            dbConfigs: null,
            mainConfigKey: null,
            activeDetailTabKey: null,
            formMode: {},
            currentRecord: {},
            currentIndex: {},
            totalRecords: {},
            dataLoaded: {},
            parentFilterValue: null,
            parentFilterKeyField: null,
            autocompleteResults: {},
            autocompleteSelectedIndex: {},
            showAutocomplete: {},
            selectedFiles: {},
            debounceTimeout: null,
            gridInstances: {},
            gridData: {},
            functionCache: {},
            gridAggregates: {}
        };

        // Sekarang, sesuaikan properti berdasarkan tipe menu
if (selectedMenu.link) {
    // Ini adalah tab iframe
    newTab.type = 'iframe';
    newTab.iframeUrl = selectedMenu.link; // URL dari JSON akan disalin ke sini
} else {
            // Ini adalah tab standar (form/grid)
            newTab.type = 'standard';
            newTab.dbConfigs = JSON.parse(JSON.stringify(selectedMenu.db)) || null;
            newTab.mainConfigKey = selectedMenu.db ? Object.keys(selectedMenu.db)[0] : null;

            if (newTab.dbConfigs) {
                const detailKeys = Object.keys(newTab.dbConfigs).filter(key => key !== newTab.mainConfigKey);
                if (detailKeys.length > 0) {
                    newTab.activeDetailTabKey = detailKeys[0];
                }
                Object.keys(newTab.dbConfigs).forEach(dbKey => {
                    newTab.formMode[dbKey] = 'view';
                    newTab.currentRecord[dbKey] = {};
                    newTab.currentIndex[dbKey] = -1;
                    newTab.totalRecords[dbKey] = 0;
                    newTab.dataLoaded[dbKey] = false;
                    if (newTab.dbConfigs[dbKey].model === 'form' && newTab.dbConfigs[dbKey].specificFields) {
                        newTab.dbConfigs[dbKey].specificFields.forEach(field => {
                            if (field.type === 'autocomplete') {
                                newTab.autocompleteResults[field.id] = [];
                                newTab.autocompleteSelectedIndex[field.id] = -1;
                                newTab.showAutocomplete[field.id] = false;
                            }
                        });
                    }
                });
            }
        }
        
        return newTab;
        // ========== AKHIR BLOK PERBAIKAN ==========
    },
    
    async postOpenMenuDataLoad(vueInstance, newTab) {
        if (newTab.dbConfigs && newTab.mainConfigKey) {
            const mainConfig = newTab.dbConfigs[newTab.mainConfigKey];
            if (mainConfig.model === 'form') {
                await vueInstance.loadFormData(newTab.id, newTab.mainConfigKey, mainConfig, 'first');
            } else if (mainConfig.model === 'grid') {
                await vueInstance.loadGridData(newTab.id, newTab.mainConfigKey, mainConfig);
            }
        }
    },

    async processActiveTabDataLoad(vueInstance, currentTab) {
        // Jangan proses apapun jika ini adalah tab iframe
        if (currentTab.type === 'iframe') {
            return;
        }

        const mainConfigKey = currentTab.mainConfigKey;
        const mainConfig = mainConfigKey ? currentTab.dbConfigs[mainConfigKey] : null;

        if (!mainConfig) {
            console.error("Error di processActiveTabDataLoad: mainConfig tidak ditemukan untuk mainConfigKey", mainConfigKey, "Tab Data:", currentTab);
            return;
        }

        if (mainConfig.filterx) {
            currentTab.parentFilterKeyField = mainConfig.filterx;
            if (mainConfig.model === 'form' && currentTab.currentRecord[mainConfigKey] && currentTab.currentRecord[mainConfigKey][mainConfig.filterx] !== undefined) {
                currentTab.parentFilterValue = currentTab.currentRecord[mainConfigKey][mainConfig.filterx];
            } else if (mainConfig.model === 'grid' && currentTab.gridInstances[mainConfigKey]) {
                const hot = currentTab.gridInstances[mainConfigKey];
                const selected = hot ? hot.getSelectedLast() : null;
                let rowData = null;
                if (selected && selected.length > 0) { 
                    rowData = hot.getSourceDataAtRow(selected[0]); 
                } else if (hot && hot.countRows() > 0 && (hot.getSettings().minSpareRows === 0 || hot.countRows() > hot.getSettings().minSpareRows)) {
                    rowData = hot.getSourceDataAtRow(0);
                }
                currentTab.parentFilterValue = rowData && rowData[mainConfig.filterx] !== undefined ? rowData[mainConfig.filterx] : null;
            } else {
                currentTab.parentFilterValue = null; 
            }
        } else {
            currentTab.parentFilterKeyField = null;
            currentTab.parentFilterValue = null;
        }

        if (mainConfig.model === 'form') {
            const idToLoad = (currentTab.currentRecord[mainConfigKey] && currentTab.currentRecord[mainConfigKey].id)
                ? currentTab.currentRecord[mainConfigKey].id : null;
            await vueInstance.loadFormData(currentTab.id, mainConfigKey, mainConfig,
                idToLoad ? 'specificId' : (currentTab.totalRecords[mainConfigKey] > 0 ? 'first' : null),
                idToLoad
            );
        } else if (mainConfig.model === 'grid') {
            await vueInstance.loadGridData(currentTab.id, mainConfigKey, mainConfig); 
        }
        vueInstance.refreshDetailGrids(currentTab.id, mainConfigKey);
    },

    refreshDetailGridsOrchestration(vueInstance, tabId, actingParentConfigKey) {
        const currentTab = vueInstance.openTabs.find(tab => tab.id === tabId);
        if (!currentTab || !currentTab.dbConfigs || !actingParentConfigKey) {
            console.warn(`refreshDetailGridsOrchestration: Tab atau dbConfigs atau actingParentConfigKey tidak valid untuk tabId: ${tabId}`);
            return;
        }

        const parentConfig = currentTab.dbConfigs[actingParentConfigKey];
        if (!parentConfig) {
            console.warn(`refreshDetailGridsOrchestration: parentConfig tidak ditemukan untuk actingParentConfigKey: ${actingParentConfigKey}`);
            return;
        }
        
        const filterValueToApply = currentTab.parentFilterValue;

        Object.keys(currentTab.dbConfigs).forEach(childConfigKey => {
            if (childConfigKey === actingParentConfigKey) return; 

            const childConfig = currentTab.dbConfigs[childConfigKey];
            if (childConfig.model === 'grid') {
                if (childConfig.filter) { 
                    const finalFilterValue = (parentConfig.filterx && filterValueToApply !== null && filterValueToApply !== undefined)
                                             ? filterValueToApply
                                             : null;
                    vueInstance.loadGridData(tabId, childConfigKey, childConfig, finalFilterValue);
                } else {
                    vueInstance.loadGridData(tabId, childConfigKey, childConfig, null);
                }
            }
        });
    },

    async populateDynamicDropdowns(tab) {
        if (!tab || !tab.dbConfigs) {
            return; // Keluar jika tab atau konfigurasinya tidak valid
        }
        // Loop melalui setiap konfigurasi (form/grid) di dalam tab
        for (const configKey in tab.dbConfigs) {
            const config = tab.dbConfigs[configKey];
            // Pastikan ada specificFields untuk di-loop
            if (config.specificFields && Array.isArray(config.specificFields)) {
                // Loop melalui setiap field di dalam konfigurasi
                for (const field of config.specificFields) {
                    // CARI FIELD YANG SESUAI: type 'dropdown' DAN memiliki properti 'link'
                    if (field.type === 'dropdown' && field.link && Array.isArray(field.link) && field.link.length > 0) {
                    
                        // Jika source sudah diisi sebelumnya, lewati agar tidak load berulang kali
                        if (Array.isArray(field.source) && field.source.length > 0) {
                            continue;
                        }

                        const linkConfig = field.link[0];
                        try {
                            // Ambil semua data dari tabel yang ditentukan di 'link'
                            const dataFromDb = await window.ambil(linkConfig.table, 'id', '0', '99999999999');
// alert(dataFromDb);
// alert(JSON.stringify(dataFromDb));
                            if (dataFromDb && Array.isArray(dataFromDb)) {
                                // Ubah format data menjadi "VALUE _ LABEL"
                                const formattedSource = dataFromDb.map(row => {
                                    const value = row[linkConfig.field1];
                                    const label = row[linkConfig.field2];
                                    return `${value} _ ${label}`;
                                });

                                // Suntikkan data yang sudah diformat ke properti 'source'
                                field.source = formattedSource;
                                console.log(`Dropdown dinamis '${field.id}' berhasil diisi dari tabel '${linkConfig.table}'.`);
                            }
                        } catch (error) {
                            console.error(`Gagal mengambil data untuk dropdown dinamis '${field.id}' dari tabel '${linkConfig.table}':`, error);
                            // Jika gagal, isi dengan pesan error
                            field.source = [`ERROR _ Gagal Memuat Data`];
                        }
                    }
                }
            }
        }
        // Memaksa Vue untuk mendeteksi perubahan dalam objek/array
        if (window.vm) {
            window.vm.$forceUpdate();
        }
    }

};