<?php
// Konfigurasi Database
// $host = 'localhost';
// $user = 'root';
// $pass = '';
// $db   = 'pos_m';

// Set header ke JSON
header('Content-Type: application/json');

// Koneksi ke database
try {
include_once '../data.php';
$conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        throw new Exception("Koneksi gagal: " . $conn->connect_error);
    }
    $conn->set_charset("utf8");
    $conn->autocommit(FALSE); // Set autocommit ke false untuk kontrol transaksi manual
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    exit();
}

// Ambil aksi dari request (bisa dari GET atau POST)
$action = $_REQUEST['action'] ?? '';

switch ($action) {
    // Aksi untuk mengambil semua nama laporan
    case 'fetch':
        $result = $conn->query("SELECT report_name FROM pivot_reports ORDER BY report_name ASC");
        $reports = [];
        while ($row = $result->fetch_assoc()) {
            $reports[] = $row['report_name'];
        }
        echo json_encode($reports);
        break;

    // Aksi untuk memuat satu laporan berdasarkan nama
    case 'load':
        $reportName = $_GET['reportName'] ?? '';
        if (empty($reportName)) {
            // Jika nama laporan kosong, kirim JSON kosong dan hentikan eksekusi
            echo '{}';
            exit();
        }

        $stmt = $conn->prepare("SELECT report_data FROM pivot_reports WHERE report_name = ?");
        $stmt->bind_param("s", $reportName);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $reportData = $row['report_data'];
            
            // Validasi apakah data adalah JSON yang valid
            $decodedData = json_decode($reportData, true);
            if (json_last_error() === JSON_ERROR_NONE) {
                // Cek apakah data adalah array (bukan object yang diharapkan)
                if (is_array($decodedData) && isset($decodedData[0])) {
                    // Ini adalah array data, bukan template settings
                    // Kembalikan structure kosong karena ini bukan template yang valid
                    echo '{}';
                } else {
                    // Data adalah object yang valid, kirim sebagaimana adanya
                    echo $reportData; // Kirim raw JSON string
                }
            } else {
                // Jika JSON tidak valid, kirim JSON kosong
                echo '{}';
            }
        } else {
            // Jika laporan tidak ditemukan, kirim JSON kosong
            echo '{}';
        }
        exit(); 
        break;

    // Aksi untuk menyimpan laporan
    case 'save':
        $reportName = $_POST['reportName'] ?? '';
        $reportData = $_POST['report'] ?? '';
        
        // Validasi input
        if (empty($reportName)) {
            echo json_encode(['status' => 'error', 'message' => 'Nama laporan tidak boleh kosong']);
            break;
        }
        
        if (empty($reportData)) {
            echo json_encode(['status' => 'error', 'message' => 'Data laporan tidak boleh kosong']);
            break;
        }
        
        // Validasi apakah reportData adalah JSON yang valid
        $decodedReport = json_decode($reportData, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            echo json_encode(['status' => 'error', 'message' => 'Data laporan bukan JSON yang valid']);
            break;
        }
        
        // Cek dulu apakah nama sudah ada (untuk menentukan INSERT atau UPDATE)
        $stmt_check = $conn->prepare("SELECT id FROM pivot_reports WHERE report_name = ?");
        $stmt_check->bind_param("s", $reportName);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        try {
            if ($result_check->num_rows > 0) {
                // Jika sudah ada, UPDATE
                $stmt = $conn->prepare("UPDATE pivot_reports SET report_data = ?, updated_at = NOW() WHERE report_name = ?");
                $stmt->bind_param("ss", $reportData, $reportName);
            } else {
                // Jika belum ada, INSERT
                $stmt = $conn->prepare("INSERT INTO pivot_reports (report_name, report_data, created_at, updated_at) VALUES (?, ?, NOW(), NOW())");
                $stmt->bind_param("ss", $reportName, $reportData);
            }

            if ($stmt->execute()) {
                $conn->commit(); // Commit transaksi
                echo json_encode(['status' => 'success', 'message' => 'Laporan berhasil disimpan']);
            } else {
                $conn->rollback(); // Rollback jika ada error
                echo json_encode(['status' => 'error', 'message' => 'Gagal menyimpan laporan: ' . $stmt->error]);
            }
        } catch (Exception $e) {
            $conn->rollback(); // Rollback jika ada exception
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }
        break;
        
    // Aksi untuk menghapus laporan
    case 'remove':
        $reportName = $_POST['reportName'] ?? '';
        
        if (empty($reportName)) {
            echo json_encode(['status' => 'error', 'message' => 'Nama laporan tidak boleh kosong']);
            break;
        }
        
        try {
            $stmt = $conn->prepare("DELETE FROM pivot_reports WHERE report_name = ?");
            $stmt->bind_param("s", $reportName);
            if ($stmt->execute()) {
                $conn->commit();
                echo json_encode(['status' => 'success', 'message' => 'Laporan berhasil dihapus']);
            } else {
                $conn->rollback();
                echo json_encode(['status' => 'error', 'message' => 'Gagal menghapus laporan: ' . $stmt->error]);
            }
        } catch (Exception $e) {
            $conn->rollback();
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }
        break;

    // Aksi untuk mengubah nama laporan
    case 'rename':
        $oldName = $_POST['oldReportName'] ?? '';
        $newName = $_POST['newReportName'] ?? '';
        
        if (empty($oldName) || empty($newName)) {
            echo json_encode(['status' => 'error', 'message' => 'Nama lama dan nama baru tidak boleh kosong']);
            break;
        }
        
        try {
            $stmt = $conn->prepare("UPDATE pivot_reports SET report_name = ?, updated_at = NOW() WHERE report_name = ?");
            $stmt->bind_param("ss", $newName, $oldName);
            if ($stmt->execute()) {
                $conn->commit();
                echo json_encode(['status' => 'success', 'message' => 'Nama laporan berhasil diubah']);
            } else {
                $conn->rollback();
                echo json_encode(['status' => 'error', 'message' => 'Gagal mengubah nama laporan: ' . $stmt->error]);
            }
        } catch (Exception $e) {
            $conn->rollback();
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }
        break;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Aksi tidak valid']);
        break;
}

$conn->close();
?>