<?php
// Debug script untuk melihat apa yang tersimpan dalam database
$host = 'localhost';
$user = 'root';
$pass = '';
$db   = 'pos_m';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Ambil data template "bb"
$stmt = $conn->prepare("SELECT report_name, report_data FROM pivot_reports WHERE report_name = ?");
$reportName = 'bb';
$stmt->bind_param("s", $reportName);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo "<h3>Template: " . $row['report_name'] . "</h3>";
    echo "<h4>Raw Data:</h4>";
    echo "<pre>" . htmlspecialchars($row['report_data']) . "</pre>";
    
    echo "<h4>JSON Decoded:</h4>";
    $decoded = json_decode($row['report_data'], true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "<pre>" . print_r($decoded, true) . "</pre>";
        
        // Cek struktur
        echo "<h4>Struktur Check:</h4>";
        echo "Has dataSourceSettings: " . (isset($decoded['dataSourceSettings']) ? "YES" : "NO") . "<br>";
        if (isset($decoded['dataSourceSettings'])) {
            echo "dataSourceSettings keys: " . implode(', ', array_keys($decoded['dataSourceSettings'])) . "<br>";
        }
    } else {
        echo "JSON Error: " . json_last_error_msg();
    }
} else {
    echo "Template 'bb' tidak ditemukan!";
}

$conn->close();
?>