<?php
// Konfigurasi Database
// $host = 'localhost';
// $user = 'root';
// $pass = '';
// $db   = 'pos_m';

// Koneksi
include_once '../data.php';
$conn = new mysqli($servername, $username, $password, $dbname);
// $conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Default range tanggal: bulan ini
$start_date = date('Y-m-01');
$end_date = date('Y-m-t');

// Jika form disubmit, ambil dari input
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
}

// Query utama
$sql = "
SELECT 
    jual.brand,
    jual.cab,
    tipe_transaksi.nama AS tipe_nama,
    jual.mesin,
    jual.nomor,
    jual.tanggal,
    jual.jamm,
    jual.shift,
    jual.cover,
    jual.user AS user_jual,
    jual.batal,
    jual.kasir,
    jual.register,
    jual.deliver,
    pesani.sub,
    pesani.payment,
    pesani.tglo,
    pesani.kode,
    pesani.name AS nama_barang,
    pesani.group_name,
    pesani.quantity,
    pesani.harga,
    pesani.price,
    pesani.discp,
    pesani.discr,
    pesani.netto,
    pesani.disc,
    pesani.ppn,
    pesani.pajak,
    pesani.serv,
    pesani.service,
    pesani.jumlah,
    pesani.meja,
    pesani.user AS user_pesani
FROM jual
LEFT JOIN pesani ON jual.nomor = pesani.nomor
LEFT JOIN tipe_transaksi ON jual.tipe = tipe_transaksi.kode
WHERE jual.tanggal BETWEEN ? AND ?
  AND jual.batal = 0
ORDER BY jual.tanggal ASC, jual.nomor ASC, pesani.kode ASC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $start_date, $end_date);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    // Ganti NULL dengan '-' agar tampil rapi
    foreach ($row as $key => $value) {
        $row[$key] = $value !== null ? $value : '-';
    }
    $data[] = $row;
}

$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan Penjualan Sederhana</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        h2 { color: #333; }
        .filter { background: #f5f5f5; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        label { display: inline-block; width: 120px; font-weight: bold; }
        input[type="date"] { padding: 6px; margin-right: 10px; border: 1px solid #ccc; border-radius: 4px; }
        button { 
            padding: 8px 20px; 
            background: #28a745; 
            color: white; 
            border: none; 
            border-radius: 4px; 
            cursor: pointer; 
        }
        button:hover { background: #218838; }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin-top: 20px; 
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        th, td { 
            padding: 10px; 
            text-align: left; 
            border-bottom: 1px solid #ddd; 
        }
        th { 
            background-color: #007bff; 
            color: white; 
            position: sticky; 
            top: 0; 
        }
        tr:hover { background-color: #f5f5f5; }
        .no-data { color: #dc3545; font-weight: bold; margin-top: 20px; }
    </style>
</head>
<body>

<h2>📋 Laporan Penjualan Sederhana</h2>

<!-- Form Filter -->
<div class="filter">
    <form method="POST">
        <label>Tanggal Mulai:</label>
        <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" required>
        
        <label>Tanggal Akhir:</label>
        <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" required>
        
        <button type="submit">Tampilkan Laporan</button>
    </form>
</div>

<?php if (empty($data)): ?>
    <p class="no-data">❌ Tidak ada data penjualan untuk rentang tanggal ini.</p>
<?php else: ?>
    <p><strong>📅 Menampilkan <?= count($data) ?> baris data</strong> dari tanggal <strong><?= $start_date ?></strong> sampai <strong><?= $end_date ?></strong></p>

    <!-- Tabel Data -->
    <div style="overflow-x: auto;">
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Tanggal</th>
                    <th>No Transaksi</th>
                    <th>Kasir</th>
                    <th>Tipe</th>
                    <th>Meja</th>
                    <th>Kode Barang</th>
                    <th>Nama Barang</th>
                    <th>Group</th>
                    <th>Qty</th>
                    <th>Harga Satuan</th>
                    <th>Jumlah</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php foreach ($data as $row): ?>
                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= htmlspecialchars($row['tanggal']) ?></td>
                    <td><?= htmlspecialchars($row['nomor']) ?></td>
                    <td><?= htmlspecialchars($row['kasir']) ?></td>
                    <td><?= htmlspecialchars($row['tipe_nama']) ?></td>
                    <td><?= htmlspecialchars($row['meja']) ?></td>
                    <td><?= htmlspecialchars($row['kode']) ?></td>
                    <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                    <td><?= htmlspecialchars($row['group_name']) ?></td>
                    <td style="text-align: right;"><?= htmlspecialchars($row['quantity']) ?></td>
                    <td style="text-align: right;"><?= number_format($row['harga'], 0, ',', '.') ?></td>
                    <td style="text-align: right;"><?= number_format($row['jumlah'], 0, ',', '.') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="11" style="text-align: right;">TOTAL</th>
                    <th style="text-align: right;">
                        <?= number_format(array_sum(array_column($data, 'jumlah')), 0, ',', '.') ?>
                    </th>
                </tr>
            </tfoot>
        </table>
    </div>
<?php endif; ?>

</body>
</html>