<?php
// Atur header untuk output JSON
header('Content-Type: application/json');

// --- GANTI DENGAN KONEKSI DATABASE ANDA ---
include_once 'data.php';

// -----------------------------------------

// Ambil parameter tanggal dari URL, dengan nilai default
$startDate = isset($_GET['start_date']) ? $_GET['start_date'] : '2025-08-01';
$endDate = isset($_GET['end_date']) ? $_GET['end_date'] : '2025-08-31';

// Buat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Cek koneksi
if ($conn->connect_error) {
    die(json_encode(['error' => 'Connection failed: ' . $conn->connect_error]));
}

// Query SQL yang sudah disiapkan (tidak perlu diubah)
$sql = "
    SELECT
        j.tanggal, j.nomor, j.shift, j.meja, j.user AS user_transaksi, j.kasir, j.jamm,
        p.kode AS kode_barang, p.name AS nama_barang, p.kgroup AS kode_grup,
        p.group_name AS nama_grup, p.quantity, p.harga, p.disc AS diskon_item,
        p.pajak, p.service, p.jumlah, p.user, c.singkat as cabang
    FROM
        jual j
    INNER JOIN
        pesani p ON j.nomor = p.nomor
    INNER JOIN
        cabang c ON j.cab = c.kode
    WHERE
        j.tanggal BETWEEN ? AND ?
        AND (p.payment IS NULL OR p.payment = '')
";

// Gunakan prepared statement untuk keamanan
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $startDate, $endDate);
$stmt->execute();
$result = $stmt->get_result();

$data = array();

// Array mapping untuk mengubah nama hari dan bulan ke Bahasa Indonesia
$hariIndonesia = ['Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa', 'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat', 'Saturday' => 'Sabtu'];
$bulanIndonesia = ['January' => '01. Januari', 'February' => '02. Februari', 'March' => '03. Maret', 'April' => '04. April', 'May' => '05. Mei', 'June' => '06. Juni', 'July' => '07. Juli', 'August' => '08. Agustus', 'September' => '09. September', 'October' => '10. Oktober', 'November' => '11. November', 'December' => '12. Desember'];


if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        // --- PENAMBAHAN KOLOM BARU DIMULAI DI SINI ---

        // 1. Tambah kolom Hari
        $timestamp = strtotime($row['tanggal']);
        $englishDay = date('l', $timestamp);
        $row['hari'] = $hariIndonesia[$englishDay];

        // 2. Tambah kolom Bulan (dengan nomor agar urut)
        $englishMonth = date('F', $timestamp);
        $row['bulan'] = $bulanIndonesia[$englishMonth];
        
        // 3. Tambah kolom Jam
        $hour = (int)date('H', strtotime($row['jamm']));
        $row['jam'] = $hour;

        // 4. Tambah kolom Sesi Waktu (Pagi/Siang/Malam)
        if ($hour >= 4 && $hour < 11) $row['sesi_waktu'] = 'Pagi';
        elseif ($hour >= 11 && $hour < 15) $row['sesi_waktu'] = 'Siang';
        elseif ($hour >= 15 && $hour < 19) $row['sesi_waktu'] = 'Sore';
        else $row['sesi_waktu'] = 'Malam';

        // 5. Tambah kolom Tipe Pesanan yang lebih deskriptif
        if (strtoupper($row['meja']) == 'DI') $row['tipe_pesanan'] = 'Dine In';
        elseif (strtoupper($row['meja']) == 'TA') $row['tipe_pesanan'] = 'Take Away';
        else $row['tipe_pesanan'] = 'Lainnya';
        
        // --- AKHIR PENAMBAHAN KOLOM BARU ---

        // Mengubah tipe data numerik dari string ke number
        $row['quantity'] = (float)$row['quantity'];
        $row['harga'] = (float)$row['harga'];
        $row['diskon_item'] = (float)$row['diskon_item'];
        $row['pajak'] = (float)$row['pajak'];
        $row['service'] = (float)$row['service'];
        $row['jumlah'] = (float)$row['jumlah'];
        $data[] = $row;
    }
}

// Tutup koneksi
$stmt->close();
$conn->close();

// Cetak hasil dalam format JSON
echo json_encode($data);
?>