<?php
header('Content-Type: application/json');
// error_reporting(E_ALL); // Aktifkan hanya saat development
// ini_set('display_errors', 1); // Aktifkan hanya saat development

// Memuat konfigurasi koneksi
$config = include('config.php');

try {
    // Koneksi ke database menggunakan PDO
    $pdo = new PDO(
        "mysql:host=" . $config['host'] . ";dbname=" . $config['dbname'],
        $config['username'],
        $config['password']
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Ambil dan decode JSON input
    $jsonInput = file_get_contents('php://input');
    if (!$jsonInput) {
        throw new Exception("Tidak ada data yang diterima.");
    }

    $input = json_decode($jsonInput, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Format JSON tidak valid: " . json_last_error_msg());
    }

    // Validasi struktur input
    if (!isset($input['table']) || !isset($input['data']) || !is_array($input['data'])) {
        throw new Exception("Struktur input tidak valid. Harus ada 'table' dan 'data'.");
    }

    $table = $input['table'];
    
    // Mulai transaksi database untuk memastikan semua data berhasil dimasukkan atau tidak sama sekali
    $pdo->beginTransaction();

    foreach ($input['data'] as $row) {
        // Ambil nama kolom dan nilainya
        $columns = array_keys($row);
        $values = array_values($row);
        
        // Buat placeholder untuk prepared statement (contoh: ?, ?, ?)
        $placeholders = implode(', ', array_fill(0, count($columns), '?'));
        
        // Bungkus nama kolom dengan backticks untuk keamanan
        $quotedColumns = array_map(function($col) {
            return "`" . str_replace("`", "``", $col) . "`";
        }, $columns);
        
        // Buat query SQL
        $sql = "INSERT INTO `{$table}` (" . implode(', ', $quotedColumns) . ") VALUES ({$placeholders})";

        // Siapkan dan eksekusi statement
        $stmt = $pdo->prepare($sql);
        $stmt->execute($values);
    }

    // Jika semua query berhasil, commit transaksi
    $pdo->commit();

    // Kirim respons sukses
    echo json_encode([
        'success' => true,
        'message' => "Data berhasil disimpan ke tabel '{$table}'."
    ]);

} catch (Exception $e) {
    // Jika ada error, batalkan semua perubahan (rollback)
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    
    // Catat error ke log server untuk debugging nanti
    error_log("Error di insert_data.php: " . $e->getMessage());
    
    // Kirim respons error ke client
    http_response_code(500); // Set status error 500
    echo json_encode([
        'success' => false,
        'message' => 'Terjadi kesalahan di server: ' . $e->getMessage()
    ]);
}
?>