// print-server.js

import { WebSocketServer } from 'ws';
// import { Printer, ThermalPrinter, PrinterTypes, CharacterSet, BreakLine } from 'node-thermal-printer';
import pkg from 'node-thermal-printer';
const { Printer, ThermalPrinter, PrinterTypes, CharacterSet, BreakLine } = pkg;

console.log("Memulai server printer...");

// Konfigurasi Printer Thermal
// Ganti PrinterTypes.EPSON dengan tipe printer Anda jika berbeda
// Untuk Windows, device bisa berupa 'LPT1' atau 'PRN'. Cek nama printer di Control Panel.
let printer = new ThermalPrinter({
  type: PrinterTypes.EPSON,    // Tipe printer, EPSON adalah yang paling umum
  interface: 'LPT1',           // Interface printer. Untuk USB, Anda mungkin perlu mencari nama port COM virtualnya. 'PRN' adalah alias umum di Windows.
  characterSet: CharacterSet.PC852_LATIN2, // Sesuaikan character set jika perlu
  breakLine: BreakLine.WORD,   // Aturan pemotongan baris
  driver: null                 // Gunakan null untuk direct printing ke LPT/COM
});


// Konfigurasi Server WebSocket
const wss = new WebSocketServer({ port: 8080 });

wss.on('connection', ws => {
  console.log('Client Kiosk terhubung!');

  ws.on('message', async message => {
    console.log('Menerima data pesanan...');
    
    try {
      const order = JSON.parse(message);
      console.log('Mencetak struk untuk transaksi:', order.transactionId);

      // Mulai proses pencetakan
      printer.clear();
      printer.alignCenter();
      printer.println("Kiosk Mart");
      printer.println("Jl. Teknologi No. 1, Bandung");
      printer.println("--------------------------------");
      
      printer.alignLeft();
      printer.println(`No. Transaksi: ${order.transactionId}`);
      printer.println(`Pelanggan    : ${order.customerName}`);
      printer.println(`Tanggal      : ${order.timestamp}`);
      printer.println("--------------------------------");

      // Cetak item pesanan
      printer.tableCustom([
        { text: "Item", align: "LEFT", width: 0.5 },
        { text: "Qty", align: "CENTER", width: 0.15 },
        { text: "Total", align: "RIGHT", width: 0.35 }
      ]);
      
      order.items.forEach(item => {
        printer.tableCustom([
            { text: item.name, align: "LEFT", width: 0.5 },
            { text: item.quantity.toString(), align: "CENTER", width: 0.15 },
            { text: item.total.toLocaleString('id-ID'), align: "RIGHT", width: 0.35 }
        ]);
      });
      
      printer.println("--------------------------------");
      
      // Cetak total
      printer.alignRight();
      printer.bold(true);
      printer.println(`TOTAL: Rp ${order.total.toLocaleString('id-ID')}`);
      printer.bold(false);
      
      // Footer dan QR Code (jika printer mendukung)
      printer.alignCenter();
      printer.println("\nTerima kasih telah berbelanja!");
      // printer.printQR(order.transactionId); // Uncomment jika printer Anda mendukung pencetakan QR

      printer.cut();

      // Eksekusi pencetakan
      await printer.execute();
      console.log("Struk berhasil dicetak!");

    } catch (err) {
      console.error("Gagal mencetak struk:", err);
    }
  });

  ws.on('close', () => {
    console.log('Koneksi Kiosk terputus.');
  });
});

console.log('Server printer berjalan di ws://localhost:8080');
