<?php
// File: simpan_master_lokal.php
// Lokasi: Server Lokal (satu folder dengan file POS Anda)

header('Content-Type: application/json');

// --- Konfigurasi Database Lokal ---


// Ambil data JSON yang dikirim dari JavaScript
$input = json_decode(file_get_contents('php://input'), true);

$table = $input['table'] ?? null;
$data = $input['data'] ?? null;

// Validasi input
if (empty($table) || !isset($data) || !is_array($data)) {
    echo json_encode(['success' => false, 'error' => 'Input tidak valid (tabel atau data kosong).']);
    exit;
}

include_once 'data.php';
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Koneksi DB Lokal Gagal: ' . $conn->connect_error]);
    exit;
}

// Gunakan transaksi untuk memastikan semua data masuk atau tidak sama sekali
$conn->begin_transaction();

try {
    // 1. Kosongkan tabel (TRUNCATE)
    $conn->query("TRUNCATE TABLE `$table`");

    // Jika tidak ada data untuk di-insert, proses selesai
    if (empty($data)) {
        $conn->commit();
        echo json_encode(['success' => true, 'message' => "Tabel $table dikosongkan (tidak ada data baru)."]);
        exit;
    }

    // 2. Siapkan statement INSERT
    $fields = array_keys($data[0]);
    $field_list = '`' . implode('`, `', $fields) . '`';
    $placeholders = implode(',', array_fill(0, count($fields), '?'));
    
    $stmt = $conn->prepare("INSERT INTO `$table` ($field_list) VALUES ($placeholders)");

    // Dapatkan tipe data untuk bind_param (s = string, i = integer, d = double)
    // Untuk simple, kita asumsikan semua string untuk menghindari error tipe data
    $types = str_repeat('s', count($fields));

    // 3. Insert setiap baris data
    foreach ($data as $row) {
        $values = array_values($row);
        $stmt->bind_param($types, ...$values);
        $stmt->execute();
    }

    // Jika semua berhasil, commit transaksi
    $conn->commit();
    echo json_encode(['success' => true, 'message' => 'Data berhasil disimpan.']);

} catch (Exception $e) {
    // Jika ada error di tengah jalan, batalkan semua perubahan (rollback)
    $conn->rollback();
    echo json_encode(['success' => false, 'error' => "Gagal menyimpan ke tabel '$table': " . $e->getMessage()]);
}

$conn->close();
?>