xbrand = '001';
xcab = '002';
const { createApp } = Vue

const app = createApp({
    data() {
        return {
            items: [
                {
                    "id": "0000260513",
                    "kode": "19",
                    "name": "Kwetiau Goreng",
                    "meja": "17",
                    "quantity": 3,
                    "split": ""
                },
                {
                    "id": "0000059509",
                    "kode": "17",
                    "name": "Mie Goreng",
                    "meja": "17",
                    "quantity": 2,
                    "split": ""
                },
                {
                    "id": "0000160851",
                    "kode": "18",
                    "name": "Mie Ayam",
                    "meja": "17",
                    "quantity": 4,
                    "split": ""
                }
            ],
            gridCodes: [],
            selectedGridCode: '',
            selectedMasterItem: '',
            selectedSplitItem: '',
            GRID_CODES: 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
        }
    },
    computed: {
        masterTitle() {
            const tableNumber = new URLSearchParams(window.location.search).get('meja') || ''
            return tableNumber ? `Master Bill ${tableNumber}` : 'Master Grid'
        },
        unsplitItems() {
            return this.items.filter(item => item.split === '')
        }
    },
    mounted() {
        bx = ambil('cart', 'meja', '17');
        bx=JSON.parse(bx);
        bx=bx[0].cart;
        this.items=JSON.parse(bx);
        this.items[0].split='A';
        this.items = this.items.map(item => {
              return {
              ...item, // Menyalin semua properti yang ada pada item
              split: "" // Menambahkan field split dengan nilai "00"
             };
       }),
        alert(JSON.stringify(this.items));

    },
    methods: {
        getGridItems(code) {
            return this.items.filter(item => item.split === code)
        },
        selectMasterItem(id) {
            this.selectedMasterItem = id
            this.selectedSplitItem = ''
        },
        selectGrid(code) {
            this.selectedGridCode = code
            this.selectedSplitItem = ''
        },
        selectSplitItem(id) {
            this.selectedSplitItem = id
            this.selectedMasterItem = ''
        },
        getNextAvailableGridCode() {
            return this.GRID_CODES.split('').find(code => !this.gridCodes.includes(code))
        },
        addGrid() {
            const nextCode = this.getNextAvailableGridCode()
            if (nextCode) {
                this.gridCodes.push(nextCode)
                this.selectGrid(nextCode)
            }
        },
        removeGrid(code) {
            alert(JSON.stringify(this.items));
            this.returnAllItems()
            const index = this.gridCodes.indexOf(code)
            if (index > -1) {
                this.gridCodes.splice(index, 1)
            }
            if (this.selectedGridCode === code) {
                this.selectedGridCode = ''
                this.selectedSplitItem = ''
            }
        },
        moveOnePiece() {
            if (!this.selectedGridCode || !this.selectedMasterItem) return
            
            const itemIndex = this.items.findIndex(item => item.id === this.selectedMasterItem)
            if (itemIndex === -1 || this.items[itemIndex].quantity <= 0) return

            const existingInTarget = this.items.find(item => 
                item.id === this.selectedMasterItem && 
                item.split === this.selectedGridCode
            )

            if (existingInTarget) {
                existingInTarget.quantity++
                this.items[itemIndex].quantity--

                if (this.items[itemIndex].quantity === 0) {
                    this.items.splice(itemIndex, 1)
                }
            } else {
                const sourceItem = this.items[itemIndex]
                const newItem = {
                    ...sourceItem,
                    quantity: 1,
                    split: this.selectedGridCode
                }
                this.items.push(newItem)
                
                sourceItem.quantity--
                
                if (sourceItem.quantity === 0) {
                    this.items.splice(itemIndex, 1)
                }
            }
        },
        moveEntireMenu() {
            if (!this.selectedGridCode || !this.selectedMasterItem) return
            
            const itemIndex = this.items.findIndex(item => item.id === this.selectedMasterItem)
            if (itemIndex === -1) return

            const sourceItem = this.items[itemIndex]
            
            const existingInTarget = this.items.find(item => 
                item.id === this.selectedMasterItem && 
                item.split === this.selectedGridCode
            )

            if (existingInTarget) {
                existingInTarget.quantity += sourceItem.quantity
                this.items.splice(itemIndex, 1)
            } else {
                this.items[itemIndex].split = this.selectedGridCode
            }
        },
        moveAllItems() {
            if (!this.selectedGridCode) return
            
            const unsplitItems = this.items.filter(item => item.split === '')
            unsplitItems.forEach(item => {
                item.split = this.selectedGridCode
            })
        },
        returnOnePiece() {
            if (!this.selectedGridCode || !this.selectedSplitItem) return

            const itemIndex = this.items.findIndex(item => 
                item.id === this.selectedSplitItem && 
                item.split === this.selectedGridCode
            )
            
            if (itemIndex === -1) return
            
            const splitItem = this.items[itemIndex]
            
            let masterItem = this.items.find(item => 
                item.id === this.selectedSplitItem && 
                item.split === ''
            )

            if (masterItem) {
                masterItem.quantity++
            } else {
                masterItem = {
                    ...splitItem,
                    quantity: 1,
                    split: ''
                }
                this.items.push(masterItem)
            }

            splitItem.quantity--
            
            if (splitItem.quantity === 0) {
                this.items.splice(itemIndex, 1)
            }

            this.selectedSplitItem = ''
        },
        returnEntireMenu() {
            if (!this.selectedGridCode || !this.selectedSplitItem) return
            
            const itemIndex = this.items.findIndex(item => 
                item.id === this.selectedSplitItem && 
                item.split === this.selectedGridCode
            )
            
            if (itemIndex === -1) return

            const splitItem = this.items[itemIndex]
            
            let masterItem = this.items.find(item => 
                item.id === this.selectedSplitItem && 
                item.split === ''
            )

            if (masterItem) {
                masterItem.quantity += splitItem.quantity
                this.items.splice(itemIndex, 1)
            } else {
                splitItem.split = ''
            }

            this.selectedSplitItem = ''
        },
        returnAllItems() {
            if (!this.selectedGridCode) return
            
            const splitItems = this.items.filter(item => item.split === this.selectedGridCode)
            
            splitItems.forEach(splitItem => {
                const masterItem = this.items.find(item => 
                    item.id === splitItem.id && 
                    item.split === ''
                )
                
                if (masterItem) {
                    masterItem.quantity += splitItem.quantity
                    const index = this.items.indexOf(splitItem)
                    this.items.splice(index, 1)
                } else {
                    splitItem.split = ''
                }
            })

            this.selectedSplitItem = ''
        },
        handleBill(code) {
            alert(`Bill for Grid ${code}`)
        },
        handlePayment(code) {
            alert(`Payment for Grid ${code}`)
        }
    }
})

app.mount('#app')
