cartSubtotal() {
    let itemb = 0, zitem = 0, total = 0, disc = 0, service = 0, pajak = 0, xpayment = 0, xcash = 0, xcard = 0;

    // Memanggil fungsi untuk menentukan jenis diskon yang aktif (item atau faktur)
    this.findAndApplyDiscount();

    // Loop pertama: Menghitung total item, diskon item, service, pajak, dan pembayaran
    this.cart.forEach(item => {
        if (item.split == '') {
            if (!item.payment) {
                // Kalkulasi harga item termasuk topping
                let xx = Number(item.price);
                if (item.toppings) {
                    for (const toppingGroupx of item.toppings) {
                        for (const itemx of toppingGroupx.items) {
                            if (itemx.harga > 0) {
                                xx += itemx.harga;
                            }
                        }
                    }
                }

                const xtotal = Math.round(xx * item.quantity);
                item.harga = xx;
                const discp = parseFloat(item.discp) || 0;
                const discr = parseFloat(item.discr) || 0;
                item.serv = parseFloat(item.serv) || parseFloat(this.pos.service) || 0;
                item.ppn = parseFloat(item.ppn) || parseFloat(this.pos.pajak) || 0;
                item.jumlah = item.harga * item.quantity;

                // Menghitung diskon per item (jika ada)
                item.disc = Math.round(xtotal * (discp / 100) + discr);
                item.service = Math.round((xtotal - item.disc) * (item.serv / 100));
                item.pajak = Math.round((xtotal - item.disc + item.service) * (item.ppn / 100));
                item.netto = Math.round(xtotal - item.disc + item.service + item.pajak);

                // Akumulasi total
                zitem += 1;
                total += item.jumlah;
                disc += item.disc;
                service += item.service;
                pajak += item.pajak;
            } else {
                // Akumulasi pembayaran
                xcash += (item.payment === '10') ? item.harga : 0;
                xcard += (item.payment === '12') ? item.harga : 0;
                xpayment += item.harga;
                itemb += 1;
            }
        }
    });

    // ===============================================
    // === LOGIKA BARU UNTUK MENGHITUNG DISKON FAKTUR ===
    // ===============================================
    this.xtdiscf = 0; // Reset diskon faktur di setiap perhitungan ulang
    const discountFlag = this.cart.find(item => String(item.payment).trim() == '06');

    if (discountFlag) {
        const discountRule = this.masterd.find(d => d.kode === discountFlag.kode);
        if (discountRule) {
            const minPurchase = parseFloat(discountRule.min) || 0;
            // Hanya berlaku jika tipe diskon adalah faktur (min > 0) dan total belanja mencukupi
            if (minPurchase > 0 && total >= minPurchase) {
                const maxDiscount = parseFloat(discountRule.max) || 0;
                const discp = parseFloat(discountRule.discp) || 0;

                // Hitung potensi diskon dari subtotal
                const potentialDiscount = total * (discp / 100);

                // Terapkan batas maksimum diskon jika ada (jika max > 0)
                this.xtdiscf = (maxDiscount > 0) ? Math.min(potentialDiscount, maxDiscount) : potentialDiscount;
            }
        }
    }
    // =================================================

    // Finalisasi semua nilai total untuk ditampilkan di UI
    this.cart2 = this.cart;
    this.xsubtotal = total;
    this.xtdisc = disc; // Ini adalah total diskon per-item
    this.xtservice = service;
    this.xtpajak = pajak;

    // Grand total sekarang dikurangi diskon item DAN diskon faktur
    this.xgrandtotal = total - disc - this.xtdiscf + service + pajak;

    this.xitem = zitem;
    this.xpayment = xpayment;
    this.xkembali = xpayment - this.xgrandtotal;
    this.item_bayar = itemb;
    this.xcash = xcash;
    this.xcard = xcard;

    // Update nilai pada objek meja yang aktif
    if (this.xgrandtotal !== 0) {
        if (this.mejao) this.mejao.jumlah = this.xgrandtotal;
        if (this.meja[this.currmeja]) this.meja[this.currmeja].jumlah = this.xgrandtotal;
    }

    return this.xgrandtotal;
},