-- Database Backup
-- Generated on: 2025-09-25 01:02:50
-- Database: pos_m

SET FOREIGN_KEY_CHECKS = 0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;


-- Table structure for table `area`
DROP TABLE IF EXISTS `area`;
CREATE TABLE `area` (
  `id` int(11) NOT NULL,
  `kode` char(3) NOT NULL,
  `nama` char(40) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_kode` (`kode`),
  KEY `idx_nama` (`nama`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `area`
INSERT INTO `area` (`id`, `kode`, `nama`) VALUES
(''1'', ''12'', ''12'');


-- Table structure for table `bahanbaku`
DROP TABLE IF EXISTS `bahanbaku`;
CREATE TABLE `bahanbaku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kode` varchar(15) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kategori` enum('Bahan Baku','Bahan Setengah Jadi','Bahan Kemasan') NOT NULL,
  `satuan` varchar(10) NOT NULL COMMENT 'Satuan stok/kemasan. Cth: KG, LITER, PACK, BOTOL',
  `satuan_recipe` varchar(10) NOT NULL COMMENT 'Satuan pemakaian resep. Cth: GRAM, ML, PCS',
  `rasio_kemasan` decimal(10,2) NOT NULL DEFAULT 1.00 COMMENT 'Konversi dari satuan kemasan ke satuan resep',
  `stok_min` decimal(10,2) DEFAULT 0.00 COMMENT 'Stok minimum untuk notifikasi',
  `cab` varchar(5) DEFAULT '002',
  `brand` varchar(5) DEFAULT '001',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `kode` (`kode`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `bahanbaku`
INSERT INTO `bahanbaku` (`id`, `kode`, `nama`, `kategori`, `satuan`, `satuan_recipe`, `rasio_kemasan`, `stok_min`, `cab`, `brand`, `created_at`) VALUES
(''1'', ''BB-RAW-001'', ''Beras Jepang'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''2'', ''BB-RAW-002'', ''Bawang Bombay'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''3'', ''BB-RAW-003'', ''Daun Bawang'', ''Bahan Baku'', ''IKAT'', ''GRAM'', ''100.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''4'', ''BB-RAW-004'', ''Bawang Putih'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''5'', ''BB-RAW-005'', ''Jahe'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''6'', ''BB-RAW-006'', ''Kubis'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''7'', ''BB-RAW-007'', ''Tauge'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''8'', ''BB-RAW-008'', ''Wortel'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''9'', ''BB-RAW-009'', ''Timun Jepang (Kyuri)'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''10'', ''BB-RAW-010'', ''Jamur Shitake Segar'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''11'', ''BB-RAW-011'', ''Cabai Rawit Merah'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''12'', ''BB-RAW-012'', ''Lemon Segar'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''13'', ''BB-RAW-013'', ''Telur Ayam Segar'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''14'', ''BB-RAW-014'', ''Minyak Goreng'', ''Bahan Baku'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''15'', ''BB-RAW-015'', ''Tepung Terigu'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''16'', ''BB-RAW-016'', ''Tepung Maizena'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''17'', ''BB-RAW-017'', ''Tepung Roti (Panko)'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''18'', ''BB-RAW-018'', ''Gula Pasir'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''19'', ''BB-RAW-019'', ''Garam'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''20'', ''BB-RAW-020'', ''Lada Putih Bubuk'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''21'', ''BB-RAW-021'', ''Wijen Putih'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''22'', ''BB-RAW-022'', ''Miso Paste'', ''Bahan Baku'', ''PACK'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''23'', ''BB-RAW-023'', ''Shoyu (Kecap Asin Jepang)'', ''Bahan Baku'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''24'', ''BB-RAW-024'', ''Mirin'', ''Bahan Baku'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''25'', ''BB-RAW-025'', ''Sake Masak (Cooking Sake)'', ''Bahan Baku'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''26'', ''BB-RAW-026'', ''Cuka Beras (Rice Vinegar)'', ''Bahan Baku'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''27'', ''BB-RAW-027'', ''Dashi Bubuk (Hon-dashi)'', ''Bahan Baku'', ''PACK'', ''GRAM'', ''100.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''28'', ''BB-RAW-028'', ''Bubuk Cabai (Ichimi/Shichimi)'', ''Bahan Baku'', ''BOTOL'', ''GRAM'', ''50.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''29'', ''BB-RAW-029'', ''Teh Hijau Bubuk (Ocha Powder)'', ''Bahan Baku'', ''PACK'', ''GRAM'', ''500.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''30'', ''BB-RAW-030'', ''Rumput Laut Kering (Nori)'', ''Bahan Baku'', ''PACK'', ''LEMBAR'', ''50.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''31'', ''BB-SFP-001'', ''Fillet Ayam Paha (Momo)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''32'', ''BB-SFP-002'', ''Fillet Ayam Dada (untuk Katsu)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''33'', ''BB-SFP-003'', ''Ayam Karaage (Marinasi)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''34'', ''BB-SFP-004'', ''Daging Sapi Iris (Beef Slice)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''35'', ''BB-SFP-005'', ''Daging Sapi Potong Dadu (Saikoro)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''36'', ''BB-SFP-006'', ''Daging Ayam Giling (untuk Tsukune)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''37'', ''BB-SFP-007'', ''Daging Giling (untuk Mabo/Tantan)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''38'', ''BB-SFP-008'', ''Kulit Ayam (Tori Kawa)'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''39'', ''BB-SFP-009'', ''Tusukan Yakitori - Momo'', ''Bahan Setengah Jadi'', ''PACK'', ''TUSUK'', ''10.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''40'', ''BB-SFP-010'', ''Tusukan Yakitori - Negima'', ''Bahan Setengah Jadi'', ''PACK'', ''TUSUK'', ''10.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''41'', ''BB-SFP-011'', ''Tusukan Yakitori - Tori Kawa'', ''Bahan Setengah Jadi'', ''PACK'', ''TUSUK'', ''10.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''42'', ''BB-SFP-012'', ''Tusukan Yakitori - Tsukune'', ''Bahan Setengah Jadi'', ''PACK'', ''TUSUK'', ''10.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''43'', ''BB-SFP-013'', ''Tusukan Yakitori - Gyu Saikoro'', ''Bahan Setengah Jadi'', ''PACK'', ''TUSUK'', ''10.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''44'', ''BB-SFP-014'', ''Tusukan Yakitori - Gyu Enoki'', ''Bahan Setengah Jadi'', ''PACK'', ''TUSUK'', ''10.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''45'', ''BB-SFP-015'', ''Tusukan Yakitori - Gyu Tamago'', ''Bahan Setengah Jadi'', ''PACK'', ''TUSUK'', ''10.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''46'', ''BB-SFP-016'', ''Fillet Ikan Saba (Marinasi)'', ''Bahan Setengah Jadi'', ''PACK'', ''PCS'', ''1.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''47'', ''BB-SFP-017'', ''Ika (Cumi) Siap Bakar'', ''Bahan Setengah Jadi'', ''PACK'', ''PCS'', ''1.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''48'', ''BB-SFP-018'', ''Fillet Salmon Porsi'', ''Bahan Setengah Jadi'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''49'', ''BB-SFP-019'', ''Saus Teriyaki'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''50'', ''BB-SFP-020'', ''Saus Donburi (Warishita)'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''51'', ''BB-SFP-021'', ''Saus Nanban'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''52'', ''BB-SFP-022'', ''Saus Tartar'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''53'', ''BB-SFP-023'', ''Kaldu Ramen - Shoyu'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''54'', ''BB-SFP-024'', ''Kaldu Ramen - Miso'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''55'', ''BB-SFP-025'', ''Kaldu Ramen - Tori Paitan'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''56'', ''BB-SFP-026'', ''Kaldu Ramen - Champon'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''57'', ''BB-SFP-027'', ''Saus Tantan'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''58'', ''BB-SFP-028'', ''Saus Mabo Tofu'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''59'', ''BB-SFP-029'', ''Minyak Cabai (Chili Oil)'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''60'', ''BB-SFP-030'', ''Mie Ramen'', ''Bahan Setengah Jadi'', ''PACK'', ''PORSI'', ''5.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''61'', ''BB-SFP-031'', ''Mie Soba'', ''Bahan Setengah Jadi'', ''PACK'', ''PORSI'', ''5.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''62'', ''BB-SFP-032'', ''Gyoza Beku'', ''Bahan Setengah Jadi'', ''PACK'', ''PCS'', ''20.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''63'', ''BB-SFP-033'', ''Telur Puyuh Rebus Bumbu'', ''Bahan Setengah Jadi'', ''PACK'', ''PCS'', ''25.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''64'', ''BB-SFP-034'', ''Custard Pudding'', ''Bahan Setengah Jadi'', ''PCS'', ''PCS'', ''1.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''65'', ''BB-SFP-035'', ''Matcha Pudding'', ''Bahan Setengah Jadi'', ''PCS'', ''PCS'', ''1.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''66'', ''BB-SFP-036'', ''Chocolate Pudding'', ''Bahan Setengah Jadi'', ''PCS'', ''PCS'', ''1.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''67'', ''BB-SFP-037'', ''Sirup Mango Wintermelon'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''68'', ''BB-SFP-038'', ''Sirup Yuzu Wintermelon'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''69'', ''BB-SFP-039'', ''Sirup Hibiscus Lychee'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''70'', ''BB-SFP-040'', ''Sirup Lemongrass'', ''Bahan Setengah Jadi'', ''LITER'', ''ML'', ''1000.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''71'', ''BB-SFP-041'', ''Keju Slice'', ''Bahan Setengah Jadi'', ''PACK'', ''SLICE'', ''20.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''72'', ''BB-FGP-001'', ''Coca Cola Kaleng'', ''Bahan Kemasan'', ''KALENG'', ''ML'', ''330.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''73'', ''BB-FGP-002'', ''Sprite Kaleng'', ''Bahan Kemasan'', ''KALENG'', ''ML'', ''330.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''74'', ''BB-FGP-003'', ''Ramune'', ''Bahan Kemasan'', ''BOTOL'', ''ML'', ''200.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''75'', ''BB-FGP-004'', ''Mineral Water (330ml)'', ''Bahan Kemasan'', ''BOTOL'', ''ML'', ''330.00'', ''0.00'', ''002'', ''001'', ''2025-09-10 15:31:45''),
(''76'', ''BB-FGP-005'', ''JAHE'', ''Bahan Baku'', ''KG'', ''GRAM'', ''1000.00'', ''0.00'', '''', '''', ''2025-09-11 16:01:59'');


-- Table structure for table `bahasa`
DROP TABLE IF EXISTS `bahasa`;
CREATE TABLE `bahasa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kunci` varchar(50) DEFAULT NULL,
  `original` varchar(100) DEFAULT NULL,
  `ind` varchar(100) DEFAULT NULL,
  `jpn` varchar(100) DEFAULT NULL,
  `chn` varchar(100) DEFAULT NULL,
  `arb` varchar(100) DEFAULT NULL,
  `eng` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `brand` varchar(3) NOT NULL,
  `cab` varchar(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `bahasa`
INSERT INTO `bahasa` (`id`, `kunci`, `original`, `ind`, `jpn`, `chn`, `arb`, `eng`, `is_active`, `created_at`, `brand`, `cab`) VALUES
(''1'', ''pos_kasir_restoran'', ''POS Kasir Restoran'', ''POS Kasir Restoran'', ''?????POS??'', ''??????'', ''???? ???? ????? ??????'', ''Restaurant POS System'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''2'', ''restaurant_bill'', ''Restaurant Bill'', ''Tagihan Restoran'', ''???????'', ''????'', ''?????? ??????'', ''Restaurant Bill'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''3'', ''struk_belanja'', ''Struk Belanja'', ''Struk Belanja'', ''????????'', ''????'', ''????? ??????'', ''Shopping Receipt'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''4'', ''split_bills'', ''Split Bills'', ''Pisah Tagihan'', ''????'', ''??'', ''????? ????????'', ''Split Bills'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''5'', ''menu_item'', ''Menu Item'', ''Item Menu'', ''??????'', ''????'', ''???? ???????'', ''Menu Item'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''6'', ''category'', ''Category'', ''Kategori'', ''?????'', ''??'', ''?????'', ''Category'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''7'', ''top'', ''Top'', ''Atas'', ''???'', ''??'', ''????'', ''Top'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''8'', ''lantai'', ''Lantai'', ''Lantai'', ''???'', ''??'', ''????'', ''Floor'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''9'', ''table'', ''Table'', ''Meja'', ''????'', ''??'', ''?????'', ''Table'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''10'', ''discount'', ''Discount'', ''Diskon'', ''??'', ''??'', ''???'', ''Discount'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''11'', ''setup'', ''Setup'', ''Pengaturan'', ''??'', ''??'', ''?????'', ''Setup'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''12'', ''cancel'', ''Cancel'', ''Batal'', ''?????'', ''??'', ''?????'', ''Cancel'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''13'', ''total'', ''Total'', ''Total'', ''??'', ''??'', ''???????'', ''Total'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''14'', ''pembayaran'', ''Pembayaran'', ''Pembayaran'', ''???'', ''??'', ''???'', ''Payment'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''15'', ''kembali'', ''Kembali'', ''Kembali'', ''???'', ''??'', ''??????'', ''Change'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''16'', ''kurang_bayar'', ''Kurang Bayar'', ''Kurang Bayar'', ''???'', ''??'', ''??? ?????'', ''Underpayment'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''17'', ''cover'', ''Cover'', ''Cover'', ''???'', ''???'', ''?????'', ''Cover'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''18'', ''guest'', ''Guest'', ''Tamu'', ''???'', ''??'', ''???'', ''Guest'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''19'', ''subtotal'', ''Subtotal'', ''Subtotal'', ''??'', ''??'', ''??????? ??????'', ''Subtotal'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''20'', ''total_discount'', ''Total Discount'', ''Total Diskon'', ''????'', ''???'', ''?????? ?????'', ''Total Discount'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''21'', ''service'', ''Service'', ''Layanan'', ''?????'', ''???'', ''????'', ''Service'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''22'', ''pajak'', ''Pajak'', ''Pajak'', ''??'', ''?'', ''?????'', ''Tax'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''23'', ''item_count'', ''#Item'', ''Jumlah Item'', ''???'', ''????'', ''??? ???????'', ''Item Count'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''24'', ''qty'', ''Qty'', ''Qty'', ''??'', ''??'', ''??????'', ''Qty'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''25'', ''nama'', ''Nama'', ''Nama'', ''??'', ''??'', ''???'', ''Name'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''26'', ''disc'', ''Disc'', ''Disc'', ''??'', ''??'', ''???'', ''Disc'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''27'', ''jumlah'', ''Jumlah'', ''Jumlah'', ''??'', ''??'', ''??????'', ''Amount'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''28'', ''user'', ''User'', ''User'', ''????'', ''??'', ''??????'', ''User'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''29'', ''kontan'', ''Kontan'', ''Tunai'', ''??'', ''??'', ''?????'', ''Cash'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''30'', ''kartu_kredit_bca'', ''Kartu Kredit BCA'', ''Kartu Kredit BCA'', ''BCA????????'', ''BCA???'', ''????? BCA ??????????'', ''BCA Credit Card'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''31'', ''kartu_debet'', ''Kartu Debet'', ''Kartu Debet'', ''???????'', ''???'', ''????? ?????'', ''Debit Card'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''32'', ''gopay'', ''GoPay'', ''GoPay'', ''GoPay'', ''GoPay'', ''GoPay'', ''GoPay'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''33'', ''voucher'', ''Voucher'', ''Voucher'', ''?????'', ''???'', ''?????'', ''Voucher'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''34'', ''userid'', ''User ID'', ''ID Pengguna'', ''????ID'', ''??ID'', ''???? ????????'', ''User ID'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''35'', ''password'', ''Password'', ''Kata Sandi'', ''?????'', ''??'', ''???? ??????'', ''Password'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''36'', ''pesan_penting'', ''Pesan Penting'', ''Pesan Penting'', ''????????'', ''????'', ''????? ????'', ''Important Message'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''37'', ''mengerti'', ''Mengerti'', ''Mengerti'', ''??'', ''??'', ''?????'', ''Understood'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''38'', ''yes'', ''Yes'', ''Ya'', ''??'', ''?'', ''???'', ''Yes'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''39'', ''no'', ''No'', ''Tidak'', ''???'', ''?'', ''??'', ''No'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''40'', ''ok'', ''OK'', ''OK'', ''OK'', ''??'', ''?????'', ''OK'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''41'', ''move_item'', ''Move Item'', ''Pindah Item'', ''????'', ''????'', ''??? ??????'', ''Move Item'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''42'', ''move_1pc'', ''Move 1pc'', ''Pindah 1 Buah'', ''1???'', ''??1?'', ''??? ???? ?????'', ''Move 1pc'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''43'', ''move_menu'', ''Move Menu'', ''Pindah Menu'', ''??????'', ''????'', ''??? ???????'', ''Move Menu'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''44'', ''move_all'', ''Move All'', ''Pindah Semua'', ''????'', ''????'', ''??? ????'', ''Move All'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''45'', ''return_1pc'', ''Return 1pc'', ''Retur 1 Buah'', ''1???'', ''??1?'', ''????? ???? ?????'', ''Return 1pc'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''46'', ''return_menu'', ''Return Menu'', ''Retur Menu'', ''??????'', ''????'', ''????? ???????'', ''Return Menu'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''47'', ''return_all'', ''Return All'', ''Retur Semua'', ''????'', ''????'', ''????? ????'', ''Return All'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''48'', ''save'', ''Save'', ''Simpan'', ''??'', ''??'', ''???'', ''Save'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''49'', ''master_bill'', ''Master Bill'', ''Tagihan Utama'', ''???'', ''???'', ''???????? ????????'', ''Master Bill'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''50'', ''name'', ''Name'', ''Nama'', ''??'', ''??'', ''???'', ''Name'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''51'', ''background_color'', ''Background Color'', ''Warna Latar'', ''???'', ''????'', ''??? ???????'', ''Background Color'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''52'', ''text_color'', ''Text Color'', ''Warna Teks'', ''?????'', ''????'', ''??? ????'', ''Text Color'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''53'', ''label'', ''Label'', ''Label'', ''???'', ''??'', ''?????'', ''Label'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''54'', ''image'', ''Image'', ''Gambar'', ''??'', ''??'', ''????'', ''Image'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''55'', ''copy_to_new_table'', ''Copy to New Table'', ''Salin ke Meja Baru'', ''???????????'', ''??????'', ''??? ??? ????? ?????'', ''Copy to New Table'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''56'', ''update_table'', ''Update Table'', ''Perbarui Meja'', ''??????'', ''????'', ''????? ???????'', ''Update Table'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''57'', ''hapus_meja'', ''Hapus Meja'', ''Hapus Meja'', ''??????'', ''????'', ''??? ???????'', ''Delete Table'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''58'', ''copy_atribut'', ''Copy Atribut'', ''Salin Atribut'', ''??????'', ''????'', ''??? ??????'', ''Copy Attributes'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''59'', ''paste_atribut'', ''Paste Atribut'', ''Tempel Atribut'', ''???????'', ''????'', ''??? ??????'', ''Paste Attributes'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''60'', ''paket'', ''Paket'', ''Paket'', ''???'', ''??'', ''????'', ''Package'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''61'', ''condiment'', ''Condiment'', ''Bumbu'', ''???'', ''???'', ''?????'', ''Condiment'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''62'', ''optional'', ''Optional'', ''Opsional'', ''?????'', ''??'', ''???????'', ''Optional'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''63'', ''wajib'', ''(Wajib)'', ''(Wajib)'', ''(??)'', ''(??)'', ''(??????)'', ''(Required)'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''64'', ''opsional'', ''(opsional)'', ''(Opsional)'', ''(?????)'', ''(??)'', ''(???????)'', ''(Optional)'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''65'', ''masukan_jumlah'', ''Masukan Jumlah'', ''Masukan Jumlah'', ''?????'', ''????'', ''???? ??????'', ''Enter Amount'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''66'', ''masukan_jumlah_tamu'', ''Masukan Jumlah Tamu'', ''Masukan Jumlah Tamu'', ''???????'', ''??????'', ''???? ??? ??????'', ''Enter Guest Count'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''67'', ''masukan_jumlah_pembayaran'', ''Masukan Jumlah Pembayaran'', ''Masukan Jumlah Pembayaran'', ''??????'', ''??????'', ''???? ???? ?????'', ''Enter Payment Amount'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''68'', ''catatan_untuk'', ''Catatan untuk'', ''Catatan untuk'', ''??:'', ''??'', ''?????? ??'', ''Note for'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''69'', ''nama_tamu'', ''Nama Tamu'', ''Nama Tamu'', ''????'', ''????'', ''??? ?????'', ''Guest Name'', ''1'', ''2024-12-05 16:29:53'', ''001'', ''002''),
(''70'', ''login'', ''Login'', ''Masuk'', ''????'', ''??'', ''????? ??????'', ''Login'', ''1'', ''2024-12-06 01:16:10'', ''001'', ''002''),
(''71'', ''Masukan_saldo'', ''Masukan Modal'', ''Masukan Modal'', NULL, NULL, NULL, NULL, ''1'', ''2024-12-15 09:48:41'', ''001'', ''002'');


-- Table structure for table `bahasa1`
DROP TABLE IF EXISTS `bahasa1`;
CREATE TABLE `bahasa1` (
  `ind` varchar(255) NOT NULL,
  `en` varchar(255) NOT NULL,
  `cn` varchar(255) NOT NULL,
  `ar` varchar(255) NOT NULL,
  `jp` varchar(255) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `bahasa1`
INSERT INTO `bahasa1` (`ind`, `en`, `cn`, `ar`, `jp`, `id`) VALUES
(''Tambah Barang'', ''Add Item'', ''????'', ''????? ????'', ''?????'', ''1''),
(''Hapus Barang'', ''Remove Item'', ''????'', ''??? ??????'', ''?????'', ''2''),
(''Bayar'', ''Pay'', ''??'', ''???'', ''???'', ''3''),
(''Diskon'', ''Discount'', ''??'', ''???'', ''??'', ''4''),
(''Void Transaksi'', ''Void Transaction'', ''????'', ''????? ????????'', ''??????'', ''5''),
(''Cetak Ulang Struk'', ''Reprint Receipt'', ''??????'', ''????? ????? ???????'', ''????????'', ''6''),
(''Pindah Kasir'', ''Switch Cashier'', ''?????'', ''????? ???????'', ''?????????'', ''7''),
(''Laporan Penjualan'', ''Sales Report'', ''????'', ''????? ????????'', ''??????'', ''8''),
(''Cari Barang'', ''Search Item'', ''????'', ''????? ?? ??????'', ''?????'', ''9''),
(''Pengaturan'', ''Settings'', ''??'', ''???????'', ''??'', ''10'');


-- Table structure for table `barang_keluar_detail`
DROP TABLE IF EXISTS `barang_keluar_detail`;
CREATE TABLE `barang_keluar_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_keluar_header` int(11) NOT NULL,
  `id_bahanbaku` int(11) NOT NULL,
  `jumlah` decimal(10,2) NOT NULL,
  `satuan` varchar(10) NOT NULL,
  `alasan` enum('Waste','Spoiler','Rusak','Dipakai') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_keluar_header` (`id_keluar_header`),
  KEY `fk_keluar_bahanbaku` (`id_bahanbaku`),
  CONSTRAINT `fk_keluar_bahanbaku` FOREIGN KEY (`id_bahanbaku`) REFERENCES `bahanbaku` (`id`),
  CONSTRAINT `fk_keluar_header` FOREIGN KEY (`id_keluar_header`) REFERENCES `barang_keluar_header` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `barang_keluar_detail`
INSERT INTO `barang_keluar_detail` (`id`, `id_keluar_header`, `id_bahanbaku`, `jumlah`, `satuan`, `alasan`) VALUES
(''1'', ''1'', ''2'', ''5.00'', ''KG'', ''Rusak''),
(''2'', ''1'', ''4'', ''2.00'', ''KG'', ''Rusak''),
(''3'', ''2'', ''1'', ''10.00'', ''KG'', ''Dipakai''),
(''4'', ''2'', ''3'', ''3.00'', ''IKAT'', ''Dipakai'');


-- Table structure for table `barang_keluar_header`
DROP TABLE IF EXISTS `barang_keluar_header`;
CREATE TABLE `barang_keluar_header` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `no_keluar` varchar(20) NOT NULL,
  `tgl_keluar` date NOT NULL,
  `id_cabang` varchar(5) NOT NULL DEFAULT '002',
  `keterangan` text DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `no_keluar` (`no_keluar`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `barang_keluar_header`
INSERT INTO `barang_keluar_header` (`id`, `no_keluar`, `tgl_keluar`, `id_cabang`, `keterangan`, `created_by`, `created_at`) VALUES
(''1'', ''BK/2311/0001'', ''2023-11-10'', ''002'', ''Barang rusak karena kadaluarsa'', ''admin'', ''2025-09-10 15:46:11''),
(''2'', ''BK/2311/0002'', ''2023-11-15'', ''002'', ''Barang dipakai untuk event'', ''admin'', ''2025-09-10 15:46:11'');


-- Table structure for table `bcab`
DROP TABLE IF EXISTS `bcab`;
CREATE TABLE `bcab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cabang` varchar(3) DEFAULT NULL,
  `nama` varchar(50) DEFAULT NULL,
  `barang` varchar(10) DEFAULT NULL,
  `dt` date DEFAULT NULL,
  `st` date DEFAULT NULL,
  `no` tinyint(1) DEFAULT NULL,
  `type` varchar(1) DEFAULT NULL,
  `dj` varchar(8) DEFAULT NULL,
  `sj` varchar(8) DEFAULT NULL,
  `ya` varchar(1) DEFAULT NULL,
  `brand` varchar(3) DEFAULT NULL,
  `cab` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_barang` (`barang`)
) ENGINE=InnoDB AUTO_INCREMENT=394 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `bcab`
INSERT INTO `bcab` (`id`, `cabang`, `nama`, `barang`, `dt`, `st`, `no`, `type`, `dj`, `sj`, `ya`, `brand`, `cab`) VALUES
(''1'', ''001'', ''Living World Kota Wisata'', ''0101'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''2'', ''002'', ''PIM'', ''0101'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''3'', ''003'', ''Grand Indonesia'', ''0101'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''4'', ''004'', ''Mall of Indonesia'', ''0101'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''5'', ''005'', ''AEON MALL Jakarta Garden City'', ''0101'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''6'', ''006'', ''Kota Kasablanka'', ''0101'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''7'', ''001'', ''Living World Kota Wisata'', ''0854'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''8'', ''002'', ''PIM'', ''0854'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''9'', ''003'', ''Grand Indonesia'', ''0854'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''10'', ''004'', ''Mall of Indonesia'', ''0854'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''11'', ''005'', ''AEON MALL Jakarta Garden City'', ''0854'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''12'', ''006'', ''Kota Kasablanka'', ''0854'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''13'', ''001'', ''Living World Kota Wisata'', ''0855'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''14'', ''002'', ''PIM'', ''0855'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''15'', ''003'', ''Grand Indonesia'', ''0855'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''16'', ''004'', ''Mall of Indonesia'', ''0855'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''17'', ''005'', ''AEON MALL Jakarta Garden City'', ''0855'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''18'', ''006'', ''Kota Kasablanka'', ''0855'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''19'', ''001'', ''Living World Kota Wisata'', ''0856'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''20'', ''002'', ''PIM'', ''0856'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''21'', ''003'', ''Grand Indonesia'', ''0856'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''22'', ''004'', ''Mall of Indonesia'', ''0856'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''23'', ''005'', ''AEON MALL Jakarta Garden City'', ''0856'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''24'', ''006'', ''Kota Kasablanka'', ''0856'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''25'', ''001'', ''Living World Kota Wisata'', ''0857'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''26'', ''002'', ''PIM'', ''0857'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''27'', ''003'', ''Grand Indonesia'', ''0857'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''28'', ''004'', ''Mall of Indonesia'', ''0857'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''29'', ''005'', ''AEON MALL Jakarta Garden City'', ''0857'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''30'', ''006'', ''Kota Kasablanka'', ''0857'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''31'', ''001'', ''Living World Kota Wisata'', ''0858'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''32'', ''002'', ''PIM'', ''0858'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''33'', ''003'', ''Grand Indonesia'', ''0858'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''34'', ''004'', ''Mall of Indonesia'', ''0858'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''35'', ''005'', ''AEON MALL Jakarta Garden City'', ''0858'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''36'', ''006'', ''Kota Kasablanka'', ''0858'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''37'', ''001'', ''Living World Kota Wisata'', ''0859'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''38'', ''002'', ''PIM'', ''0859'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''39'', ''003'', ''Grand Indonesia'', ''0859'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''40'', ''004'', ''Mall of Indonesia'', ''0859'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''41'', ''005'', ''AEON MALL Jakarta Garden City'', ''0859'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''42'', ''006'', ''Kota Kasablanka'', ''0859'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''43'', ''001'', ''Living World Kota Wisata'', ''0860'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''44'', ''002'', ''PIM'', ''0860'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''45'', ''003'', ''Grand Indonesia'', ''0860'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''46'', ''004'', ''Mall of Indonesia'', ''0860'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''47'', ''005'', ''AEON MALL Jakarta Garden City'', ''0860'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''48'', ''006'', ''Kota Kasablanka'', ''0860'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''49'', ''001'', ''Living World Kota Wisata'', ''0861'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''50'', ''002'', ''PIM'', ''0861'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''51'', ''003'', ''Grand Indonesia'', ''0861'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''52'', ''004'', ''Mall of Indonesia'', ''0861'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''53'', ''005'', ''AEON MALL Jakarta Garden City'', ''0861'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''54'', ''006'', ''Kota Kasablanka'', ''0861'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''55'', ''001'', ''Living World Kota Wisata'', ''0862'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''56'', ''002'', ''PIM'', ''0862'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''57'', ''003'', ''Grand Indonesia'', ''0862'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''58'', ''004'', ''Mall of Indonesia'', ''0862'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''59'', ''005'', ''AEON MALL Jakarta Garden City'', ''0862'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''60'', ''006'', ''Kota Kasablanka'', ''0862'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''61'', ''001'', ''Living World Kota Wisata'', ''0863'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''62'', ''002'', ''PIM'', ''0863'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''63'', ''003'', ''Grand Indonesia'', ''0863'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''64'', ''004'', ''Mall of Indonesia'', ''0863'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''65'', ''005'', ''AEON MALL Jakarta Garden City'', ''0863'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''66'', ''006'', ''Kota Kasablanka'', ''0863'', ''2025-08-29'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''67'', ''001'', ''Living World Kota Wisata'', ''0105'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''68'', ''002'', ''PIM'', ''0105'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''69'', ''003'', ''Grand Indonesia'', ''0105'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''70'', ''004'', ''Mall of Indonesia'', ''0105'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''71'', ''005'', ''AEON MALL Jakarta Garden City'', ''0105'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''72'', ''006'', ''Kota Kasablanka'', ''0105'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''73'', ''001'', ''Living World Kota Wisata'', ''0102'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''74'', ''002'', ''PIM'', ''0102'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''75'', ''003'', ''Grand Indonesia'', ''0102'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''76'', ''004'', ''Mall of Indonesia'', ''0102'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''77'', ''005'', ''AEON MALL Jakarta Garden City'', ''0102'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''78'', ''006'', ''Kota Kasablanka'', ''0102'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''79'', ''001'', ''Living World Kota Wisata'', ''0103'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''80'', ''002'', ''PIM'', ''0103'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''81'', ''003'', ''Grand Indonesia'', ''0103'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''82'', ''004'', ''Mall of Indonesia'', ''0103'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''83'', ''005'', ''AEON MALL Jakarta Garden City'', ''0103'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''84'', ''006'', ''Kota Kasablanka'', ''0103'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''85'', ''001'', ''Living World Kota Wisata'', ''0104'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''86'', ''002'', ''PIM'', ''0104'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''87'', ''003'', ''Grand Indonesia'', ''0104'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''88'', ''004'', ''Mall of Indonesia'', ''0104'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''89'', ''005'', ''AEON MALL Jakarta Garden City'', ''0104'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''90'', ''006'', ''Kota Kasablanka'', ''0104'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''91'', ''001'', ''Living World Kota Wisata'', ''0206'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''92'', ''002'', ''PIM'', ''0206'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''93'', ''003'', ''Grand Indonesia'', ''0206'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''94'', ''004'', ''Mall of Indonesia'', ''0206'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''95'', ''005'', ''AEON MALL Jakarta Garden City'', ''0206'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''96'', ''006'', ''Kota Kasablanka'', ''0206'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''97'', ''001'', ''Living World Kota Wisata'', ''0307'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''98'', ''002'', ''PIM'', ''0307'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''99'', ''003'', ''Grand Indonesia'', ''0307'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''100'', ''004'', ''Mall of Indonesia'', ''0307'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''101'', ''005'', ''AEON MALL Jakarta Garden City'', ''0307'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''102'', ''006'', ''Kota Kasablanka'', ''0307'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''103'', ''001'', ''Living World Kota Wisata'', ''0308'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''104'', ''002'', ''PIM'', ''0308'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''105'', ''003'', ''Grand Indonesia'', ''0308'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''106'', ''004'', ''Mall of Indonesia'', ''0308'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''107'', ''005'', ''AEON MALL Jakarta Garden City'', ''0308'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''108'', ''006'', ''Kota Kasablanka'', ''0308'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''109'', ''001'', ''Living World Kota Wisata'', ''0309'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''110'', ''002'', ''PIM'', ''0309'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''111'', ''003'', ''Grand Indonesia'', ''0309'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''112'', ''004'', ''Mall of Indonesia'', ''0309'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''113'', ''005'', ''AEON MALL Jakarta Garden City'', ''0309'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''114'', ''006'', ''Kota Kasablanka'', ''0309'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''115'', ''001'', ''Living World Kota Wisata'', ''0310'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''116'', ''002'', ''PIM'', ''0310'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''117'', ''003'', ''Grand Indonesia'', ''0310'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''118'', ''004'', ''Mall of Indonesia'', ''0310'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''119'', ''001'', ''Living World Kota Wisata'', ''0311'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''120'', ''005'', ''AEON MALL Jakarta Garden City'', ''0310'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''121'', ''002'', ''PIM'', ''0311'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''122'', ''006'', ''Kota Kasablanka'', ''0310'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''123'', ''003'', ''Grand Indonesia'', ''0311'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''124'', ''004'', ''Mall of Indonesia'', ''0311'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''125'', ''005'', ''AEON MALL Jakarta Garden City'', ''0311'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''126'', ''001'', ''Living World Kota Wisata'', ''0312'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''127'', ''006'', ''Kota Kasablanka'', ''0311'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''128'', ''002'', ''PIM'', ''0312'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''129'', ''003'', ''Grand Indonesia'', ''0312'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''130'', ''004'', ''Mall of Indonesia'', ''0312'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''131'', ''005'', ''AEON MALL Jakarta Garden City'', ''0312'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''132'', ''006'', ''Kota Kasablanka'', ''0312'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''133'', ''001'', ''Living World Kota Wisata'', ''0313'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''134'', ''002'', ''PIM'', ''0313'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''135'', ''003'', ''Grand Indonesia'', ''0313'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''136'', ''001'', ''Living World Kota Wisata'', ''0314'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''137'', ''004'', ''Mall of Indonesia'', ''0313'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''138'', ''002'', ''PIM'', ''0314'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''139'', ''005'', ''AEON MALL Jakarta Garden City'', ''0313'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''140'', ''003'', ''Grand Indonesia'', ''0314'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''141'', ''006'', ''Kota Kasablanka'', ''0313'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''142'', ''004'', ''Mall of Indonesia'', ''0314'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''143'', ''001'', ''Living World Kota Wisata'', ''0315'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''144'', ''005'', ''AEON MALL Jakarta Garden City'', ''0314'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''145'', ''002'', ''PIM'', ''0315'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''146'', ''006'', ''Kota Kasablanka'', ''0314'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''147'', ''003'', ''Grand Indonesia'', ''0315'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''148'', ''001'', ''Living World Kota Wisata'', ''0316'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''149'', ''004'', ''Mall of Indonesia'', ''0315'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''150'', ''002'', ''PIM'', ''0316'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''151'', ''005'', ''AEON MALL Jakarta Garden City'', ''0315'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''152'', ''006'', ''Kota Kasablanka'', ''0315'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''153'', ''003'', ''Grand Indonesia'', ''0316'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''154'', ''001'', ''Living World Kota Wisata'', ''0317'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''155'', ''004'', ''Mall of Indonesia'', ''0316'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''156'', ''002'', ''PIM'', ''0317'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''157'', ''005'', ''AEON MALL Jakarta Garden City'', ''0316'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''158'', ''003'', ''Grand Indonesia'', ''0317'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''159'', ''006'', ''Kota Kasablanka'', ''0316'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''160'', ''004'', ''Mall of Indonesia'', ''0317'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''161'', ''001'', ''Living World Kota Wisata'', ''0318'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''162'', ''005'', ''AEON MALL Jakarta Garden City'', ''0317'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''163'', ''002'', ''PIM'', ''0318'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''164'', ''006'', ''Kota Kasablanka'', ''0317'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''165'', ''003'', ''Grand Indonesia'', ''0318'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''166'', ''004'', ''Mall of Indonesia'', ''0318'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''167'', ''005'', ''AEON MALL Jakarta Garden City'', ''0318'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''168'', ''006'', ''Kota Kasablanka'', ''0318'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''169'', ''001'', ''Living World Kota Wisata'', ''0319'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''170'', ''002'', ''PIM'', ''0319'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''171'', ''003'', ''Grand Indonesia'', ''0319'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''172'', ''004'', ''Mall of Indonesia'', ''0319'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''173'', ''001'', ''Living World Kota Wisata'', ''0420'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''174'', ''005'', ''AEON MALL Jakarta Garden City'', ''0319'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''175'', ''002'', ''PIM'', ''0420'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''176'', ''006'', ''Kota Kasablanka'', ''0319'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''177'', ''003'', ''Grand Indonesia'', ''0420'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''178'', ''004'', ''Mall of Indonesia'', ''0420'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''179'', ''005'', ''AEON MALL Jakarta Garden City'', ''0420'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''180'', ''001'', ''Living World Kota Wisata'', ''0421'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''181'', ''002'', ''PIM'', ''0421'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''182'', ''006'', ''Kota Kasablanka'', ''0420'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''183'', ''003'', ''Grand Indonesia'', ''0421'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''184'', ''004'', ''Mall of Indonesia'', ''0421'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''185'', ''005'', ''AEON MALL Jakarta Garden City'', ''0421'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''186'', ''001'', ''Living World Kota Wisata'', ''0422'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''187'', ''002'', ''PIM'', ''0422'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''188'', ''006'', ''Kota Kasablanka'', ''0421'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''189'', ''003'', ''Grand Indonesia'', ''0422'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''190'', ''001'', ''Living World Kota Wisata'', ''0423'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''191'', ''004'', ''Mall of Indonesia'', ''0422'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''192'', ''002'', ''PIM'', ''0423'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''193'', ''005'', ''AEON MALL Jakarta Garden City'', ''0422'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''194'', ''003'', ''Grand Indonesia'', ''0423'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''195'', ''006'', ''Kota Kasablanka'', ''0422'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''196'', ''001'', ''Living World Kota Wisata'', ''0424'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''197'', ''004'', ''Mall of Indonesia'', ''0423'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''198'', ''002'', ''PIM'', ''0424'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''199'', ''005'', ''AEON MALL Jakarta Garden City'', ''0423'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''200'', ''003'', ''Grand Indonesia'', ''0424'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''201'', ''006'', ''Kota Kasablanka'', ''0423'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''202'', ''004'', ''Mall of Indonesia'', ''0424'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''203'', ''001'', ''Living World Kota Wisata'', ''0425'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''204'', ''005'', ''AEON MALL Jakarta Garden City'', ''0424'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''205'', ''002'', ''PIM'', ''0425'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''206'', ''006'', ''Kota Kasablanka'', ''0424'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''207'', ''003'', ''Grand Indonesia'', ''0425'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''208'', ''004'', ''Mall of Indonesia'', ''0425'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''209'', ''005'', ''AEON MALL Jakarta Garden City'', ''0425'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''210'', ''001'', ''Living World Kota Wisata'', ''0426'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''211'', ''002'', ''PIM'', ''0426'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''212'', ''006'', ''Kota Kasablanka'', ''0425'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''213'', ''003'', ''Grand Indonesia'', ''0426'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''214'', ''004'', ''Mall of Indonesia'', ''0426'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''215'', ''001'', ''Living World Kota Wisata'', ''0427'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''216'', ''005'', ''AEON MALL Jakarta Garden City'', ''0426'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''217'', ''002'', ''PIM'', ''0427'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''218'', ''006'', ''Kota Kasablanka'', ''0426'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''219'', ''003'', ''Grand Indonesia'', ''0427'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''220'', ''004'', ''Mall of Indonesia'', ''0427'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''221'', ''001'', ''Living World Kota Wisata'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''222'', ''005'', ''AEON MALL Jakarta Garden City'', ''0427'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''223'', ''002'', ''PIM'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''224'', ''006'', ''Kota Kasablanka'', ''0427'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''225'', ''003'', ''Grand Indonesia'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''226'', ''001'', ''Living World Kota Wisata'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''227'', ''004'', ''Mall of Indonesia'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''228'', ''002'', ''PIM'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''229'', ''005'', ''AEON MALL Jakarta Garden City'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''230'', ''006'', ''Kota Kasablanka'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''231'', ''001'', ''Living World Kota Wisata'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''232'', ''003'', ''Grand Indonesia'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''233'', ''002'', ''PIM'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''234'', ''004'', ''Mall of Indonesia'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''235'', ''003'', ''Grand Indonesia'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''236'', ''005'', ''AEON MALL Jakarta Garden City'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''237'', ''004'', ''Mall of Indonesia'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''238'', ''006'', ''Kota Kasablanka'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''239'', ''005'', ''AEON MALL Jakarta Garden City'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''240'', ''006'', ''Kota Kasablanka'', ''0428'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''241'', ''004'', ''Mall of Indonesia'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''242'', ''005'', ''AEON MALL Jakarta Garden City'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''243'', ''006'', ''Kota Kasablanka'', ''0429'', ''2025-08-30'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''244'', ''001'', ''Living World Kota Wisata'', ''0864'', ''2025-09-09'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''245'', ''002'', ''PIM'', ''0864'', ''2025-09-09'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''246'', ''003'', ''Grand Indonesia'', ''0864'', ''2025-09-09'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''247'', ''004'', ''Mall of Indonesia'', ''0864'', ''2025-09-09'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''248'', ''005'', ''AEON MALL Jakarta Garden City'', ''0864'', ''2025-09-09'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''249'', ''006'', ''Kota Kasablanka'', ''0864'', ''2025-09-09'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''250'', ''001'', ''Living World Kota Wisata'', ''0430'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''251'', ''004'', ''Mall of Indonesia'', ''0430'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''252'', ''002'', ''PIM'', ''0430'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''253'', ''003'', ''Grand Indonesia'', ''0430'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''254'', ''005'', ''AEON MALL Jakarta Garden City'', ''0430'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''255'', ''006'', ''Kota Kasablanka'', ''0430'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''256'', ''002'', ''PIM'', ''0431'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''257'', ''001'', ''Living World Kota Wisata'', ''0431'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''258'', ''003'', ''Grand Indonesia'', ''0431'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''259'', ''004'', ''Mall of Indonesia'', ''0431'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''260'', ''006'', ''Kota Kasablanka'', ''0431'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''261'', ''005'', ''AEON MALL Jakarta Garden City'', ''0431'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''262'', ''001'', ''Living World Kota Wisata'', ''0432'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''263'', ''003'', ''Grand Indonesia'', ''0432'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''264'', ''004'', ''Mall of Indonesia'', ''0432'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''265'', ''005'', ''AEON MALL Jakarta Garden City'', ''0432'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''266'', ''002'', ''PIM'', ''0432'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''267'', ''006'', ''Kota Kasablanka'', ''0432'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''268'', ''002'', ''PIM'', ''0533'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''269'', ''001'', ''Living World Kota Wisata'', ''0533'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''270'', ''003'', ''Grand Indonesia'', ''0533'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''271'', ''004'', ''Mall of Indonesia'', ''0533'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''272'', ''005'', ''AEON MALL Jakarta Garden City'', ''0533'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''273'', ''006'', ''Kota Kasablanka'', ''0533'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''274'', ''001'', ''Living World Kota Wisata'', ''0534'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''275'', ''002'', ''PIM'', ''0534'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''276'', ''003'', ''Grand Indonesia'', ''0534'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''277'', ''005'', ''AEON MALL Jakarta Garden City'', ''0534'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''278'', ''004'', ''Mall of Indonesia'', ''0534'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''279'', ''006'', ''Kota Kasablanka'', ''0534'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''280'', ''001'', ''Living World Kota Wisata'', ''0535'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''281'', ''002'', ''PIM'', ''0535'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''282'', ''005'', ''AEON MALL Jakarta Garden City'', ''0535'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''283'', ''004'', ''Mall of Indonesia'', ''0535'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''284'', ''003'', ''Grand Indonesia'', ''0535'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''285'', ''006'', ''Kota Kasablanka'', ''0535'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''286'', ''001'', ''Living World Kota Wisata'', ''0536'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''287'', ''002'', ''PIM'', ''0536'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''288'', ''003'', ''Grand Indonesia'', ''0536'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''289'', ''004'', ''Mall of Indonesia'', ''0536'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''290'', ''005'', ''AEON MALL Jakarta Garden City'', ''0536'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''291'', ''006'', ''Kota Kasablanka'', ''0536'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''292'', ''001'', ''Living World Kota Wisata'', ''0537'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''293'', ''002'', ''PIM'', ''0537'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''294'', ''003'', ''Grand Indonesia'', ''0537'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''295'', ''004'', ''Mall of Indonesia'', ''0537'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''296'', ''005'', ''AEON MALL Jakarta Garden City'', ''0537'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''297'', ''006'', ''Kota Kasablanka'', ''0537'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''298'', ''001'', ''Living World Kota Wisata'', ''0538'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''299'', ''002'', ''PIM'', ''0538'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''300'', ''003'', ''Grand Indonesia'', ''0538'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''301'', ''004'', ''Mall of Indonesia'', ''0538'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''302'', ''005'', ''AEON MALL Jakarta Garden City'', ''0538'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''303'', ''006'', ''Kota Kasablanka'', ''0538'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''304'', ''001'', ''Living World Kota Wisata'', ''0539'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''305'', ''002'', ''PIM'', ''0539'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''306'', ''003'', ''Grand Indonesia'', ''0539'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''307'', ''006'', ''Kota Kasablanka'', ''0539'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''308'', ''005'', ''AEON MALL Jakarta Garden City'', ''0539'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''309'', ''004'', ''Mall of Indonesia'', ''0539'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''310'', ''003'', ''Grand Indonesia'', ''0540'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''311'', ''001'', ''Living World Kota Wisata'', ''0540'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''312'', ''002'', ''PIM'', ''0540'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''313'', ''004'', ''Mall of Indonesia'', ''0540'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''314'', ''005'', ''AEON MALL Jakarta Garden City'', ''0540'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''315'', ''006'', ''Kota Kasablanka'', ''0540'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''316'', ''001'', ''Living World Kota Wisata'', ''0541'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''317'', ''003'', ''Grand Indonesia'', ''0541'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''318'', ''002'', ''PIM'', ''0541'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''319'', ''004'', ''Mall of Indonesia'', ''0541'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''320'', ''005'', ''AEON MALL Jakarta Garden City'', ''0541'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''321'', ''006'', ''Kota Kasablanka'', ''0541'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''322'', ''001'', ''Living World Kota Wisata'', ''0542'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''323'', ''002'', ''PIM'', ''0542'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''324'', ''004'', ''Mall of Indonesia'', ''0542'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''325'', ''005'', ''AEON MALL Jakarta Garden City'', ''0542'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''326'', ''006'', ''Kota Kasablanka'', ''0542'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''327'', ''003'', ''Grand Indonesia'', ''0542'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''328'', ''001'', ''Living World Kota Wisata'', ''0543'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''329'', ''002'', ''PIM'', ''0543'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''330'', ''003'', ''Grand Indonesia'', ''0543'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''331'', ''004'', ''Mall of Indonesia'', ''0543'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''332'', ''006'', ''Kota Kasablanka'', ''0543'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''333'', ''005'', ''AEON MALL Jakarta Garden City'', ''0543'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''334'', ''004'', ''Mall of Indonesia'', ''0544'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''335'', ''001'', ''Living World Kota Wisata'', ''0544'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''336'', ''002'', ''PIM'', ''0544'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''337'', ''006'', ''Kota Kasablanka'', ''0544'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''338'', ''005'', ''AEON MALL Jakarta Garden City'', ''0544'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''339'', ''003'', ''Grand Indonesia'', ''0544'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''340'', ''002'', ''PIM'', ''0645'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''341'', ''003'', ''Grand Indonesia'', ''0645'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''342'', ''004'', ''Mall of Indonesia'', ''0645'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''343'', ''006'', ''Kota Kasablanka'', ''0645'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''344'', ''005'', ''AEON MALL Jakarta Garden City'', ''0645'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''345'', ''001'', ''Living World Kota Wisata'', ''0645'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''346'', ''001'', ''Living World Kota Wisata'', ''0646'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''347'', ''003'', ''Grand Indonesia'', ''0646'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''348'', ''002'', ''PIM'', ''0646'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''349'', ''005'', ''AEON MALL Jakarta Garden City'', ''0646'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''350'', ''006'', ''Kota Kasablanka'', ''0646'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''351'', ''004'', ''Mall of Indonesia'', ''0646'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''352'', ''001'', ''Living World Kota Wisata'', ''0647'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''353'', ''003'', ''Grand Indonesia'', ''0647'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''354'', ''004'', ''Mall of Indonesia'', ''0647'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''355'', ''002'', ''PIM'', ''0647'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''356'', ''005'', ''AEON MALL Jakarta Garden City'', ''0647'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''357'', ''006'', ''Kota Kasablanka'', ''0647'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''358'', ''001'', ''Living World Kota Wisata'', ''0648'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''359'', ''002'', ''PIM'', ''0648'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''360'', ''004'', ''Mall of Indonesia'', ''0648'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''361'', ''003'', ''Grand Indonesia'', ''0648'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''362'', ''005'', ''AEON MALL Jakarta Garden City'', ''0648'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''363'', ''006'', ''Kota Kasablanka'', ''0648'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''364'', ''002'', ''PIM'', ''0649'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''365'', ''001'', ''Living World Kota Wisata'', ''0649'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''366'', ''003'', ''Grand Indonesia'', ''0649'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''367'', ''004'', ''Mall of Indonesia'', ''0649'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''368'', ''006'', ''Kota Kasablanka'', ''0649'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''369'', ''005'', ''AEON MALL Jakarta Garden City'', ''0649'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''370'', ''001'', ''Living World Kota Wisata'', ''0650'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''371'', ''004'', ''Mall of Indonesia'', ''0650'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''372'', ''006'', ''Kota Kasablanka'', ''0650'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''373'', ''005'', ''AEON MALL Jakarta Garden City'', ''0650'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''374'', ''002'', ''PIM'', ''0650'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''375'', ''003'', ''Grand Indonesia'', ''0650'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''376'', ''002'', ''PIM'', ''0751'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''377'', ''003'', ''Grand Indonesia'', ''0751'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''378'', ''001'', ''Living World Kota Wisata'', ''0751'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''379'', ''005'', ''AEON MALL Jakarta Garden City'', ''0751'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''380'', ''004'', ''Mall of Indonesia'', ''0751'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''381'', ''006'', ''Kota Kasablanka'', ''0751'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''382'', ''001'', ''Living World Kota Wisata'', ''0752'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''383'', ''003'', ''Grand Indonesia'', ''0752'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''384'', ''002'', ''PIM'', ''0752'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''385'', ''005'', ''AEON MALL Jakarta Garden City'', ''0752'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''386'', ''006'', ''Kota Kasablanka'', ''0752'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''387'', ''004'', ''Mall of Indonesia'', ''0752'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''388'', ''001'', ''Living World Kota Wisata'', ''0753'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''389'', ''002'', ''PIM'', ''0753'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''390'', ''004'', ''Mall of Indonesia'', ''0753'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''391'', ''005'', ''AEON MALL Jakarta Garden City'', ''0753'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''392'', ''006'', ''Kota Kasablanka'', ''0753'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', ''''),
(''393'', ''003'', ''Grand Indonesia'', ''0753'', ''2025-09-10'', ''2099-12-31'', ''0'', NULL, NULL, NULL, NULL, '''', '''');


-- Table structure for table `bir`
DROP TABLE IF EXISTS `bir`;
CREATE TABLE `bir` (
  `cabang` varchar(20) DEFAULT NULL,
  `nomor` varchar(16) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `shift` varchar(1) DEFAULT NULL,
  `cover` int(11) DEFAULT NULL,
  `note1` varchar(20) DEFAULT NULL,
  `note2` varchar(20) DEFAULT NULL,
  `kasir` varchar(10) DEFAULT NULL,
  `waiter` varchar(10) DEFAULT NULL,
  `cab` varchar(3) DEFAULT NULL,
  `meja` varchar(15) DEFAULT NULL,
  `barang` varchar(10) DEFAULT NULL,
  `nama` varchar(30) DEFAULT NULL,
  `qtt` double DEFAULT NULL,
  `netto` double DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `time` varchar(2) DEFAULT NULL,
  `category` varchar(13) DEFAULT NULL,
  `kode` varchar(10) DEFAULT NULL,
  `jenis` varchar(10) DEFAULT NULL,
  `segmen` varchar(9) DEFAULT NULL,
  `gross_sale` double DEFAULT NULL,
  `service` double DEFAULT NULL,
  `pb1` double DEFAULT NULL,
  `total` double DEFAULT NULL,
  `harga` double DEFAULT NULL,
  `top` varchar(10) DEFAULT NULL,
  `bulan` varchar(12) DEFAULT NULL,
  `tahun` varchar(4) DEFAULT NULL,
  `day` varchar(10) DEFAULT NULL,
  `hari` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=ascii COLLATE=ascii_bin;

-- Dumping data for table `bir`
INSERT INTO `bir` (`cabang`, `nomor`, `tanggal`, `shift`, `cover`, `note1`, `note2`, `kasir`, `waiter`, `cab`, `meja`, `barang`, `nama`, `qtt`, `netto`, `discount`, `time`, `category`, `kode`, `jenis`, `segmen`, `gross_sale`, `service`, `pb1`, `total`, `harga`, `top`, `bulan`, `tahun`, `day`, `hari`) VALUES
(''PVJ BANDUNG'', ''031123-000001'', ''2023-01-01'', ''0'', ''2'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1307'', ''FULL BREAKFAST'', ''1'', ''83000'', ''0'', ''12'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000001'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000001'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1308'', ''GRILLED SAUSAGE WITH HASH BRO'', ''1'', ''84000'', ''0'', ''12'', ''BREAKFAST'', ''1308'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000001'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''12'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000001'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''12'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000002'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''12'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000002'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''12'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000002'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''12'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''3'', ''W. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1307'', ''FULL BREAKFAST'', ''2'', ''166000'', ''0'', ''12'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''166000'', ''9130.02'', ''17514'', ''192644.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''12'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''12'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''2'', ''94000'', ''0'', ''12'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''94000'', ''5170.02'', ''9918'', ''109088.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''12'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''12'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000003'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''12'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000004'', ''2023-01-01'', ''0'', ''1'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''13'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000004'', ''2023-01-01'', ''0'', ''0'', ''PETTY MEDIUM'', ''PETTY MEDIUM'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''13'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000006'', ''2023-01-01'', ''0'', ''1'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''13'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000006'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000006'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000006'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''13'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000006'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''13'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000006'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''13'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000006'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''13'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''8'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''13'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''NOCABE'', ''NOCABE'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''13'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''4 GLS'', ''4 GLS'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3810'', ''BINTANG (L)'', ''2'', ''136000'', ''0'', ''13'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''136000'', ''7480.02'', ''14348'', ''157828.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''13'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1260'', ''BBQ CHICKEN (S)'', ''1'', ''70000'', ''0'', ''13'', ''SAVOURY PANCA'', ''1260'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''97001'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER SAVO'', ''97001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''13'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''13'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''OUT T 2'', ''OUT T 2'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''13'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''3'', ''54000'', ''0'', ''13'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5697'', ''62667.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', ''HOT'', ''HOT'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''13'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3605'', ''ESPRESSO'', ''2'', ''80000'', ''0'', ''13'', ''COFFEE'', ''3605'', ''Minuman'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000007'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''13'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000008'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''13'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000008'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''2000777'', ''SMOKED BEEF SPAGHETTI'', ''1'', ''0'', ''0'', ''13'', ''STAMPS PROMO'', ''2000777'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''14'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''14'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''14'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''14'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''14'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', ''TANPA TABURAN LADA H'', ''TANPA TABURAN LADA H'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''14'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000009'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''14'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''2'', ''54000'', ''0'', ''14'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5698'', ''62668.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''14'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''14'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''14'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', ''EXTRA CHIPS'', ''EXTRA CHIPS'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''14'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''14'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''14'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000010'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''14'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000011'', ''2023-01-01'', ''0'', ''0'', ''NO PAPPER'', ''NO PAPPER'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''14'', ''RISOTTO'', ''1904'', ''Makanan'', ''TAKE AWAY'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000012'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000012'', ''2023-01-01'', ''0'', ''0'', ''ICE'', ''ICE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''14'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000012'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''14'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000012'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''14'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''14'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3532'', ''ICE WHITE CHOCOLATE'', ''1'', ''45000'', ''0'', ''14'', ''CHOCOLATE'', ''3532'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''14'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''NO TOMATO'', ''NO TOMATO'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''14'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''CROFFLE'', ''CROFFLE'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''8713'', ''FRIED CHICK (C)'', ''1'', ''92000'', ''0'', ''14'', ''CROFFLE'', ''8713'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''CROFFLE'', ''CROFFLE'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''8803'', ''CROFFLE'', ''1'', ''0'', ''0'', ''14'', ''CROFFLE C'', ''8803'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''MEDIUM RARE'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''14'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''MEDIUM RARE'', ''MEDIUM RARE'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''7422'', ''MEDIUM RARE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER STEA'', ''7422'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''CREAMY BLACK PEPPER'', ''CREAMY BLACK PEPPER'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''7442'', ''CREAMY BLACK PEPPER'', ''1'', ''0'', ''0'', ''14'', ''SAUCE'', ''7442'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''14'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000013'', ''2023-01-01'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3526'', ''HONEYCOMB SHAKE'', ''1'', ''55000'', ''0'', ''14'', ''FROSTY SMOOTH'', ''3526'', ''Minuman'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''14'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''14'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''MEDIUM WELL'', ''CHIPS'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''14'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''MEDIUM WELL'', ''MEDIUM WELL'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7424'', ''MEDIUM WELL'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER STEA'', ''7424'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''14'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''14'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''14'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1537'', ''CURRY KATSU'', ''1'', ''87000'', ''0'', ''14'', ''PASTA'', ''1537'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''14'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''14'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000014'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000015'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''14'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000015'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''14'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000015'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''14'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000015'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000015'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000015'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000015'', ''2023-01-01'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6139'', ''Add 1 W.original'', ''1'', ''15000'', ''0'', ''14'', ''EXTRA'', ''6139'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', ''K'', ''3331'', ''FRESH APPLE'', ''2'', ''90000'', ''0'', ''15'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''90000'', ''4950.02'', ''9496'', ''104446.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', ''K'', ''3513'', ''ICE CAFE LATTE'', ''2'', ''98000'', ''0'', ''15'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''98000'', ''5390.02'', ''10340'', ''113730.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1307'', ''FULL BREAKFAST'', ''2'', ''166000'', ''0'', ''15'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''166000'', ''9130.02'', ''17514'', ''192644.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', ''K'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''15'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1255'', ''SAUTEED CHICKEN & MUSHROOM (S)'', ''1'', ''70000'', ''0'', ''15'', ''SAVOURY PANCA'', ''1255'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''15'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000016'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''TARI'', ''Sun'', ''K'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''15'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000017'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''BAYU'', ''TARI'', ''Sun'', ''P'', ''3814'', ''BINTANG RADLER LEMON'', ''1'', ''38000'', ''0'', ''15'', ''LOCAL BEER'', ''3814'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000017'', ''2023-01-01'', ''0'', ''0'', ''OUT T K'', ''OUT T K'', ''BAYU'', ''TARI'', ''Sun'', ''P'', ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''15'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000017'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''BAYU'', ''TARI'', ''Sun'', ''P'', ''1258'', ''BEEF & BLUE CHEESE (S)'', ''1'', ''93000'', ''0'', ''15'', ''SAVOURY PANCA'', ''1258'', ''Makanan'', ''DINE IN'', ''93000'', ''5115.02'', ''9812'', ''107927.02'', ''93000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000017'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''BAYU'', ''TARI'', ''Sun'', ''P'', ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000017'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''BAYU'', ''TARI'', ''Sun'', ''P'', ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000017'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', ''TARI'', ''Sun'', ''P'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''1'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''15'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''15'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''15'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''15'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''15'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000018'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000019'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''MUSTARD & PESTO'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''15'', ''STEAK'', ''1706'', ''Makanan'', ''TAKE AWAY'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000019'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000019'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000019'', ''2023-01-01'', ''0'', ''0'', ''MUSTARD & PESTO'', ''MUSTARD & PESTO'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''7490'', ''MUSTARD & PESTO'', ''1'', ''0'', ''0'', ''15'', ''COND STEAK -1'', ''7490'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000020'', ''2023-01-01'', ''0'', ''1'', ''P. CHOCOLATE'', ''CHOCO ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1103'', ''COCO PANCIOUS (S)'', ''1'', ''55000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1103'', ''Makanan'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000020'', ''2023-01-01'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''15'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''2'', ''DAHULUKAN'', ''DAHULUKAN'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''15'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''15'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''SALAD'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''15'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''15'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000021'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''15'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''0'', ''VEGETARIAN'', ''VEGETARIAN'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1302'', ''OMELET'', ''1'', ''68000'', ''0'', ''15'', ''BREAKFAST'', ''1302'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''15'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''15'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000022'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''2'', ''100000'', ''0'', ''15'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''15'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''6124'', ''EX-SLICED CHEESE'', ''1'', ''10500'', ''0'', ''15'', ''EXTRA'', ''6124'', ''Makanan'', ''DINE IN'', ''10500'', ''577.52'', ''1108'', ''12185.52'', ''10500'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''15'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''15'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''6115'', ''EX-MOZZARELLA CHS'', ''1'', ''8500'', ''0'', ''15'', ''EXTRA'', ''6115'', ''Makanan'', ''DINE IN'', ''8500'', ''467.52'', ''897'', ''9864.52'', ''8500'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''15'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''MEDIUM'', ''MASHED POTATO'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''2'', ''546000'', ''0'', ''15'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''546000'', ''30030.02'', ''57604'', ''633634.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000023'', ''2023-01-01'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''15'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''15'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''15'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''15'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''15'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1902'', ''MUSHROOM RISOTTO WITH CHICK'', ''1'', ''95000'', ''0'', ''15'', ''RISOTTO'', ''1902'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''2'', ''184000'', ''0'', ''15'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''184000'', ''10120.02'', ''19412'', ''213532.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1103'', ''COCO PANCIOUS (S)'', ''1'', ''55000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1103'', ''Makanan'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000024'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000025'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''2'', ''100000'', ''0'', ''15'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000025'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''15'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000025'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''SALAD'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''15'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000025'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000025'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TANIA'', ''TANIA'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''4'', ''COLD'', ''COLD'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''15'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CORN'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''15'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''GRILLED POTATO'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''15'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''NO CHEES'', ''NO CHEES'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''1601'', ''CHEESE BURGER'', ''2'', ''190000'', ''0'', ''15'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''190000'', ''10450.02'', ''20046'', ''220496.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''15'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''6124'', ''EX-SLICED CHEESE'', ''1'', ''10500'', ''0'', ''15'', ''EXTRA'', ''6124'', ''Makanan'', ''DINE IN'', ''10500'', ''577.52'', ''1108'', ''12185.52'', ''10500'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', ''OUT TGETHER'', ''OUT TGETHER'', ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''15'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000026'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', ''P'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''15'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''8'', ''SALAD'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1704'', ''CHICKEN STEAK'', ''1'', ''113400'', ''12600'', ''15'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6237.02'', ''11964'', ''131601.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''106200'', ''11800'', ''15'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''5841.02'', ''11204'', ''123245.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''90000'', ''10000'', ''15'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''4950.02'', ''9495'', ''104445.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''OUT TABLE J'', ''OUT TABLE J'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1403'', ''GRILLED BABY POTATO (R)'', ''1'', ''55800'', ''6200'', ''15'', ''APPETIZER'', ''1403'', ''Makanan'', ''DINE IN'', ''62000'', ''3069.02'', ''5887'', ''64756.02'', ''62000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''72000'', ''8000'', ''15'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''3960.02'', ''7596'', ''83556.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''87300'', ''9700'', ''15'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''4801.52'', ''9210'', ''101311.52'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''70200'', ''7800'', ''15'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''3861.02'', ''7406'', ''81467.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''OUT TABLE A'', ''OUT TABLE A'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''79200'', ''8800'', ''15'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4356.02'', ''8356'', ''91912.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''3513'', ''ICE CAFE LATTE'', ''1'', ''44100'', ''4900'', ''15'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2425.52'', ''4653'', ''51178.52'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000027'', ''2023-01-01'', ''0'', ''0'', ''ICE'', ''ICE'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''3403'', ''LEMON TEA'', ''1'', ''40500'', ''4500'', ''15'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2227.52'', ''4273'', ''47000.52'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000028'', ''2023-01-01'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''GEDE'', ''Sun'', ''H'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''15'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000028'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''GEDE'', ''Sun'', ''H'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000028'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', ''H'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''15'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000028'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', ''H'', ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''15'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000028'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''GEDE'', ''Sun'', ''H'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000028'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''GEDE'', ''Sun'', ''H'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000028'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''GEDE'', ''Sun'', ''H'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000029'', ''2023-01-01'', ''0'', ''3'', ''CREPES CAKE'', ''CREPES CAKE'', ''NANIK'', ''TARI'', ''Sun'', ''Coyote'', ''1801'', ''PANCIOUS ORIGINAL (CC)'', ''1'', ''63000'', ''0'', ''16'', ''CREPES'', ''1801'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000029'', ''2023-01-01'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''NANIK'', ''TARI'', ''Sun'', ''Coyote'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000029'', ''2023-01-01'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''NANIK'', ''TARI'', ''Sun'', ''Coyote'', ''1827'', ''WALNUT (CC)'', ''1'', ''72000'', ''0'', ''16'', ''CREPES'', ''1827'', ''Makanan'', ''DINE IN'', ''72000'', ''3960.02'', ''7596'', ''83556.02'', ''72000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000029'', ''2023-01-01'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''NANIK'', ''TARI'', ''Sun'', ''Coyote'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000029'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000029'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''3'', ''ICE'', ''ICE'', ''NANIK'', NULL, ''Sun'', ''B'', ''3403'', ''LEMON TEA'', ''2'', ''90000'', ''0'', ''16'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''90000'', ''4950.02'', ''9496'', ''104446.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''16'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', NULL, ''Sun'', ''B'', ''1510'', ''CREAMY MARINARA SALMON'', ''1'', ''113000'', ''0'', ''16'', ''PASTA'', ''1510'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', NULL, ''Sun'', ''B'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', NULL, ''Sun'', ''B'', ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''16'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', NULL, ''Sun'', ''B'', ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''GARLIC MASHED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''16'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', NULL, ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', NULL, ''Sun'', ''B'', ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', NULL, ''Sun'', ''B'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000030'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''B'', ''3619'', ''LONG BLACK'', ''1'', ''45000'', ''0'', ''16'', ''COFFEE'', ''3619'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''3'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''E'', ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''16'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''16'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000031'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''TARI'', ''Sun'', ''E'', ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''4'', ''ICE'', ''ICE'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''3403'', ''LEMON TEA'', ''3'', ''135000'', ''0'', ''16'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''135000'', ''7425.02'', ''14244'', ''156669.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''16'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''16'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''16'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''16'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''16'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000032'', ''2023-01-01'', ''0'', ''0'', ''ICE'', ''ICE'', ''NANIK'', NULL, ''Sun'', ''K'', ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''16'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000033'', ''2023-01-01'', ''0'', ''1'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''16'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000033'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CORN'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''16'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000033'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000033'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000033'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''16'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000033'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000034'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3602'', ''CAFFE LATTE'', ''1'', ''42000'', ''0'', ''16'', ''COFFEE'', ''3602'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000034'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1403'', ''GRILLED BABY POTATO (R)'', ''1'', ''62000'', ''0'', ''16'', ''APPETIZER'', ''1403'', ''Makanan'', ''DINE IN'', ''62000'', ''3410.02'', ''6541'', ''71951.02'', ''62000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000034'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1260'', ''BBQ CHICKEN (S)'', ''1'', ''70000'', ''0'', ''16'', ''SAVOURY PANCA'', ''1260'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000034'', ''2023-01-01'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000034'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000034'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000035'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''16'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000035'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000035'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000035'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''16'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3546'', ''ICED CRISP COFFEE'', ''1'', ''47000'', ''0'', ''16'', ''COLD DRINKS\nC'', ''3546'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''16'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3513'', ''ICE CAFE LATTE'', ''1'', ''49000'', ''0'', ''16'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''16'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''97026'', ''CHOCO ICE CREAM'', ''1'', ''19000'', ''0'', ''16'', ''EXTRA ICE CRE'', ''97026'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''16'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000036'', ''2023-01-01'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''97025'', ''VANILLA ICE CREAM'', ''1'', ''19000'', ''0'', ''16'', ''EXTRA ICE CRE'', ''97025'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000037'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''16'', ''APPETIZER'', ''1405'', ''Makanan'', ''TAKE AWAY'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000037'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''16'', ''RISOTTO'', ''1904'', ''Makanan'', ''TAKE AWAY'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000038'', ''2023-01-01'', ''0'', ''0'', ''NO SGAR'', ''NO SGAR'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''16'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''TAKE AWAY'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000039'', ''2023-01-01'', ''0'', ''3'', ''ICE'', ''ICE'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''17'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000039'', ''2023-01-01'', ''0'', ''0'', ''NO SUGAR'', ''NO SUGAR'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''17'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000039'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''17'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000039'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''17'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000039'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''17'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000039'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''17'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000039'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''17'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000040'', ''2023-01-01'', ''0'', ''1'', ''TELOR MATANG'', ''TELOR MATANG'', ''NANIK'', ''BAYU'', ''Sun'', ''J'', ''1614'', ''BIG BURGER'', ''1'', ''0'', ''110000'', ''17'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''0'', ''0'', ''0'', ''110000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000040'', ''2023-01-01'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''NANIK'', ''BAYU'', ''Sun'', ''J'', ''99001'', ''TELOR MATANG'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER TELO'', ''99001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000041'', ''2023-01-01'', ''0'', ''4'', ''3 GLAS'', ''3 GLAS'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''17'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000041'', ''2023-01-01'', ''0'', ''0'', ''CREPES CAKE'', ''CHOCO ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1818'', ''COCO BAILEYS (CC)'', ''1'', ''81000'', ''0'', ''17'', ''CREPES'', ''1818'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000041'', ''2023-01-01'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000041'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1101'', ''PANCIOUS ORI (S)'', ''1'', ''50000'', ''0'', ''17'', ''SWEET PANCAKE'', ''1101'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000041'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''17'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000041'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''8802'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''17'', ''PANCAKE ORI'', ''8802'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000042'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''17'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000042'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1435'', ''CHICK RANCH SALAD'', ''1'', ''89000'', ''0'', ''17'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''89000'', ''4895.02'', ''9390'', ''103285.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000042'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''CORN'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''17'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000042'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000042'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000042'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''17'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000042'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''17'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1412'', ''GRILLED BABY POTATO (S)'', ''1'', ''55000'', ''0'', ''18'', ''APPETIZER'', ''1412'', ''Makanan'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1505'', ''MUSHROM PASTA'', ''1'', ''82000'', ''0'', ''18'', ''PASTA'', ''1505'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''18'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''0'', ''3 GLSS'', ''3 GLSS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''18'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000043'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''4'', ''COLD'', ''COLD'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''18'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''18'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1103'', ''COCO PANCIOUS (S)'', ''2'', ''110000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1103'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11606'', ''127656.02'', ''55000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''18'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''18'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1502'', ''CARBONARA'', ''2'', ''176000'', ''0'', ''18'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''176000'', ''9680.02'', ''18568'', ''204248.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000044'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''18'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''1'', ''PENNE'', ''PENNE'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''18'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''18'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''18'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''GARLIC MASHED POTATO'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''18'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''18'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000045'', ''2023-01-01'', ''0'', ''0'', ''SEDIKIT ICE'', ''SEDIKIT ICE'', ''TARI'', NULL, ''Sun'', NULL, ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''18'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''18'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''18'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''6139'', ''Add 1 W.original'', ''1'', ''15000'', ''0'', ''18'', ''EXTRA'', ''6139'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''1505'', ''MUSHROM PASTA'', ''1'', ''82000'', ''0'', ''18'', ''PASTA'', ''1505'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''6139'', ''Add 1 W.original'', ''1'', ''15000'', ''0'', ''18'', ''EXTRA'', ''6139'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1505'', ''MUSHROM PASTA'', ''1'', ''82000'', ''0'', ''18'', ''PASTA'', ''1505'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000046'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000047'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''18'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000047'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''18'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000047'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3332'', ''MIXED APPLE + ORANGE'', ''1'', ''50000'', ''0'', ''18'', ''PRESSED JUICE'', ''3332'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000047'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''18'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''18'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''18'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''GRILLED POTATO'', ''TARI'', NULL, ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''18'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', NULL, ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', NULL, ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''CORN'', ''TARI'', NULL, ''Sun'', NULL, ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''18'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', NULL, ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', NULL, ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''18'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000048'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000049'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3401'', ''ICE TEA'', ''1'', ''26100'', ''2900'', ''18'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1435.52'', ''2754'', ''30289.52'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000049'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''1520'', ''SALMON PESTO'', ''1'', ''101700'', ''11300'', ''18'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''5593.52'', ''10729'', ''118022.52'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000049'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000050'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3519'', ''MANGGO SURPRISE'', ''1'', ''45000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3519'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000050'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000050'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000050'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''19'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000051'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000051'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''19'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000051'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000051'', ''2023-01-01'', ''0'', ''0'', ''CROFFLE'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''8709'', ''RICOTTA & RASPBERRY (C)'', ''1'', ''76000'', ''0'', ''19'', ''CROFFLE'', ''8709'', ''Makanan'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000051'', ''2023-01-01'', ''0'', ''0'', ''CROFFLE'', ''CROFFLE'', ''TARI'', NULL, ''Sun'', NULL, ''8803'', ''CROFFLE'', ''1'', ''0'', ''0'', ''19'', ''CROFFLE C'', ''8803'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3402'', ''HOT TEA'', ''2'', ''58000'', ''0'', ''19'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1307'', ''FULL BREAKFAST'', ''1'', ''83000'', ''0'', ''19'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''19'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''19'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''19'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000052'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000053'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000053'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''19'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000053'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000053'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000053'', ''2023-01-01'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''19'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''11'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''19'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''19'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''19'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''19'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''1258'', ''BEEF & BLUE CHEESE (S)'', ''1'', ''93000'', ''0'', ''19'', ''SAVOURY PANCA'', ''1258'', ''Makanan'', ''DINE IN'', ''93000'', ''5115.02'', ''9812'', ''107927.02'', ''93000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TANIA'', ''TANIA'', ''Sun'', ''.'', ''97001'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER SAVO'', ''97001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''19'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''1421'', ''GREEN PEAS SOUP'', ''1'', ''60000'', ''0'', ''19'', ''APPETIZER'', ''1421'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''19'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''19'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''19'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''97001'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER SAVO'', ''97001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''19'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''WISNU'', ''Sun'', ''.'', ''6124'', ''EX-SLICED CHEESE'', ''1'', ''10500'', ''0'', ''19'', ''EXTRA'', ''6124'', ''Makanan'', ''DINE IN'', ''10500'', ''577.52'', ''1108'', ''12185.52'', ''10500'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''DESI'', ''Sun'', ''.'', ''3202'', ''FRESH FRUIT COCKTAIL'', ''2'', ''152000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''152000'', ''8360.02'', ''16036'', ''176396.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''DESI'', ''Sun'', ''.'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''19'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000054'', ''2023-01-01'', ''0'', ''0'', ''KENTANGNYA MINTA KER'', ''KENTANGNYA MINTA KER'', ''TANIA'', ''DESI'', ''Sun'', ''.'', ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''19'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''3'', ''WARM'', ''WARM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''19'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''19'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000055'', ''2023-01-01'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''19'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000056'', ''2023-01-01'', ''0'', ''1'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', ''.'', ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000056'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TANIA'', ''Sun'', ''.'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''4'', ''SEDIKIT GULA'', ''SEDIKIT GULA'', ''BAYU'', NULL, ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''2'', ''100000'', ''0'', ''19'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''BAYU'', NULL, ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', NULL, ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''BAYU'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''BAYU'', NULL, ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''BAYU'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''BAYU'', NULL, ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', NULL, ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''WISNU'', ''Sun'', NULL, ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''19'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''BAYU'', ''WISNU'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''19'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000057'', ''2023-01-01'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''BAYU'', ''WISNU'', ''Sun'', NULL, ''97025'', ''VANILLA ICE CREAM'', ''1'', ''19000'', ''0'', ''19'', ''EXTRA ICE CRE'', ''97025'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''1'', NULL, NULL, ''BAYU'', ''WISNU'', ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''MASHED POTATO'', ''BAYU'', NULL, ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''BAYU'', NULL, ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''BAYU'', NULL, ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''BAYU'', NULL, ''Sun'', NULL, ''6122'', ''EX-SALAD DRESSING'', ''1'', ''8500'', ''0'', ''20'', ''EXTRA'', ''6122'', ''Makanan'', ''DINE IN'', ''8500'', ''467.52'', ''897'', ''9864.52'', ''8500'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''BAYU'', NULL, ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''BAYU'', NULL, ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000058'', ''2023-01-01'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''BAYU'', NULL, ''Sun'', NULL, ''6107'', ''EX-CHICKEN(PASTA)'', ''1'', ''14000'', ''0'', ''20'', ''EXTRA'', ''6107'', ''Makanan'', ''DINE IN'', ''14000'', ''770.02'', ''1477'', ''16247.02'', ''14000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000059'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''BAYU'', ''WISNU'', ''Sun'', ''H'', ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000059'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''BAYU'', ''WISNU'', ''Sun'', ''H'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''20'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000059'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''BAYU'', ''WISNU'', ''Sun'', ''H'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000059'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''WISNU'', ''Sun'', ''H'', ''1507'', ''HOT TUNA'', ''1'', ''82000'', ''0'', ''20'', ''PASTA'', ''1507'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000059'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''WISNU'', ''Sun'', ''H'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''2'', ''132000'', ''0'', ''20'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3332'', ''MIXED APPLE + ORANGE'', ''1'', ''50000'', ''0'', ''20'', ''PRESSED JUICE'', ''3332'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3620'', ''FLAT WHITE'', ''1'', ''44000'', ''0'', ''20'', ''COFFEE'', ''3620'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''20'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1540'', ''OCEAN KING'', ''2'', ''226000'', ''0'', ''20'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''226000'', ''12430.02'', ''23844'', ''262274.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1728'', ''CHICK O CHILLI'', ''2'', ''236000'', ''0'', ''20'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''236000'', ''12980.02'', ''24898'', ''273878.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000060'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3332'', ''MIXED APPLE + ORANGE'', ''1'', ''50000'', ''0'', ''20'', ''PRESSED JUICE'', ''3332'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''2'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''20'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''CHIPS'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''AYU'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''20'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''AYU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''WISNU'', ''Sun'', NULL, ''3518'', ''FANTASY JELLY'', ''1'', ''43000'', ''0'', ''20'', ''SPECIAL DRINK'', ''3518'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''WISNU'', ''Sun'', NULL, ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''20'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''1536'', ''PASTA LIDAH CABE HIJAU'', ''1'', ''95000'', ''0'', ''20'', ''PASTA'', ''1536'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''GARLIC MASHED POTATO'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''20'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000061'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000062'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''20'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000062'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''20'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000062'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''20'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000062'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000062'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3416'', ''HOMEMADE GINGER TEA'', ''1'', ''42000'', ''0'', ''20'', ''TEA'', ''3416'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000062'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''20'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''2'', ''DI BUNGKUS'', ''DI BUNGKUS'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''3612'', ''HOT WHITE CHOCOLATE'', ''1'', ''43000'', ''0'', ''20'', ''CHOCOLATE'', ''3612'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''K'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''20'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''K'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''20'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''K'', ''1428'', ''FRIED MAC & CHEESE'', ''2'', ''134000'', ''0'', ''20'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''134000'', ''7370.02'', ''14138'', ''155508.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''SALAD'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''1722'', ''GRILL TRUFFLE CHICKEN'', ''1'', ''116000'', ''0'', ''20'', ''STEAK'', ''1722'', ''Makanan'', ''DINE IN'', ''116000'', ''6380.02'', ''12238'', ''134618.02'', ''116000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000063'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''K'', ''3331'', ''FRESH APPLE'', ''2'', ''90000'', ''0'', ''20'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''90000'', ''4950.02'', ''9496'', ''104446.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''4'', ''JNGN TERLALU PANAS'', ''JNGN TERLALU PANAS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1421'', ''GREEN PEAS SOUP'', ''1'', ''60000'', ''0'', ''20'', ''APPETIZER'', ''1421'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''20'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''WELLDONE'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''20'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''20'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''20'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3814'', ''BINTANG RADLER LEMON'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3814'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3814'', ''BINTANG RADLER LEMON'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3814'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000064'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000065'', ''2023-01-01'', ''0'', ''2'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000065'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''20'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000065'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000065'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000065'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''20'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000066'', ''2023-01-01'', ''0'', ''1'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', NULL, ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''20'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000066'', ''2023-01-01'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', NULL, ''Sun'', NULL, ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000066'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''20'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''J'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''J'', ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', ''J'', ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''21'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', ''J'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', ''J'', ''1505'', ''MUSHROM PASTA'', ''1'', ''82000'', ''0'', ''21'', ''PASTA'', ''1505'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', ''J'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''J'', ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''21'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000067'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''J'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', NULL, ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''1 LESS ICE 3BIJI ES'', ''1 LESS ICE 3BIJI ES'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''3'', ''87000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''87000'', ''4785.02'', ''9180'', ''100965.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''21'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''21'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''21'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''21'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''21'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''6140'', ''Add 1 W.choco'', ''1'', ''23000'', ''0'', ''21'', ''EXTRA'', ''6140'', ''Makanan'', ''DINE IN'', ''23000'', ''1265.02'', ''2427'', ''26692.02'', ''23000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''21'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000068'', ''2023-01-01'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''BAYU'', ''Sun'', NULL, ''6140'', ''Add 1 W.choco'', ''1'', ''23000'', ''0'', ''21'', ''EXTRA'', ''6140'', ''Makanan'', ''DINE IN'', ''23000'', ''1265.02'', ''2427'', ''26692.02'', ''23000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''E'', ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''E'', ''3402'', ''HOT TEA'', ''2'', ''58000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''E'', ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''E'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''E'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''21'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''E'', ''1412'', ''GRILLED BABY POTATO (S)'', ''1'', ''55000'', ''0'', ''21'', ''APPETIZER'', ''1412'', ''Makanan'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''E'', ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''21'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''21'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''E'', ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''21'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', ''E'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', ''E'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000069'', ''2023-01-01'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''DESI'', ''Sun'', ''E'', ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''21'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''2'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', ''B'', ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', ''B'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', ''B'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', ''B'', ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''21'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', ''B'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''0'', ''X GLS'', ''X GLS'', ''TARI'', ''AYU'', ''Sun'', ''B'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', ''B'', ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''21'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000070'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', ''B'', ''3519'', ''MANGGO SURPRISE'', ''1'', ''45000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3519'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''21'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''21'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''21'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''21'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''21'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''21'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''3'', ''87000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''87000'', ''4785.02'', ''9180'', ''100965.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''TERIYAKI SALSA'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''21'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''21'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''21'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''97025'', ''VANILLA ICE CREAM'', ''1'', ''19000'', ''0'', ''21'', ''EXTRA ICE CRE'', ''97025'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''21'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000071'', ''2023-01-01'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''97026'', ''CHOCO ICE CREAM'', ''1'', ''19000'', ''0'', ''21'', ''EXTRA ICE CRE'', ''97026'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''3'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3602'', ''CAFFE LATTE'', ''1'', ''42000'', ''0'', ''21'', ''COFFEE'', ''3602'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''21'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''GRILLED POTATO'', ''TARI'', NULL, ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', NULL, ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', NULL, ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000072'', ''2023-01-01'', ''0'', ''0'', ''NO PTONGAN CABE'', ''NO PTONGAN CABE'', ''TARI'', NULL, ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''21'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000073'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3307'', ''FRESH ORANGE'', ''2'', ''132000'', ''0'', ''21'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000073'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000073'', ''2023-01-01'', ''0'', ''0'', ''ICE'', ''ICE'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''21'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000073'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''21'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000073'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000073'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''1402'', ''FRIED CHIPS (R)'', ''2'', ''116000'', ''0'', ''21'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''116000'', ''6380.02'', ''12238'', ''134618.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''21'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1537'', ''CURRY KATSU'', ''1'', ''87000'', ''0'', ''21'', ''PASTA'', ''1537'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000074'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''4'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', NULL, ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', NULL, ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', NULL, ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''0'', ''NO BLAC PAPER'', ''NO BLAC PAPER'', ''TARI'', NULL, ''Sun'', NULL, ''1908'', ''CHICKEN BALSAMIC RISOTTO'', ''1'', ''95000'', ''0'', ''21'', ''RISOTTO'', ''1908'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1313'', ''TRUFFLE MUSHROOM OMELETTE'', ''1'', ''83000'', ''0'', ''21'', ''BREAKFAST'', ''1313'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''0'', ''NO SPINACH'', ''NO SPINACH'', ''TARI'', NULL, ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''21'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''SOMA PALEMBANG'', ''031123-000075'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''21'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000076'', ''2023-01-01'', ''0'', ''4'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000076'', ''2023-01-01'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000076'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''TSM MAKASAR'', ''031123-000076'', ''2023-01-01'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''5'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''K'', ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''K'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''WELLDONE'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''TERIYAKI SALSA'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''21'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''21'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''TERIYAKI SALSA'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''21'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''21'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''1722'', ''GRILL TRUFFLE CHICKEN'', ''1'', ''116000'', ''0'', ''21'', ''STEAK'', ''1722'', ''Makanan'', ''DINE IN'', ''116000'', ''6380.02'', ''12238'', ''134618.02'', ''116000'', ''FOOD'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''3105'', ''MINERAL WATER'', ''3'', ''54000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5697'', ''62667.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''BALI'', ''031123-000077'', ''2023-01-01'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''K'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''01'', ''Sunday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''3'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''12'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3615'', ''CAFFE MOCHA'', ''1'', ''42000'', ''0'', ''12'', ''COFFEE'', ''3615'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''12'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1101'', ''PANCIOUS ORI (S)'', ''1'', ''50000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1101'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6137'', ''Add 1 P.choco'', ''1'', ''23000'', ''0'', ''12'', ''EXTRA'', ''6137'', ''Makanan'', ''DINE IN'', ''23000'', ''1265.02'', ''2427'', ''26692.02'', ''23000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''1313'', ''TRUFFLE MUSHROOM OMELETTE'', ''1'', ''83000'', ''0'', ''12'', ''BREAKFAST'', ''1313'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000078'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''12'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000079'', ''2023-01-02'', ''0'', ''2'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''12'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000079'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''12'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000079'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''12'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000079'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''12'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000079'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''12'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000080'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''12'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000080'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''12'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000080'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''12'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000080'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''12'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000080'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000080'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''4'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''12'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', ''K'', ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''12'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', ''K'', ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''12'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''12'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000081'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''BAYU'', ''DESI'', ''Sun'', ''K'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''12'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000082'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''12'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''TAKE AWAY'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000082'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1405'', ''CREAMY MUSHROM SOUP'', ''2'', ''132000'', ''0'', ''12'', ''APPETIZER'', ''1405'', ''Makanan'', ''TAKE AWAY'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000082'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''12'', ''PASTA'', ''1502'', ''Makanan'', ''TAKE AWAY'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000082'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''12'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000083'', ''2023-01-02'', ''0'', ''5'', ''DOUBLE'', ''DOUBLE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3605'', ''ESPRESSO'', ''1'', ''40000'', ''0'', ''12'', ''COFFEE'', ''3605'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000083'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''12'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000083'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1302'', ''OMELET'', ''1'', ''68000'', ''0'', ''12'', ''BREAKFAST'', ''1302'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000083'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1307'', ''FULL BREAKFAST'', ''1'', ''83000'', ''0'', ''12'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000083'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000083'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1308'', ''GRILLED SAUSAGE WITH HASH BRO'', ''2'', ''168000'', ''0'', ''12'', ''BREAKFAST'', ''1308'', ''Makanan'', ''DINE IN'', ''168000'', ''9240.02'', ''17724'', ''194964.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''7'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''13'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''13'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''13'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''13'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''13'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''13'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''13'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''13'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''13'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''13'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1307'', ''FULL BREAKFAST'', ''1'', ''83000'', ''0'', ''13'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''13'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''1435'', ''CHICK RANCH SALAD'', ''1'', ''89000'', ''0'', ''13'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''89000'', ''4895.02'', ''9390'', ''103285.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''13'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''2'', ''200000'', ''0'', ''13'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''200000'', ''11000.02'', ''21100'', ''232100.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000084'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''13'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000085'', ''2023-01-02'', ''0'', ''3'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''13'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000085'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000085'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000085'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000087'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''BAYU'', ''DESI'', ''Sun'', ''TakeAway'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''13'', ''STEAK'', ''1712'', ''Makanan'', ''TAKE AWAY'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000087'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''BAYU'', ''DESI'', ''Sun'', ''TakeAway'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7431'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000087'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''BAYU'', ''DESI'', ''Sun'', ''TakeAway'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7432'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''5'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''13'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''13'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''3519'', ''MANGGO SURPRISE'', ''1'', ''45000'', ''0'', ''13'', ''SPECIAL DRINK'', ''3519'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''EKSPRESOO SETENGA'', ''EKSPRESOO SETENGA'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''3616'', ''MACCHIATO'', ''1'', ''42000'', ''0'', ''13'', ''COFFEE'', ''3616'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''1308'', ''GRILLED SAUSAGE WITH HASH BRO'', ''2'', ''168000'', ''0'', ''13'', ''BREAKFAST'', ''1308'', ''Makanan'', ''DINE IN'', ''168000'', ''9240.02'', ''17724'', ''194964.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''1307'', ''FULL BREAKFAST'', ''1'', ''83000'', ''0'', ''13'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''13'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''BAYU'', ''DESI'', ''Sun'', NULL, ''6137'', ''Add 1 P.choco'', ''1'', ''23000'', ''0'', ''13'', ''EXTRA'', ''6137'', ''Makanan'', ''DINE IN'', ''23000'', ''1265.02'', ''2427'', ''26692.02'', ''23000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''6114'', ''EX-MILK SHORT GLASS'', ''1'', ''8500'', ''0'', ''13'', ''EXTRA'', ''6114'', ''Makanan'', ''DINE IN'', ''8500'', ''467.52'', ''897'', ''9864.52'', ''8500'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''BAYU'', ''BAYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''13'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000088'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''BAYU'', ''BAYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000089'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''14'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000089'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''14'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000089'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''14'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000089'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''14'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000089'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''DESI'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''14'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000090'', ''2023-01-02'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''DESI'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''14'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000090'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''DESI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''10'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1307'', ''FULL BREAKFAST'', ''1'', ''66400'', ''16600'', ''14'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''83000'', ''3652.02'', ''7005'', ''77057.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1302'', ''OMELET'', ''1'', ''54400'', ''13600'', ''14'', ''BREAKFAST'', ''1302'', ''Makanan'', ''DINE IN'', ''68000'', ''2992.02'', ''5739'', ''63131.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1502'', ''CARBONARA'', ''2'', ''140800'', ''35200'', ''14'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''176000'', ''7744.02'', ''14854'', ''163398.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1532'', ''PRAWN & SPINACH PASTA'', ''2'', ''155200'', ''38800'', ''14'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''194000'', ''8536.02'', ''16374'', ''180110.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''76000'', ''19000'', ''14'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''4180.02'', ''8018'', ''88198.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''80000'', ''20000'', ''14'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''4400.02'', ''8440'', ''92840.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1125'', ''COCO BAILEYS (S)'', ''1'', ''54400'', ''13600'', ''14'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''2992.02'', ''5739'', ''63131.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1538'', ''CHICKEN PESTO'', ''1'', ''69600'', ''17400'', ''14'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''3828.02'', ''7343'', ''80771.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''1189'', ''CREME BRULEE (S)'', ''1'', ''40000'', ''10000'', ''14'', ''SWEET PANCAKE'', ''1189'', ''Makanan'', ''DINE IN'', ''50000'', ''2200.02'', ''4220'', ''46420.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''3401'', ''ICE TEA'', ''6'', ''139200'', ''34800'', ''14'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''174000'', ''7656.02'', ''14688'', ''161544.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000091'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''GEDE'', ''Sun'', ''K'', ''3402'', ''HOT TEA'', ''1'', ''23200'', ''5800'', ''14'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1276.02'', ''2448'', ''26924.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000092'', ''2023-01-02'', ''0'', ''5'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''GEDE'', ''NANIK'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''14'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000092'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''GEDE'', ''NANIK'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''6'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''.'', ''3542'', ''CENDOLHOLIC'', ''2'', ''86000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3542'', ''Minuman'', ''DINE IN'', ''86000'', ''4730.02'', ''9074'', ''99804.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''.'', ''3404'', ''PEACH ICE TEA'', ''3'', ''141000'', ''0'', ''14'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''141000'', ''7755.02'', ''14877'', ''163632.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''14'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''14'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''14'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''14'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''14'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''14'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', ''.'', ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', ''.'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', ''.'', ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', ''.'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000093'', ''2023-01-02'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''TARI'', ''Sun'', ''.'', ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''14'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000094'', ''2023-01-02'', ''0'', ''2'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000094'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000094'', ''2023-01-02'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1255'', ''SAUTEED CHICKEN & MUSHROOM (S)'', ''1'', ''70000'', ''0'', ''14'', ''SAVOURY PANCA'', ''1255'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000094'', ''2023-01-02'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000094'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''14'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000094'', ''2023-01-02'', ''0'', ''0'', ''PAKE GLS TAKE AWAY'', ''PAKE GLS TAKE AWAY'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3511'', ''ICE CAPPUCINO'', ''1'', ''49000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3511'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000094'', ''2023-01-02'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000095'', ''2023-01-02'', ''0'', ''0'', ''P. CHOCOLATE'', ''CHOCO ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''TAKE AWAY'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000095'', ''2023-01-02'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''14'', ''NEW MENU'', ''6212'', ''Makanan'', ''TAKE AWAY'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000095'', ''2023-01-02'', ''0'', ''0'', ''DIPISAH'', ''DIPISAH'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''6137'', ''Add 1 P.choco'', ''1'', ''23000'', ''0'', ''14'', ''EXTRA'', ''6137'', ''Makanan'', ''TAKE AWAY'', ''23000'', ''1265.02'', ''2427'', ''26692.02'', ''23000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000095'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''14'', ''PASTA'', ''1503'', ''Makanan'', ''TAKE AWAY'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000095'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000095'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''14'', ''RISOTTO'', ''1904'', ''Makanan'', ''TAKE AWAY'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000096'', ''2023-01-02'', ''0'', ''4'', ''TOMAT PISAH'', ''TOMAT PISAH'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''15'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000096'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000096'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''15'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000096'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3532'', ''ICE WHITE CHOCOLATE'', ''1'', ''45000'', ''0'', ''15'', ''CHOCOLATE'', ''3532'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000096'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3416'', ''HOMEMADE GINGER TEA'', ''1'', ''42000'', ''0'', ''15'', ''TEA'', ''3416'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000096'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''GEDE'', ''Sun'', ''I'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''15'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000096'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''GEDE'', ''Sun'', ''I'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000097'', ''2023-01-02'', ''0'', ''4'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000097'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''A'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000097'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000097'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''15'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000097'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''1908'', ''CHICKEN BALSAMIC RISOTTO'', ''1'', ''95000'', ''0'', ''15'', ''RISOTTO'', ''1908'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000097'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''15'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000097'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''15'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''TERIYAKI SALSA'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''1706'', ''SALMON STEAK'', ''3'', ''660000'', ''0'', ''15'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''660000'', ''36300.02'', ''69630'', ''765930.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''15'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''15'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000098'', ''2023-01-02'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''15'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''5'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1302'', ''OMELET'', ''1'', ''68000'', ''0'', ''15'', ''BREAKFAST'', ''1302'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''15'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', ''AYU'', ''Sun'', NULL, ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''15'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1189'', ''CREME BRULEE (S)'', ''1'', ''50000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1189'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''15'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''TARI'', ''AYU'', ''Sun'', NULL, ''99001'', ''TELOR MATANG'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER TELO'', ''99001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1435'', ''CHICK RANCH SALAD'', ''1'', ''89000'', ''0'', ''15'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''89000'', ''4895.02'', ''9390'', ''103285.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''15'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3542'', ''CENDOLHOLIC'', ''1'', ''43000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3542'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''15'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000099'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000100'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000100'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000100'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000100'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''CHOCO ICE CREAM'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''15'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000100'', ''2023-01-02'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''4'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''1503'', ''BOLOGNAISE'', ''3'', ''258000'', ''0'', ''17'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''258000'', ''14190.02'', ''27219'', ''299409.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''17'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''17'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''J'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''17'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000101'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''J'', ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''17'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000102'', ''2023-01-02'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''GEDE'', NULL, ''Sun'', ''TakeAway'', ''1614'', ''BIG BURGER'', ''2'', ''220000'', ''0'', ''17'', ''BURGER'', ''1614'', ''Makanan'', ''TAKE AWAY'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000102'', ''2023-01-02'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''GEDE'', NULL, ''Sun'', ''TakeAway'', ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000102'', ''2023-01-02'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''GEDE'', NULL, ''Sun'', ''TakeAway'', ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000102'', ''2023-01-02'', ''0'', ''0'', ''TAK AWAY'', ''TAK AWAY'', ''GEDE'', NULL, ''Sun'', ''TakeAway'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''17'', ''GNOCCHI'', ''1952'', ''Makanan'', ''TAKE AWAY'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000103'', ''2023-01-02'', ''0'', ''4'', NULL, NULL, ''GEDE'', NULL, ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''17'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000103'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''GEDE'', NULL, ''Sun'', NULL, ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''17'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000103'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''GEDE'', NULL, ''Sun'', NULL, ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''17'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000104'', ''2023-01-02'', ''0'', ''3'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', ''A'', ''3513'', ''ICE CAFE LATTE'', ''1'', ''49000'', ''0'', ''18'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000104'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', ''A'', ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''18'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000104'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''GEDE'', ''Sun'', ''A'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''18'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000104'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''GEDE'', ''Sun'', ''A'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000104'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', ''A'', ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''18'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000105'', ''2023-01-02'', ''0'', ''4'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''18'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000105'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''18'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000105'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''18'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000105'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000105'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''18'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000106'', ''2023-01-02'', ''0'', ''5'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''18'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000106'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', NULL, ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''18'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000106'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', NULL, ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''18'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000106'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1189'', ''CREME BRULEE (S)'', ''1'', ''50000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1189'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000106'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000106'', ''2023-01-02'', ''0'', ''0'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000106'', ''2023-01-02'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', NULL, ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''18'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''5'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''I'', ''3108'', ''COCA COLA ZERO'', ''2'', ''54000'', ''0'', ''18'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5698'', ''62668.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''I'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''18'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''I'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''18'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''TARI'', ''WISNU'', ''Sun'', ''I'', ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''18'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''WISNU'', ''Sun'', ''I'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''WISNU'', ''Sun'', ''I'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', ''WISNU'', ''Sun'', ''I'', ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''18'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', ''WISNU'', ''Sun'', ''I'', ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', ''I'', ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''18'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000107'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', ''I'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000108'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', ''Coyote'', ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''19'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000108'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', ''Coyote'', ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''19'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000108'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', ''Coyote'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''19'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000108'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', ''Coyote'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''19'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000109'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''19'', ''PASTA'', ''1502'', ''Makanan'', ''TAKE AWAY'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000109'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000110'', ''2023-01-02'', ''0'', ''2'', ''WARM'', ''WARM'', ''NANIK'', NULL, ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000110'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', NULL, ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000110'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', NULL, ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000110'', ''2023-01-02'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', NULL, ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''19'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000110'', ''2023-01-02'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', NULL, ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000111'', ''2023-01-02'', ''0'', ''3'', ''LESS ICE'', ''LESS ICE'', ''TARI'', NULL, ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''2'', ''132000'', ''0'', ''19'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000111'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1537'', ''CURRY KATSU'', ''1'', ''87000'', ''0'', ''19'', ''PASTA'', ''1537'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000111'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000111'', ''2023-01-02'', ''0'', ''0'', ''TIDAK PEDES'', ''TIDAK PEDES'', ''TARI'', NULL, ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''19'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000111'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1537'', ''CURRY KATSU'', ''1'', ''87000'', ''0'', ''19'', ''PASTA'', ''1537'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000111'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''5'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''19'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''19'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''B'', ''3809'', ''BINTANG (S)'', ''2'', ''76000'', ''0'', ''19'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''19'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''CREAMY BLACK PEPPER'', ''CREAMY BLACK PEPPER'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7442'', ''CREAMY BLACK PEPPER'', ''1'', ''0'', ''0'', ''19'', ''SAUCE'', ''7442'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''GARLIC MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''19'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''19'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''MEDIUM WELL'', ''GARLIC MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''19'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''MEDIUM WELL'', ''MEDIUM WELL'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7424'', ''MEDIUM WELL'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER STEA'', ''7424'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''19'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''19'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''19'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''19'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''99001'', ''TELOR MATANG'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER TELO'', ''99001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''19'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''B'', ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''19'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000112'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''7'', ''WARM'', ''WARM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''19'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''19'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''SALAD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''2'', ''252000'', ''0'', ''19'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''252000'', ''13860.02'', ''26586'', ''292446.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''19'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''MEDIUM'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''19'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''19'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''19'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''2'', ''226000'', ''0'', ''19'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''226000'', ''12430.02'', ''23844'', ''262274.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000113'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''19'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''19'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''GARLIC MASHED POTATO'', ''TARI'', NULL, ''Sun'', NULL, ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''19'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''TARI'', NULL, ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', NULL, ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000114'', ''2023-01-02'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''19'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000115'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000116'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''19'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000116'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''19'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000116'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000116'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000116'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000116'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''19'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000117'', ''2023-01-02'', ''0'', ''3'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''J'', ''1507'', ''HOT TUNA'', ''1'', ''82000'', ''0'', ''19'', ''PASTA'', ''1507'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000117'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''J'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000117'', ''2023-01-02'', ''0'', ''0'', ''NO MAYO'', ''NO MAYO'', ''NANIK'', ''NANIK'', ''Sun'', ''J'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''19'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000117'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''J'', ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''4'', ''PENNE'', ''PENNE'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''20'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''I'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''20'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''20'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CORN'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''20'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''20'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''I'', ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''20'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000118'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''H'', ''3810'', ''BINTANG (L)'', ''2'', ''136000'', ''0'', ''20'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''136000'', ''7480.02'', ''14348'', ''157828.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000119'', ''2023-01-02'', ''0'', ''3'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''1101'', ''PANCIOUS ORI (S)'', ''1'', ''50000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1101'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000119'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''NANIK'', ''Sun'', NULL, ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000119'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000119'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000119'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000119'', ''2023-01-02'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''3'', ''87000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''87000'', ''4785.02'', ''9180'', ''100965.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''20'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''20'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''20'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''20'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''MUSHROOM'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''20'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000120'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1435'', ''CHICK RANCH SALAD'', ''1'', ''89000'', ''0'', ''20'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''89000'', ''4895.02'', ''9390'', ''103285.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''20'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''GRILLED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''TERIYAKI SALSA'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''20'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''NANIK'', ''TARI'', ''Sun'', ''B'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''20'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''B'', ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''B'', ''3702'', ''GREEN MOJITO'', ''1'', ''56000'', ''0'', ''20'', ''MOJITO'', ''3702'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''B'', ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''20'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''20'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000121'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''4'', ''ICE'', ''ICE'', ''TARI'', ''TARI'', ''Sun'', NULL, ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''20'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''20'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''20'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''20'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''20'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000122'', ''2023-01-02'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''4'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''21'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''DAHULUKAN'', ''DAHULUKAN'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''21'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''21'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''21'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000123'', ''2023-01-02'', ''0'', ''0'', ''NO EGG'', ''NO EGG'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''21'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000124'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''21'', ''APPETIZER'', ''1422'', ''Makanan'', ''TAKE AWAY'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000124'', ''2023-01-02'', ''0'', ''0'', ''BUNGKUS'', ''BUNGKUS'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''TAKE AWAY'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''7'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''B'', ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''21'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''SALAD'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''TERIYAKI SALSA'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''21'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''21'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''3409'', ''SELECTIONS OF TEA'', ''2'', ''88000'', ''0'', ''21'', ''TEA'', ''3409'', ''Minuman'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7454'', ''GREEN TEA'', ''1'', ''0'', ''0'', ''21'', ''SELECT TEA'', ''7454'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7454'', ''GREEN TEA'', ''1'', ''0'', ''0'', ''21'', ''SELECT TEA'', ''7454'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''B'', ''3402'', ''HOT TEA'', ''2'', ''58000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''B'', ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''21'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''B'', ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''TERIYAKI SALSA'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''21'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000125'', ''2023-01-02'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''NANIK'', ''Sun'', ''B'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''21'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000126'', ''2023-01-02'', ''0'', ''3'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000126'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''2'', ''132000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000127'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000127'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''21'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000127'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''1506'', ''SMOKED BEEF'', ''1'', ''82000'', ''0'', ''21'', ''PASTA'', ''1506'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000127'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000128'', ''2023-01-02'', ''0'', ''2'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''2'', ''100000'', ''0'', ''21'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000128'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''21'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000128'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''21'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000128'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000128'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000128'', ''2023-01-02'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''SOMA PALEMBANG'', ''031123-000128'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''4'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1617'', ''TRUFFLE BEEF BURGER'', ''2'', ''242000'', ''0'', ''21'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''242000'', ''13310.02'', ''25532'', ''280842.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''21'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6124'', ''EX-SLICED CHEESE'', ''1'', ''10500'', ''0'', ''21'', ''EXTRA'', ''6124'', ''Makanan'', ''DINE IN'', ''10500'', ''577.52'', ''1108'', ''12185.52'', ''10500'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6151'', ''EX-BEEF BACON (40 GR)'', ''1'', ''22000'', ''0'', ''21'', ''EXTRA'', ''6151'', ''Makanan'', ''DINE IN'', ''22000'', ''1210.02'', ''2321'', ''25531.02'', ''22000'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''21'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6124'', ''EX-SLICED CHEESE'', ''1'', ''10500'', ''0'', ''21'', ''EXTRA'', ''6124'', ''Makanan'', ''DINE IN'', ''10500'', ''577.52'', ''1108'', ''12185.52'', ''10500'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''TSM MAKASAR'', ''031123-000129'', ''2023-01-02'', ''0'', ''0'', ''MINTA SLICE LIME'', ''MINTA SLICE LIME'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3102'', ''COKE'', ''3'', ''81000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''81000'', ''4455.02'', ''8547'', ''94002.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''4'', ''GREEN TEA'', ''GREEN TEA'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''3409'', ''SELECTIONS OF TEA'', ''3'', ''132000'', ''0'', ''21'', ''TEA'', ''3409'', ''Minuman'', ''DINE IN'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''7454'', ''GREEN TEA'', ''1'', ''0'', ''0'', ''21'', ''SELECT TEA'', ''7454'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''7454'', ''GREEN TEA'', ''1'', ''0'', ''0'', ''21'', ''SELECT TEA'', ''7454'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''7454'', ''GREEN TEA'', ''1'', ''0'', ''0'', ''21'', ''SELECT TEA'', ''7454'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''K'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''21'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''K'', ''1405'', ''CREAMY MUSHROM SOUP'', ''2'', ''132000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''21'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''21'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''02'', ''Monday''),
(''BALI'', ''031123-000130'', ''2023-01-02'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''NANIK'', ''Sun'', ''K'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''02'', ''Monday''),
(''PVJ BANDUNG'', ''031123-000131'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', NULL, ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''13'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000131'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''13'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000131'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''13'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000131'', ''2023-01-03'', ''0'', ''0'', ''CHIPS'', ''SALAD'', ''GEDE'', ''TARI'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''13'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000131'', ''2023-01-03'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''GEDE'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000131'', ''2023-01-03'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''13'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''13'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''1302'', ''OMELET'', ''2'', ''136000'', ''0'', ''13'', ''BREAKFAST'', ''1302'', ''Makanan'', ''DINE IN'', ''136000'', ''7480.02'', ''14348'', ''157828.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''13'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''1101'', ''PANCIOUS ORI (S)'', ''1'', ''50000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1101'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000132'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000133'', ''2023-01-03'', ''0'', ''1'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000133'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000133'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3621'', ''PICCOLO LATTE'', ''1'', ''44000'', ''0'', ''14'', ''COFFEE'', ''3621'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000133'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''14'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000133'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1101'', ''PANCIOUS ORI (S)'', ''1'', ''50000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1101'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000133'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000133'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''8802'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''PANCAKE ORI'', ''8802'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''4'', ''CORN'', ''GARLIC MASHED POTATO'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''14'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''14'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''3518'', ''FANTASY JELLY'', ''1'', ''43000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3518'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''14'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''3519'', ''MANGGO SURPRISE'', ''1'', ''45000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3519'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000134'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''14'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000135'', ''2023-01-03'', ''0'', ''3'', ''CROFFLE'', ''VANILA ICE CREAM'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''8709'', ''RICOTTA & RASPBERRY (C)'', ''1'', ''76000'', ''0'', ''14'', ''CROFFLE'', ''8709'', ''Makanan'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000135'', ''2023-01-03'', ''0'', ''0'', ''CROFFLE'', ''CROFFLE'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''8803'', ''CROFFLE'', ''1'', ''0'', ''0'', ''14'', ''CROFFLE C'', ''8803'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000135'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1189'', ''CREME BRULEE (S)'', ''1'', ''50000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1189'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000135'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000135'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''3511'', ''ICE CAPPUCINO'', ''1'', ''49000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3511'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''14'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''14'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''97026'', ''CHOCO ICE CREAM'', ''1'', ''19000'', ''0'', ''14'', ''EXTRA ICE CRE'', ''97026'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1101'', ''PANCIOUS ORI (S)'', ''1'', ''50000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1101'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''8801'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''PANCAKE ORI'', ''8801'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000136'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''8802'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''PANCAKE ORI'', ''8802'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''3'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''14'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''14'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''MASHED POTATO'', ''TERIYAKI SALSA'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''14'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''14'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''14'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''14'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''14'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''14'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''14'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000137'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000138'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''62102'', ''CUTLERIES'', ''1'', ''500'', ''0'', ''14'', ''EXTRA'', ''62102'', ''Makanan'', ''DINE IN'', ''500'', ''0'', ''0'', ''500'', ''500'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000139'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''14'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000139'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''14'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000139'', ''2023-01-03'', ''0'', ''0'', ''NO ICE'', ''NO ICE'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''14'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000139'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000140'', ''2023-01-03'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''14'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000140'', ''2023-01-03'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''14'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000140'', ''2023-01-03'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000140'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000140'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''14'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''3'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''15'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''15'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''15'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000141'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''15'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''3'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1505'', ''MUSHROM PASTA'', ''1'', ''82000'', ''0'', ''15'', ''PASTA'', ''1505'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', ''SALAD'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''2'', ''252000'', ''0'', ''15'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''252000'', ''13860.02'', ''26586'', ''292446.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', ''LESS ICE'', ''LESS ICE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''15'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000142'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''15'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000143'', ''2023-01-03'', ''0'', ''3'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''15'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000143'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000143'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''15'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3532'', ''ICE WHITE CHOCOLATE'', ''1'', ''45000'', ''0'', ''15'', ''CHOCOLATE'', ''3532'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''15'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''15'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''15'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000144'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''5'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''16'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''ENGLISH BREAKFAST'', ''ENGLISH BREAKFAST'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''3409'', ''SELECTIONS OF TEA'', ''1'', ''44000'', ''0'', ''16'', ''TEA'', ''3409'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''ENGLISH BREAKFAST'', ''ENGLISH BREAKFAST'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''7452'', ''ENGLISH BREAKFAST'', ''1'', ''0'', ''0'', ''16'', ''SELECT TEA'', ''7452'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''16'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''6151'', ''EX-BEEF BACON (40 GR)'', ''1'', ''22000'', ''0'', ''16'', ''EXTRA'', ''6151'', ''Makanan'', ''DINE IN'', ''22000'', ''1210.02'', ''2321'', ''25531.02'', ''22000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''16'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''6136'', ''Add 1 P.original'', ''1'', ''15000'', ''0'', ''16'', ''EXTRA'', ''6136'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''16'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''97026'', ''CHOCO ICE CREAM'', ''1'', ''19000'', ''0'', ''16'', ''EXTRA ICE CRE'', ''97026'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''ICE'', ''ICE'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''16'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000145'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''16'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''3'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''16'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''16'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''16'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6139'', ''Add 1 W.original'', ''1'', ''15000'', ''0'', ''16'', ''EXTRA'', ''6139'', ''Makanan'', ''DINE IN'', ''15000'', ''825.02'', ''1583'', ''17408.02'', ''15000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''- Less Sugar'', ''- Less Sugar'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''16'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''3 GLSS'', ''3 GLSS'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''16'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''I'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''1101'', ''PANCIOUS ORI (S)'', ''2'', ''100000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1101'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''8802'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''PANCAKE ORI'', ''8802'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''8802'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''PANCAKE ORI'', ''8802'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''8802'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''PANCAKE ORI'', ''8802'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000146'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''8802'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''PANCAKE ORI'', ''8802'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''4'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''16'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''16'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''16'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''16'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''16'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''TARI'', NULL, ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''16'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', NULL, ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000147'', ''2023-01-03'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', NULL, ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''3'', ''DINGIN'', ''DINGIN'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''3110'', ''SPARKLING WATER'', ''2'', ''72000'', ''0'', ''16'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''72000'', ''3960.02'', ''7596'', ''83556.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', ''MEDIUM WELL'', ''MASHED POTATO'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''16'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', ''MEDIUM WELL'', ''MEDIUM WELL'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7424'', ''MEDIUM WELL'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER STEA'', ''7424'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''16'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''1506'', ''SMOKED BEEF'', ''1'', ''82000'', ''0'', ''16'', ''PASTA'', ''1506'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''TANIA'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000148'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''16'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000149'', ''2023-01-03'', ''0'', ''1'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''1421'', ''GREEN PEAS SOUP'', ''1'', ''60000'', ''0'', ''16'', ''APPETIZER'', ''1421'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000149'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''A'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''16'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000149'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000149'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000149'', ''2023-01-03'', ''0'', ''0'', ''MASHED POTATO'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''16'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000149'', ''2023-01-03'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000149'', ''2023-01-03'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', ''A'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000150'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''16'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000150'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''16'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000150'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''16'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000150'', ''2023-01-03'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''16'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000150'', ''2023-01-03'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000150'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''16'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000150'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TARI'', ''Sun'', ''Coyote'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''16'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000151'', ''2023-01-03'', ''0'', ''3'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''17'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000151'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''17'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000151'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''17'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000151'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''17'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000151'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''17'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000151'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3602'', ''CAFFE LATTE'', ''1'', ''42000'', ''0'', ''17'', ''COFFEE'', ''3602'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000151'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3526'', ''HONEYCOMB SHAKE'', ''1'', ''55000'', ''0'', ''17'', ''FROSTY SMOOTH'', ''3526'', ''Minuman'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''K'', ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''18'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''K'', ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''18'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''K'', ''3702'', ''GREEN MOJITO'', ''1'', ''56000'', ''0'', ''18'', ''MOJITO'', ''3702'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', ''K'', ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''18'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', ''MEDIUM RARE'', ''CORN'', ''NANIK'', ''TARI'', ''Sun'', ''K'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''18'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', ''MEDIUM RARE'', ''MEDIUM RARE'', ''NANIK'', ''TARI'', ''Sun'', ''K'', ''7422'', ''MEDIUM RARE'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER STEA'', ''7422'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', ''K'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TARI'', ''Sun'', ''K'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''TARI'', ''Sun'', ''K'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''18'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000152'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''18'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000153'', ''2023-01-03'', ''0'', ''2'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000153'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''18'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000153'', ''2023-01-03'', ''0'', ''0'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''18'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000153'', ''2023-01-03'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''18'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''18'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''TNPA AYAM'', ''TNPA AYAM'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1435'', ''CHICK RANCH SALAD'', ''1'', ''89000'', ''0'', ''18'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''89000'', ''4895.02'', ''9390'', ''103285.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''18'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''18'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''18'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''TNPA MILKTEA CUBE'', ''TNPA MILKTEA CUBE'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''18'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''18'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000154'', ''2023-01-03'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''NANIK'', ''NANIK'', ''Sun'', ''B'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000155'', ''2023-01-03'', ''0'', ''2'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''BAYU'', ''Sun'', ''P'', ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''0'', ''95000'', ''18'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''0'', ''0'', ''0'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000155'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''BAYU'', ''Sun'', ''P'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000155'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''BAYU'', ''Sun'', ''P'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''0'', ''67000'', ''18'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''0'', ''0'', ''0'', ''67000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000156'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000156'', ''2023-01-03'', ''0'', ''0'', ''SEDIKIT ICE'', ''SEDIKIT ICE'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3513'', ''ICE CAFE LATTE'', ''1'', ''49000'', ''0'', ''19'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000156'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000156'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000157'', ''2023-01-03'', ''0'', ''2'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''19'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000157'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000157'', ''2023-01-03'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''19'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000157'', ''2023-01-03'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000157'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3809'', ''BINTANG (S)'', ''2'', ''76000'', ''0'', ''19'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000157'', ''2023-01-03'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1829'', ''SALTED CARAMEL (CC)'', ''1'', ''72000'', ''0'', ''19'', ''CREPES'', ''1829'', ''Makanan'', ''DINE IN'', ''72000'', ''3960.02'', ''7596'', ''83556.02'', ''72000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000157'', ''2023-01-03'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''3'', ''W GLS'', ''W GLS'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''19'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3814'', ''BINTANG RADLER LEMON'', ''1'', ''38000'', ''0'', ''19'', ''LOCAL BEER'', ''3814'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''19'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''19'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''19'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', ''PATTY WELDONE'', ''PATTY WELDONE'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''19'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''19'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000158'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3612'', ''HOT WHITE CHOCOLATE'', ''1'', ''43000'', ''0'', ''19'', ''CHOCOLATE'', ''3612'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000159'', ''2023-01-03'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000160'', ''2023-01-03'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''19'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000160'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000160'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''19'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000160'', ''2023-01-03'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3409'', ''SELECTIONS OF TEA'', ''1'', ''44000'', ''0'', ''19'', ''TEA'', ''3409'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000160'', ''2023-01-03'', ''0'', ''0'', ''GREEN TEA'', ''GREEN TEA'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7454'', ''GREEN TEA'', ''1'', ''0'', ''0'', ''19'', ''SELECT TEA'', ''7454'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000160'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000161'', ''2023-01-03'', ''0'', ''3'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''3619'', ''LONG BLACK'', ''1'', ''45000'', ''0'', ''20'', ''COFFEE'', ''3619'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000161'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''3546'', ''ICED CRISP COFFEE'', ''1'', ''47000'', ''0'', ''20'', ''COLD DRINKS\nC'', ''3546'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000161'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''3546'', ''ICED CRISP COFFEE'', ''1'', ''47000'', ''0'', ''20'', ''COLD DRINKS\nC'', ''3546'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000161'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''20'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''5'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''20'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''20'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1908'', ''CHICKEN BALSAMIC RISOTTO'', ''1'', ''95000'', ''0'', ''20'', ''RISOTTO'', ''1908'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1902'', ''MUSHROOM RISOTTO WITH CHICK'', ''1'', ''95000'', ''0'', ''20'', ''RISOTTO'', ''1902'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''20'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''20'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000162'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''20'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''A'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''20'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', ''ICE'', ''ICE'', ''NANIK'', NULL, ''Sun'', ''A'', ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''20'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''A'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''20'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', NULL, ''Sun'', ''A'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', NULL, ''Sun'', ''A'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', NULL, ''Sun'', ''A'', ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', NULL, ''Sun'', ''A'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''A'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''20'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', NULL, ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', NULL, ''Sun'', ''A'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''A'', ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''20'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000163'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''A'', ''1908'', ''CHICKEN BALSAMIC RISOTTO'', ''1'', ''95000'', ''0'', ''20'', ''RISOTTO'', ''1908'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000164'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''TAKE AWAY'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000164'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000164'', ''2023-01-03'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''20'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''TAKE AWAY'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000165'', ''2023-01-03'', ''0'', ''10'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''.'', ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000165'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''.'', ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''20'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000165'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''.'', ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''20'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000165'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''.'', ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''20'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''2'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1307'', ''FULL BREAKFAST'', ''1'', ''83000'', ''0'', ''20'', ''BREAKFAST'', ''1307'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''20'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''CHOCO ICE CREAM'', ''CHOCO ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''97026'', ''CHOCO ICE CREAM'', ''1'', ''19000'', ''0'', ''20'', ''EXTRA ICE CRE'', ''97026'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000166'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3416'', ''HOMEMADE GINGER TEA'', ''1'', ''42000'', ''0'', ''20'', ''TEA'', ''3416'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000167'', ''2023-01-03'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''20'', ''APPETIZER'', ''1428'', ''Makanan'', ''TAKE AWAY'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000167'', ''2023-01-03'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''20'', ''APPETIZER'', ''1405'', ''Makanan'', ''TAKE AWAY'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000168'', ''2023-01-03'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''20'', ''TEA'', ''3404'', ''Minuman'', ''TAKE AWAY'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''20'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''20'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1302'', ''OMELET'', ''1'', ''68000'', ''0'', ''20'', ''BREAKFAST'', ''1302'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', ''ICE CUBE DIPISAH'', ''ICE CUBE DIPISAH'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''20'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000169'', ''2023-01-03'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000170'', ''2023-01-03'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000170'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000170'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000170'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000170'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000171'', ''2023-01-03'', ''0'', ''2'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000171'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000171'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''21'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000171'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000171'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000171'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''2'', ''58000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000172'', ''2023-01-03'', ''0'', ''0'', ''CORN'', ''GRILLED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1704'', ''Makanan'', ''TAKE AWAY'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000172'', ''2023-01-03'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000172'', ''2023-01-03'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000173'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''G'', ''1507'', ''HOT TUNA'', ''1'', ''96510'', ''0'', ''21'', ''PASTA'', ''1507'', ''Makanan'', ''DELIVERY'', ''96510'', ''5308.07'', ''10182'', ''112000.07'', ''96510'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''TSM MAKASAR'', ''031123-000173'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''G'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DELIVERY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000174'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''A'', ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''21'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000174'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''A'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000174'', ''2023-01-03'', ''0'', ''0'', ''CROFFLE'', ''CHOCO ICE CREAM'', ''NANIK'', NULL, ''Sun'', ''A'', ''8704'', ''SALTED CARAMEL (C)'', ''1'', ''72000'', ''0'', ''21'', ''CROFFLE'', ''8704'', ''Makanan'', ''DINE IN'', ''72000'', ''3960.02'', ''7596'', ''83556.02'', ''72000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000174'', ''2023-01-03'', ''0'', ''0'', ''CROFFLE'', ''CROFFLE'', ''NANIK'', NULL, ''Sun'', ''A'', ''8803'', ''CROFFLE'', ''1'', ''0'', ''0'', ''21'', ''CROFFLE C'', ''8803'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000174'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', NULL, ''Sun'', ''A'', ''1537'', ''CURRY KATSU'', ''1'', ''87000'', ''0'', ''21'', ''PASTA'', ''1537'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''BALI'', ''031123-000174'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', NULL, ''Sun'', ''A'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''21'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''21'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''21'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1902'', ''MUSHROOM RISOTTO WITH CHICK'', ''1'', ''95000'', ''0'', ''21'', ''RISOTTO'', ''1902'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''NANIK'', NULL, ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', NULL, ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''PVJ BANDUNG'', ''031123-000175'', ''2023-01-03'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''3543'', ''TEA & DOGER LUSCIOUS'', ''1'', ''43000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3543'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''03'', ''Tuesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''GEDE'', NULL, ''Sun'', NULL, ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''12'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', ''NO TOMAT'', ''NO TOMAT'', ''GEDE'', NULL, ''Sun'', NULL, ''1308'', ''GRILLED SAUSAGE WITH HASH BRO'', ''1'', ''84000'', ''0'', ''12'', ''BREAKFAST'', ''1308'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', NULL, ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''12'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', NULL, ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''12'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''12'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', NULL, ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''12'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', NULL, ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''12'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', NULL, ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''12'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000176'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', NULL, ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''12'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000177'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''GEDE'', ''TANIA'', ''Sun'', NULL, ''3526'', ''HONEYCOMB SHAKE'', ''1'', ''55000'', ''0'', ''13'', ''FROSTY SMOOTH'', ''3526'', ''Minuman'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000177'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TANIA'', ''Sun'', NULL, ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''13'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000177'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''TANIA'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''13'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''5'', NULL, NULL, ''GEDE'', NULL, ''Sun'', ''I'', ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''13'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', NULL, ''Sun'', ''I'', ''3108'', ''COCA COLA ZERO'', ''2'', ''54000'', ''0'', ''13'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5698'', ''62668.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', NULL, ''Sun'', ''I'', ''3331'', ''FRESH APPLE'', ''2'', ''90000'', ''0'', ''13'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''90000'', ''4950.02'', ''9496'', ''104446.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', NULL, ''Sun'', ''I'', ''1258'', ''BEEF & BLUE CHEESE (S)'', ''1'', ''93000'', ''0'', ''13'', ''SAVOURY PANCA'', ''1258'', ''Makanan'', ''DINE IN'', ''93000'', ''5115.02'', ''9812'', ''107927.02'', ''93000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', NULL, ''Sun'', ''I'', ''97001'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER SAVO'', ''97001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', NULL, ''Sun'', ''I'', ''1520'', ''SALMON PESTO'', ''2'', ''226000'', ''0'', ''13'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''226000'', ''12430.02'', ''23844'', ''262274.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', NULL, ''Sun'', ''I'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', NULL, ''Sun'', ''I'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', NULL, ''Sun'', ''I'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''13'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', NULL, ''Sun'', ''I'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', NULL, ''Sun'', ''I'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''13'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', NULL, ''Sun'', ''I'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''13'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000178'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', NULL, ''Sun'', ''I'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''13'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''13'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''13'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''13'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''13'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''AYU'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''13'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''13'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000179'', ''2023-01-04'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''GEDE'', ''AYU'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''13'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000180'', ''2023-01-04'', ''0'', ''2'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''BAYU'', ''AYU'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''13'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000180'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''BAYU'', ''AYU'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000180'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''AYU'', ''Sun'', NULL, ''3546'', ''ICED CRISP COFFEE'', ''1'', ''47000'', ''0'', ''13'', ''COLD DRINKS\nC'', ''3546'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000180'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''AYU'', ''Sun'', NULL, ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''13'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''13'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''13'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''13'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1507'', ''HOT TUNA'', ''1'', ''82000'', ''0'', ''13'', ''PASTA'', ''1507'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''13'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000182'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000183'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''13'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000183'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''13'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000183'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000183'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''13'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000183'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''13'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''13'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''SALAD'', ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''13'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CORN'', ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''13'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000184'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TANIA'', ''Sun'', ''.'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''13'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000185'', ''2023-01-04'', ''0'', ''1'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''GEDE'', ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000185'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''GEDE'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000185'', ''2023-01-04'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''GEDE'', ''GEDE'', ''Sun'', NULL, ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''14'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000185'', ''2023-01-04'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''GEDE'', ''GEDE'', ''Sun'', NULL, ''97025'', ''VANILLA ICE CREAM'', ''1'', ''19000'', ''0'', ''14'', ''EXTRA ICE CRE'', ''97025'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000186'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''14'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000186'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3332'', ''MIXED APPLE + ORANGE'', ''1'', ''50000'', ''0'', ''14'', ''PRESSED JUICE'', ''3332'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000186'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''14'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000186'', ''2023-01-04'', ''0'', ''0'', ''ICE'', ''ICE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''14'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000186'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''14'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''3'', ''CHIPS'', ''MUSTARD & PESTO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''14'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''0'', ''MUSTARD & PESTO'', ''MUSTARD & PESTO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7490'', ''MUSTARD & PESTO'', ''1'', ''0'', ''0'', ''14'', ''COND STEAK -1'', ''7490'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''14'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000187'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000188'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''WISNU'', ''Sun'', ''TakeAway'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''14'', ''STEAK'', ''1712'', ''Makanan'', ''TAKE AWAY'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000188'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''WISNU'', ''Sun'', ''TakeAway'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7431'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000188'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''WISNU'', ''Sun'', ''TakeAway'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7431'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000188'', ''2023-01-04'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''GEDE'', ''WISNU'', ''Sun'', ''TakeAway'', ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''14'', ''BURGER'', ''1614'', ''Makanan'', ''TAKE AWAY'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000188'', ''2023-01-04'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''GEDE'', ''WISNU'', ''Sun'', ''TakeAway'', ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000188'', ''2023-01-04'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''GEDE'', ''WISNU'', ''Sun'', ''TakeAway'', ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''14'', ''BURGER'', ''1617'', ''Makanan'', ''TAKE AWAY'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000188'', ''2023-01-04'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''GEDE'', ''WISNU'', ''Sun'', ''TakeAway'', ''99001'', ''TELOR MATANG'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER TELO'', ''99001'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000189'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''.'', ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''14'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000189'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''14'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000189'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000189'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''1510'', ''CREAMY MARINARA SALMON'', ''1'', ''113000'', ''0'', ''14'', ''PASTA'', ''1510'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000189'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''BAYU'', ''Sun'', ''.'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000189'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''.'', ''2000782'', ''BBQ BEEF BURGER'', ''1'', ''0'', ''0'', ''14'', ''STAMPS PROMO'', ''2000782'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000189'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''.'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''14'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''2'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1260'', ''BBQ CHICKEN (S)'', ''1'', ''70000'', ''0'', ''14'', ''SAVOURY PANCA'', ''1260'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''97001'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER SAVO'', ''97001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''14'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''14'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''14'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000190'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', NULL, ''3513'', ''ICE CAFE LATTE'', ''1'', ''49000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''14'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''14'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''14'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000191'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000192'', ''2023-01-04'', ''0'', ''0'', ''SAUS BBQ PISAH'', ''SAUS BBQ PISAH'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''14'', ''BURGER'', ''1608'', ''Makanan'', ''TAKE AWAY'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000192'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''14'', ''BURGER'', ''1601'', ''Makanan'', ''TAKE AWAY'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000193'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''15'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000193'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000193'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''I'', ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''15'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000193'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''1507'', ''HOT TUNA'', ''1'', ''82000'', ''0'', ''15'', ''PASTA'', ''1507'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000193'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000193'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''15'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000193'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''I'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000194'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''15'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000194'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000194'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''15'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000194'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''15'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000194'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''15'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000194'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''15'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000195'', ''2023-01-04'', ''0'', ''2'', ''TANPA ICE'', ''TANPA ICE'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000195'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''15'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000195'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''15'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000195'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000195'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''15'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000196'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''TANIA'', ''TARI'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''16'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000196'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TARI'', ''Sun'', NULL, ''3702'', ''GREEN MOJITO'', ''1'', ''56000'', ''0'', ''16'', ''MOJITO'', ''3702'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000196'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''TARI'', ''Sun'', NULL, ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''16'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000196'', ''2023-01-04'', ''0'', ''0'', ''NO CHICKEN'', ''NO CHICKEN'', ''TANIA'', ''TARI'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''16'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000196'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TANIA'', ''TARI'', ''Sun'', NULL, ''1505'', ''MUSHROM PASTA'', ''1'', ''82000'', ''0'', ''16'', ''PASTA'', ''1505'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000196'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TANIA'', ''TARI'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000197'', ''2023-01-04'', ''0'', ''2'', ''TANPA SAUCE BALSAMIC'', ''TANPA SAUCE BALSAMIC'', ''TANIA'', ''DESI'', ''Sun'', NULL, ''1908'', ''CHICKEN BALSAMIC RISOTTO'', ''1'', ''95000'', ''0'', ''16'', ''RISOTTO'', ''1908'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000197'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''DESI'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''16'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000197'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TANIA'', ''DESI'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''16'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000197'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TANIA'', ''DESI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000197'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TANIA'', ''DESI'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''16'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000197'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TANIA'', ''DESI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000197'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TANIA'', ''DESI'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000198'', ''2023-01-04'', ''0'', ''2'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''16'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000198'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''16'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000198'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''16'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000198'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000198'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000198'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000199'', ''2023-01-04'', ''0'', ''1'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3513'', ''ICE CAFE LATTE'', ''1'', ''49000'', ''0'', ''17'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000199'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1189'', ''CREME BRULEE (S)'', ''1'', ''50000'', ''0'', ''17'', ''SWEET PANCAKE'', ''1189'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000199'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''17'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''5'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1258'', ''BEEF & BLUE CHEESE (S)'', ''1'', ''93000'', ''0'', ''17'', ''SAVOURY PANCA'', ''1258'', ''Makanan'', ''DINE IN'', ''93000'', ''5115.02'', ''9812'', ''107927.02'', ''93000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''17'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''TARI'', ''AYU'', ''Sun'', NULL, ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''GRILLED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''17'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''CORN'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''17'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''17'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''17'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3814'', ''BINTANG RADLER LEMON'', ''1'', ''38000'', ''0'', ''17'', ''LOCAL BEER'', ''3814'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''17'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''W 3 GLS'', ''W 3 GLS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''17'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3226'', ''ICE COFFE SHAKER'', ''1'', ''43000'', ''0'', ''17'', ''COLD DRINKS\nC'', ''3226'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000200'', ''2023-01-04'', ''0'', ''0'', ''MINTA POTONGAN LIME'', ''MINTA POTONGAN LIME'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''17'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000201'', ''2023-01-04'', ''0'', ''2'', ''W GLS'', ''W GLS'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''17'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000201'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''17'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000201'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000201'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''17'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000201'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''17'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000202'', ''2023-01-04'', ''0'', ''3'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''17'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000202'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''17'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000202'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''17'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000202'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''17'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000203'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''18'', ''PASTA'', ''1502'', ''Makanan'', ''TAKE AWAY'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000203'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''AYU'', ''Sun'', ''TakeAway'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000204'', ''2023-01-04'', ''0'', ''3'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''19'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000204'', ''2023-01-04'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000204'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''19'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000204'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''19'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000204'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3702'', ''GREEN MOJITO'', ''1'', ''56000'', ''0'', ''19'', ''MOJITO'', ''3702'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000204'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''19'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''4'', ''CORN'', ''GRILLED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''19'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''19'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''19'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''19'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''2'', ''54000'', ''0'', ''19'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5698'', ''62668.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000205'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''2'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''19'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''19'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''19'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''19'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000206'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''19'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''0'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', NULL, ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''19'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''19'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000207'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''19'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000208'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000209'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''19'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000209'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''19'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''3'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''19'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''19'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''TERIYAKI SALSA'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''19'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''BAYU'', NULL, ''Sun'', ''Coyote'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''19'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', NULL, ''Sun'', ''Coyote'', ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''19'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000210'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', NULL, ''Sun'', ''Coyote'', ''3703'', ''MANDARIN MOJITO'', ''2'', ''112000'', ''0'', ''19'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''112000'', ''6160.02'', ''11816'', ''129976.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000211'', ''2023-01-04'', ''0'', ''3'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''H'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000211'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''H'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000211'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''DESI'', ''Sun'', ''H'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''19'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000211'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''DESI'', ''Sun'', ''H'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''2'', ''MEDIUM'', ''SALAD'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''20'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''20'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''BAYU'', ''Sun'', ''B'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000212'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''BAYU'', ''Sun'', ''B'', ''3102'', ''COKE'', ''2'', ''54000'', ''0'', ''20'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5698'', ''62668.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000213'', ''2023-01-04'', ''0'', ''1'', NULL, NULL, ''TARI'', NULL, ''Sun'', ''K'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000213'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', ''K'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''20'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''3'', ''DIDAHULUKAN'', ''DIDAHULUKAN'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''20'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''20'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''20'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''20'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''GEDE'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''20'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000214'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''GEDE'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000215'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1524'', ''Makanan'', ''TAKE AWAY'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000215'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000215'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''20'', ''TEA'', ''3405'', ''Minuman'', ''TAKE AWAY'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000215'', ''2023-01-04'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''TARI'', ''WISNU'', ''Sun'', ''TakeAway'', ''3332'', ''MIXED APPLE + ORANGE'', ''1'', ''50000'', ''0'', ''20'', ''PRESSED JUICE'', ''3332'', ''Minuman'', ''TAKE AWAY'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''20'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000216'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''Coyote'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000217'', ''2023-01-04'', ''0'', ''1'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''I'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000217'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''20'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000217'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000217'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', ''I'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000217'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', ''I'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''2'', ''58000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1536'', ''PASTA LIDAH CABE HIJAU'', ''1'', ''95000'', ''0'', ''20'', ''PASTA'', ''1536'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''20'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''20'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000218'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''20'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000219'', ''2023-01-04'', ''0'', ''1'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', ''P'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''3'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''21'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''21'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''1540'', ''OCEAN KING'', ''2'', ''226000'', ''0'', ''21'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''226000'', ''12430.02'', ''23844'', ''262274.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''21'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''DESI'', ''Sun'', ''A'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000220'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''A'', ''3216'', ''GINGERONI'', ''2'', ''82000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''82000'', ''4510.02'', ''8652'', ''95162.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000221'', ''2023-01-04'', ''0'', ''2'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''P'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''21'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000221'', ''2023-01-04'', ''0'', ''0'', ''OUT TABLE A'', ''OUT TABLE A'', ''TARI'', ''DESI'', ''Sun'', ''P'', ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''21'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000221'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''P'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000221'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''P'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000221'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''P'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000221'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''P'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000221'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''P'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''21'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''5'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''4'', ''116000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''116000'', ''6380.02'', ''12240'', ''134620.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''21'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1704'', ''CHICKEN STEAK'', ''2'', ''252000'', ''0'', ''21'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''252000'', ''13860.02'', ''26586'', ''292446.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''21'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''TARI'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''21'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000222'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''16'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''21'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''4'', ''224000'', ''0'', ''21'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''224000'', ''12320.02'', ''23632'', ''259952.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3404'', ''PEACH ICE TEA'', ''2'', ''94000'', ''0'', ''21'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''94000'', ''5170.02'', ''9918'', ''109088.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''21'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3601'', ''CAPPUCINO'', ''2'', ''84000'', ''0'', ''21'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''21'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''21'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''21'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''21'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''WELLDONE'', ''GRILLED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CREAMY BLACK PEPPER'', ''CREAMY BLACK PEPPER'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7442'', ''CREAMY BLACK PEPPER'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7442'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''SALAD'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''21'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''MASHED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''WELLDONE'', ''SALAD'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''2'', ''546000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''546000'', ''30030.02'', ''57604'', ''633634.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CREAMY BLACK PEPPER'', ''CREAMY BLACK PEPPER'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7442'', ''CREAMY BLACK PEPPER'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7442'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''SALAD'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''FETTUCINI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1524'', ''TRUFFLE CREAM PASTA'', ''2'', ''194000'', ''0'', ''21'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''194000'', ''10670.02'', ''20468'', ''225138.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''21'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''.'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''21'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''6132'', ''EX-ICE CREAM'', ''1'', ''0'', ''0'', ''21'', ''EXTRA'', ''6132'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''VANILLA ICE CREAM'', ''VANILLA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''97025'', ''VANILLA ICE CREAM'', ''1'', ''19000'', ''0'', ''21'', ''EXTRA ICE CRE'', ''97025'', ''Minuman'', ''DINE IN'', ''19000'', ''1045.02'', ''2005'', ''22050.02'', ''19000'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CROFFLE'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''8709'', ''RICOTTA & RASPBERRY (C)'', ''1'', ''76000'', ''0'', ''21'', ''CROFFLE'', ''8709'', ''Makanan'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000223'', ''2023-01-04'', ''0'', ''0'', ''CROFFLE'', ''CROFFLE'', ''GEDE'', ''DESI'', ''Sun'', ''.'', ''8803'', ''CROFFLE'', ''1'', ''0'', ''0'', ''21'', ''CROFFLE C'', ''8803'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''5'', NULL, NULL, ''TARI'', NULL, ''Sun'', ''K'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', ''K'', ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''21'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', ''K'', ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', ''K'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', ''K'', ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', NULL, ''Sun'', ''K'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', ''K'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000224'', ''2023-01-04'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', NULL, ''Sun'', ''K'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000225'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000225'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000225'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''21'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000225'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000225'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000225'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''21'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''4'', ''72000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''72000'', ''3960.02'', ''7596'', ''83556.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''2'', ''194000'', ''0'', ''21'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''194000'', ''10670.02'', ''20468'', ''225138.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''21'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''SALAD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''21'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000226'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''4'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''3'', ''54000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5697'', ''62667.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''4'', ''388000'', ''0'', ''21'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''388000'', ''21340.02'', ''40936'', ''450276.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''21'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000227'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''5'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''3'', ''54000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5697'', ''62667.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3416'', ''HOMEMADE GINGER TEA'', ''1'', ''42000'', ''0'', ''21'', ''TEA'', ''3416'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''21'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1313'', ''TRUFFLE MUSHROOM OMELETTE'', ''1'', ''83000'', ''0'', ''21'', ''BREAKFAST'', ''1313'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''TERIYAKI SALSA'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''21'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''21'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000228'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''4'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''21'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''21'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''21'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000229'', ''2023-01-04'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''12'', NULL, NULL, ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''2'', ''156000'', ''0'', ''21'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''156000'', ''8580.02'', ''16458'', ''181038.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''21'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''2'', ''194000'', ''0'', ''21'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''194000'', ''10670.02'', ''20468'', ''225138.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1537'', ''CURRY KATSU'', ''1'', ''87000'', ''0'', ''21'', ''PASTA'', ''1537'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''2'', ''176000'', ''0'', ''21'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''176000'', ''9680.02'', ''18568'', ''204248.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''21'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''21'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''GEDE'', ''Sun'', NULL, ''3226'', ''ICE COFFE SHAKER'', ''1'', ''43000'', ''0'', ''21'', ''COLD DRINKS\nC'', ''3226'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''GEDE'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''BAYU'', ''GEDE'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''6'', ''174000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''174000'', ''9570.02'', ''18360'', ''201930.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''CHIPS'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''CHIPS'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''21'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''TSM MAKASAR'', ''031123-000230'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''BAYU'', ''GEDE'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''6'', ''MEDIUM'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''3'', ''819000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''819000'', ''45045.02'', ''86406'', ''950451.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7442'', ''CREAMY BLACK PEPPER'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7442'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''21'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''21'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1510'', ''CREAMY MARINARA SALMON'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1510'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''2'', ''76000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3814'', ''BINTANG RADLER LEMON'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3814'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''BALI'', ''031123-000231'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''21'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''3'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''B'', ''3226'', ''ICE COFFE SHAKER'', ''1'', ''43000'', ''0'', ''22'', ''COLD DRINKS\nC'', ''3226'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''B'', ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''22'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', ''B'', ''1255'', ''SAUTEED CHICKEN & MUSHROOM (S)'', ''1'', ''70000'', ''0'', ''22'', ''SAVOURY PANCA'', ''1255'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''DESI'', ''Sun'', ''B'', ''97001'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''22'', ''MODIFIER SAVO'', ''97001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''GARLIC MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''B'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''22'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''B'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''22'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''B'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''22'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''DESI'', ''Sun'', ''B'', ''1818'', ''COCO BAILEYS (CC)'', ''1'', ''81000'', ''0'', ''22'', ''CREPES'', ''1818'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''PVJ BANDUNG'', ''031123-000232'', ''2023-01-04'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''DESI'', ''Sun'', ''B'', ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''22'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''04'', ''Wednesday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''1'', ''ICE'', ''ICE'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''13'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''MINTA GELAS ISI ES'', ''MINTA GELAS ISI ES'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''13'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''13'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''13'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''13'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''2'', ''220000'', ''0'', ''13'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''99001'', ''TELOR MATANG'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER TELO'', ''99001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', ''TELOR MATANG'', ''TELOR MATANG'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''99001'', ''TELOR MATANG'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER TELO'', ''99001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000233'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''13'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''7'', ''3 GLAS'', ''3 GLAS'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''14'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''14'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''14'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''14'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000234'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''14'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3615'', ''CAFFE MOCHA'', ''1'', ''42000'', ''0'', ''14'', ''COFFEE'', ''3615'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''14'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''TERIYAKI SALSA'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''14'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''14'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''14'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1510'', ''CREAMY MARINARA SALMON'', ''1'', ''113000'', ''0'', ''14'', ''PASTA'', ''1510'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''JOIN'', ''JOIN'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6102'', ''EX-SPINACH'', ''1'', ''9500'', ''0'', ''14'', ''EXTRA'', ''6102'', ''Makanan'', ''DINE IN'', ''9500'', ''522.52'', ''1002'', ''11024.52'', ''9500'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000235'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000236'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''14'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000236'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''14'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000236'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''14'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000236'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000236'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''14'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000237'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''BAYU'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''15'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000237'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''PENNE'', ''BAYU'', ''WISNU'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''2'', ''190000'', ''0'', ''15'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''190000'', ''10450.02'', ''20046'', ''220496.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000237'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''BAYU'', ''WISNU'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000237'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''BAYU'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''6'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''15'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3611'', ''HOT DARK CHOCOLATE'', ''1'', ''43000'', ''0'', ''15'', ''CHOCOLATE'', ''3611'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''15'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''15'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''15'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''15'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1435'', ''CHICK RANCH SALAD'', ''4'', ''356000'', ''0'', ''15'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''356000'', ''19580.02'', ''37560'', ''413140.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1308'', ''GRILLED SAUSAGE WITH HASH BRO'', ''1'', ''84000'', ''0'', ''15'', ''BREAKFAST'', ''1308'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''15'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000238'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''6'', ''SALAD'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''15'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''15'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''15'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''NO CHIKEN'', ''NO CHIKEN'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''15'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1103'', ''COCO PANCIOUS (S)'', ''1'', ''55000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1103'', ''Makanan'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''P. CHOCOLATE'', ''CHOCO ICE CREAM'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''1103'', ''COCO PANCIOUS (S)'', ''1'', ''55000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1103'', ''Makanan'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''15'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''EXTRA STRAUBERRY'', ''EXTRA STRAUBERRY'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''6137'', ''Add 1 P.choco'', ''1'', ''23000'', ''0'', ''15'', ''EXTRA'', ''6137'', ''Makanan'', ''DINE IN'', ''23000'', ''1265.02'', ''2427'', ''26692.02'', ''23000'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''15'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''3 GLS'', ''3 GLS'', ''NANIK'', ''TANIA'', ''Sun'', ''Coyote'', ''3810'', ''BINTANG (L)'', ''2'', ''136000'', ''0'', ''15'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''136000'', ''7480.02'', ''14348'', ''157828.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''15'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''15'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''15'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000239'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000240'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''15'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000240'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''15'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000240'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''15'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000240'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''15'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000240'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''5'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''15'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''CHOCO ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''15'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''15'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000241'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''15'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''15'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''15'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''15'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', ''K'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', ''K'', ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000242'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', ''K'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000243'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3513'', ''ICE CAFE LATTE'', ''1'', ''49000'', ''0'', ''16'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000243'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''16'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000243'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''16'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000243'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''16'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000243'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''GARLIC MASHED POTATO'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''16'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000243'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000243'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''16'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''17'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3621'', ''PICCOLO LATTE'', ''1'', ''44000'', ''0'', ''17'', ''COFFEE'', ''3621'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''17'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''17'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''17'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000244'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1435'', ''CHICK RANCH SALAD'', ''1'', ''89000'', ''0'', ''17'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''89000'', ''4895.02'', ''9390'', ''103285.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000245'', ''2023-01-05'', ''0'', ''1'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1536'', ''PASTA LIDAH CABE HIJAU'', ''1'', ''95000'', ''0'', ''17'', ''PASTA'', ''1536'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000245'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000245'', ''2023-01-05'', ''0'', ''0'', ''KELUARKAN 1 GLS SAJA'', ''KELUARKAN 1 GLS SAJA'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''17'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''17'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', ''DAHULUKAN OUT'', ''DAHULUKAN OUT'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1435'', ''CHICK RANCH SALAD'', ''1'', ''89000'', ''0'', ''17'', ''APPETIZER'', ''1435'', ''Makanan'', ''DINE IN'', ''89000'', ''4895.02'', ''9390'', ''103285.02'', ''89000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''17'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''17'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''17'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''17'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''17'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000246'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000247'', ''2023-01-05'', ''0'', ''1'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''P'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''17'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000247'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', NULL, ''Sun'', ''P'', ''1255'', ''SAUTEED CHICKEN & MUSHROOM (S)'', ''1'', ''70000'', ''0'', ''17'', ''SAVOURY PANCA'', ''1255'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000247'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', NULL, ''Sun'', ''P'', ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''I'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''18'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''I'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''18'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''I'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''18'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''GARLIC MASHED POTATO'', ''NANIK'', NULL, ''Sun'', ''I'', ''1728'', ''CHICK O CHILLI'', ''1'', ''118000'', ''0'', ''18'', ''STEAK'', ''1728'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', NULL, ''Sun'', ''I'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', NULL, ''Sun'', ''I'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''I'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''18'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000248'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''I'', ''3546'', ''ICED CRISP COFFEE'', ''1'', ''47000'', ''0'', ''18'', ''COLD DRINKS\nC'', ''3546'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''18'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''18'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''18'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CORN'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''18'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''DESI'', ''Sun'', ''A'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000249'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''A'', ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''18'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000250'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3416'', ''HOMEMADE GINGER TEA'', ''1'', ''42000'', ''0'', ''18'', ''TEA'', ''3416'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000250'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''18'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000250'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1421'', ''GREEN PEAS SOUP'', ''1'', ''60000'', ''0'', ''18'', ''APPETIZER'', ''1421'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000250'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''18'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000250'', ''2023-01-05'', ''0'', ''0'', ''OVER COOK'', ''OVER COOK'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''18'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000250'', ''2023-01-05'', ''0'', ''0'', ''NO SAUS PESTO'', ''NO SAUS PESTO'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''18'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000251'', ''2023-01-05'', ''0'', ''1'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''J'', ''1537'', ''CURRY KATSU'', ''1'', ''0'', ''87000'', ''18'', ''PASTA'', ''1537'', ''Makanan'', ''DINE IN'', ''87000'', ''0'', ''0'', ''0'', ''87000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000251'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''J'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''6'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''19'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''19'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3542'', ''CENDOLHOLIC'', ''1'', ''43000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3542'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3702'', ''GREEN MOJITO'', ''1'', ''56000'', ''0'', ''19'', ''MOJITO'', ''3702'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''19'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''19'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''GARLIC MASHED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''19'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''WELLDONE'', ''CORN'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''19'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''19'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1189'', ''CREME BRULEE (S)'', ''1'', ''50000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1189'', ''Makanan'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000252'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000253'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000253'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''19'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000253'', ''2023-01-05'', ''0'', ''0'', ''BEBERAPA NACOS DI PI'', ''BEBERAPA NACOS DI PI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''19'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000253'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''19'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000253'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1503'', ''BOLOGNAISE'', ''1'', ''86000'', ''0'', ''19'', ''PASTA'', ''1503'', ''Makanan'', ''DINE IN'', ''86000'', ''4730.02'', ''9073'', ''99803.02'', ''86000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000253'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''2'', ''COLD'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''TARI'', ''WISNU'', ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''19'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''MUSTARD & PESTO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''19'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000254'', ''2023-01-05'', ''0'', ''0'', ''MUSTARD & PESTO'', ''MUSTARD & PESTO'', ''TARI'', ''WISNU'', ''Sun'', NULL, ''7490'', ''MUSTARD & PESTO'', ''1'', ''0'', ''0'', ''19'', ''COND STEAK -1'', ''7490'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''19'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', ''SCREMBLE NO MILK'', ''SCREMBLE NO MILK'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1308'', ''GRILLED SAUSAGE WITH HASH BRO'', ''1'', ''84000'', ''0'', ''19'', ''BREAKFAST'', ''1308'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''19'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''19'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', ''TELOR 1/2 MATANG'', ''TELOR 1/2 MATANG'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''99002'', ''TELOR 1/2 MATANG'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER TELO'', ''99002'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''19'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3108'', ''COCA COLA ZERO'', ''4'', ''108000'', ''0'', ''19'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''108000'', ''5940.02'', ''11396'', ''125336.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000255'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''19'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''5'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''I'', ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''SEDIKIT GULA'', ''SEDIKIT GULA'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''19'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''I'', ''3332'', ''MIXED APPLE + ORANGE'', ''1'', ''50000'', ''0'', ''19'', ''PRESSED JUICE'', ''3332'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''19'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''I'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''19'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''19'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''1141'', ''BERRY CHEESE (S)'', ''1'', ''68000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1141'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000256'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''19'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''19'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''MASHED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''19'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''19'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''19'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000257'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''19'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000258'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''19'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000258'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''19'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000258'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000258'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000259'', ''2023-01-05'', ''0'', ''6'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''4'', ''116000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''116000'', ''6380.02'', ''12240'', ''134620.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000259'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''20'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000259'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TARI'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''20'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000259'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000259'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000259'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''TARI'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000259'', ''2023-01-05'', ''0'', ''0'', ''DI BUNGKUS'', ''DI BUNGKUS'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''20'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000260'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''2'', ''58000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6120'', ''67310.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000260'', ''2023-01-05'', ''0'', ''0'', ''SEDIKIT ES'', ''SEDIKIT ES'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''20'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000260'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''1258'', ''BEEF & BLUE CHEESE (S)'', ''1'', ''93000'', ''0'', ''20'', ''SAVOURY PANCA'', ''1258'', ''Makanan'', ''DINE IN'', ''93000'', ''5115.02'', ''9812'', ''107927.02'', ''93000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000260'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000260'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''20'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000260'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''20'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000260'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''6'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3810'', ''BINTANG (L)'', ''3'', ''204000'', ''0'', ''20'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''204000'', ''11220.02'', ''21522'', ''236742.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''TERIYAKI SALSA'', ''NANIK'', ''GEDE'', ''Sun'', ''Coyote'', ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''20'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''GEDE'', ''Sun'', ''Coyote'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''GEDE'', ''Sun'', ''Coyote'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''NANIK'', ''GEDE'', ''Sun'', ''Coyote'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''20'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''GEDE'', ''Sun'', ''Coyote'', ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''20'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''20'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3702'', ''GREEN MOJITO'', ''1'', ''56000'', ''0'', ''20'', ''MOJITO'', ''3702'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''20'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''TERIYAKI SALSA'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1706'', ''SALMON STEAK'', ''2'', ''440000'', ''0'', ''20'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''440000'', ''24200.02'', ''46420'', ''510620.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''20'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''20'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''GRILLED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1712'', ''FISH AND CHIPS'', ''2'', ''252000'', ''0'', ''20'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''252000'', ''13860.02'', ''26586'', ''292446.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000261'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''20'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''4'', ''DIDAHULUKAN'', ''DIDAHULUKAN'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''20'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''CHIPS'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''20'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''GRILLED POTATO'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''20'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''GEDE'', ''WISNU'', ''Sun'', NULL, ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''20'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''WISNU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''WISNU'', ''Sun'', NULL, ''3526'', ''HONEYCOMB SHAKE'', ''1'', ''55000'', ''0'', ''20'', ''FROSTY SMOOTH'', ''3526'', ''Minuman'', ''DINE IN'', ''55000'', ''3025.02'', ''5803'', ''63828.02'', ''55000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''NANIK'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000262'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''NANIK'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000263'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''20'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''TAKE AWAY'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''21'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1510'', ''CREAMY MARINARA SALMON'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1510'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''21'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1608'', ''BBQ BEEF BURGER'', ''1'', ''100000'', ''0'', ''21'', ''BURGER'', ''1608'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''SALAD'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1722'', ''GRILL TRUFFLE CHICKEN'', ''1'', ''116000'', ''0'', ''21'', ''STEAK'', ''1722'', ''Makanan'', ''DINE IN'', ''116000'', ''6380.02'', ''12238'', ''134618.02'', ''116000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000264'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''3519'', ''MANGGO SURPRISE'', ''1'', ''45000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3519'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''3518'', ''FANTASY JELLY'', ''1'', ''43000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3518'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''B'', ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''21'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''GRILLED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''1704'', ''CHICKEN STEAK'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1704'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''GRILLED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''21'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', NULL, ''Sun'', ''B'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', NULL, ''Sun'', ''B'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000265'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', NULL, ''Sun'', ''B'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000266'', ''2023-01-05'', ''0'', ''3'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000266'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''21'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000266'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''3531'', ''ICE DARK CHOCOLATE'', ''1'', ''45000'', ''0'', ''21'', ''CHOCOLATE'', ''3531'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000266'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''TANIA'', ''Sun'', NULL, ''1422'', ''TRUFFLE CHIPS'', ''1'', ''65000'', ''0'', ''21'', ''APPETIZER'', ''1422'', ''Makanan'', ''DINE IN'', ''65000'', ''3575.02'', ''6858'', ''75433.02'', ''65000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000266'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000266'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''TANIA'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''21'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''21'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', ''DI LELEHKAN'', ''DI LELEHKAN'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''6115'', ''EX-MOZZARELLA CHS'', ''1'', ''8500'', ''0'', ''21'', ''EXTRA'', ''6115'', ''Makanan'', ''DINE IN'', ''8500'', ''467.52'', ''897'', ''9864.52'', ''8500'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''21'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1102'', ''PANCIOUS SPC (S)'', ''1'', ''53000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1102'', ''Makanan'', ''DINE IN'', ''53000'', ''2915.02'', ''5592'', ''61507.02'', ''53000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''21'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3614'', ''AMERICANO'', ''1'', ''40000'', ''0'', ''21'', ''COFFEE'', ''3614'', ''Minuman'', ''DINE IN'', ''40000'', ''2200.02'', ''4220'', ''46420.02'', ''40000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000267'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''1524'', ''TRUFFLE CREAM PASTA'', ''7'', ''679000'', ''0'', ''21'', ''PASTA'', ''1524'', ''Makanan'', ''TAKE AWAY'', ''679000'', ''37345.02'', ''71638'', ''787983.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''1260'', ''BBQ CHICKEN (S)'', ''1'', ''70000'', ''0'', ''21'', ''SAVOURY PANCA'', ''1260'', ''Makanan'', ''TAKE AWAY'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000268'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', ''TakeAway'', ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''6'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''2'', ''132000'', ''0'', ''21'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''132000'', ''7260.02'', ''13926'', ''153186.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1908'', ''CHICKEN BALSAMIC RISOTTO'', ''2'', ''190000'', ''0'', ''21'', ''RISOTTO'', ''1908'', ''Makanan'', ''DINE IN'', ''190000'', ''10450.02'', ''20046'', ''220496.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''21'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''21'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3619'', ''LONG BLACK'', ''1'', ''45000'', ''0'', ''21'', ''COFFEE'', ''3619'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''ICE'', ''ICE'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''21'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''21'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''21'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''ENGLISH BREAKFAST'', ''ENGLISH BREAKFAST'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3409'', ''SELECTIONS OF TEA'', ''1'', ''44000'', ''0'', ''21'', ''TEA'', ''3409'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''ENGLISH BREAKFAST'', ''ENGLISH BREAKFAST'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7452'', ''ENGLISH BREAKFAST'', ''1'', ''0'', ''0'', ''21'', ''SELECT TEA'', ''7452'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''NANIK'', ''DESI'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000269'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1402'', ''FRIED CHIPS (R)'', ''1'', ''58000'', ''0'', ''21'', ''APPETIZER'', ''1402'', ''Makanan'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''6'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''3108'', ''COCA COLA ZERO'', ''2'', ''54000'', ''0'', ''21'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5698'', ''62668.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''21'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''1436'', ''UNDER THE SEA PLATTER'', ''2'', ''226000'', ''0'', ''21'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''226000'', ''12430.02'', ''23844'', ''262274.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''21'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''SALAD'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''WELLDONE'', ''GARLIC MASHED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''NO CHEESE'', ''NO CHEESE'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''21'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''21'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''21'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1722'', ''GRILL TRUFFLE CHICKEN'', ''1'', ''116000'', ''0'', ''21'', ''STEAK'', ''1722'', ''Makanan'', ''DINE IN'', ''116000'', ''6380.02'', ''12238'', ''134618.02'', ''116000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''WELLDONE'', ''GRILLED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CREAMY BLACK PEPPER'', ''CREAMY BLACK PEPPER'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7442'', ''CREAMY BLACK PEPPER'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7442'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''MASHED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''21'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''CORN'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''21'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3404'', ''PEACH ICE TEA'', ''3'', ''141000'', ''0'', ''21'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''141000'', ''7755.02'', ''14877'', ''163632.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', NULL, ''Sun'', ''Fadjar'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', NULL, ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', NULL, ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''Fadjar'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''NO TOMAT'', ''NO TOMAT'', ''NANIK'', NULL, ''Sun'', ''Fadjar'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''21'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''21'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''21'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''3105'', ''MINERAL WATER'', ''3'', ''54000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''54000'', ''2970.02'', ''5697'', ''62667.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''21'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''21'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000270'', ''2023-01-05'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''NANIK'', ''Sun'', ''Fadjar'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000271'', ''2023-01-05'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''21'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000271'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''21'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000271'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''21'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000271'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000271'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000271'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000271'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000272'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000272'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1511'', ''SEAFOOD MARINARA'', ''1'', ''109000'', ''0'', ''21'', ''PASTA'', ''1511'', ''Makanan'', ''DINE IN'', ''109000'', ''5995.02'', ''11500'', ''126495.02'', ''109000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000272'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000272'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000272'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''21'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000272'', ''2023-01-05'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''21'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000273'', ''2023-01-05'', ''0'', ''4'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''21'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000273'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000273'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''21'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000273'', ''2023-01-05'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''NANIK'', ''NANIK'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000273'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''21'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000273'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000273'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''21'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000274'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''21'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000274'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''21'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000274'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''21'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000274'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''21'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''21'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''21'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''21'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''SALAD'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''21'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''21'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''TERIYAKI SALSA'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''1706'', ''SALMON STEAK'', ''1'', ''220000'', ''0'', ''21'', ''STEAK'', ''1706'', ''Makanan'', ''DINE IN'', ''220000'', ''12100.02'', ''23210'', ''255310.02'', ''220000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''21'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''TERIYAKI SALSA'', ''TERIYAKI SALSA'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''7489'', ''TERIYAKI SALSA'', ''1'', ''0'', ''0'', ''21'', ''COND STEAK -1'', ''7489'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''21'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''BALI'', ''031123-000275'', ''2023-01-05'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', ''WISNU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''21'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000276'', ''2023-01-05'', ''0'', ''2'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''K'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''22'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000276'', ''2023-01-05'', ''0'', ''0'', ''NO TOMETO'', ''NO TOMETO'', ''NANIK'', NULL, ''Sun'', ''K'', ''1601'', ''CHEESE BURGER'', ''2'', ''190000'', ''0'', ''22'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''190000'', ''10450.02'', ''20046'', ''220496.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''PVJ BANDUNG'', ''031123-000276'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''K'', ''3701'', ''VIRGIN MOJITO > CLASSIC MOJIT'', ''1'', ''56000'', ''0'', ''22'', ''MOJITO'', ''3701'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000277'', ''2023-01-05'', ''0'', ''3'', ''COLD'', ''COLD'', ''NANIK'', NULL, ''Sun'', ''Coyote'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''22'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000277'', ''2023-01-05'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', NULL, ''Sun'', ''Coyote'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''22'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000277'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''Coyote'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''22'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000277'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''Coyote'', ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''22'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000277'', ''2023-01-05'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''NANIK'', NULL, ''Sun'', ''Coyote'', ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''22'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000277'', ''2023-01-05'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''NANIK'', NULL, ''Sun'', ''Coyote'', ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''22'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''05'', ''Thursday''),
(''SOMA PALEMBANG'', ''031123-000277'', ''2023-01-05'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', ''Coyote'', ''1951'', ''GNOCCHI CHICKEN PESTO'', ''1'', ''80000'', ''0'', ''22'', ''GNOCCHI'', ''1951'', ''Makanan'', ''DINE IN'', ''80000'', ''4400.02'', ''8440'', ''92840.02'', ''80000'', ''FOOD'', ''January'', ''2023'', ''05'', ''Thursday''),
(''TSM MAKASAR'', ''031123-000278'', ''2023-01-06'', ''0'', ''0'', ''TAKE AWAY'', ''TAKE AWAY'', ''NANIK'', NULL, ''Sun'', ''TakeAway'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''12'', ''APPETIZER'', ''1428'', ''Makanan'', ''TAKE AWAY'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''3'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''13'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''3404'', ''PEACH ICE TEA'', ''1'', ''47000'', ''0'', ''13'', ''TEA'', ''3404'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''3513'', ''ICE CAFE LATTE'', ''1'', ''49000'', ''0'', ''13'', ''COLD DRINKS\nC'', ''3513'', ''Minuman'', ''DINE IN'', ''49000'', ''2695.02'', ''5170'', ''56865.02'', ''49000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''1421'', ''GREEN PEAS SOUP'', ''1'', ''60000'', ''0'', ''13'', ''APPETIZER'', ''1421'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''13'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''13'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''NANIK'', NULL, ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''13'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''NANIK'', NULL, ''Sun'', NULL, ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''13'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''NANIK'', NULL, ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''13'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''NANIK'', NULL, ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''13'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000279'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''6137'', ''Add 1 P.choco'', ''1'', ''23000'', ''0'', ''13'', ''EXTRA'', ''6137'', ''Makanan'', ''DINE IN'', ''23000'', ''1265.02'', ''2427'', ''26692.02'', ''23000'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000280'', ''2023-01-06'', ''0'', ''4'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000280'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', NULL, ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000280'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', NULL, ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000280'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', NULL, ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000280'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1407'', ''CHICKEN CAESAR SALAD'', ''1'', ''88000'', ''0'', ''14'', ''APPETIZER'', ''1407'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000280'', ''2023-01-06'', ''0'', ''0'', ''MES POTETI'', ''MES POTETI'', ''TARI'', NULL, ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''14'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000280'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1908'', ''CHICKEN BALSAMIC RISOTTO'', ''1'', ''95000'', ''0'', ''14'', ''RISOTTO'', ''1908'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''2'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''3108'', ''COCA COLA ZERO'', ''1'', ''27000'', ''0'', ''14'', ''SOFT DRINKS'', ''3108'', ''Minuman'', ''DINE IN'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', NULL, ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''NANIK'', NULL, ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', NULL, ''Sun'', NULL, ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''14'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', NULL, ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''NANIK'', NULL, ''Sun'', NULL, ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''14'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''NANIK'', NULL, ''Sun'', NULL, ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', NULL, ''Sun'', NULL, ''1413'', ''CRISPY CHICK FILLET'', ''1'', ''82000'', ''0'', ''14'', ''APPETIZER'', ''1413'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000281'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', NULL, ''3533'', ''ICED BLACK COFFEE'', ''1'', ''44000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3533'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''3'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3542'', ''CENDOLHOLIC'', ''1'', ''43000'', ''0'', ''14'', ''SPECIAL DRINK'', ''3542'', ''Minuman'', ''DINE IN'', ''43000'', ''2365.02'', ''4537'', ''49902.02'', ''43000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''1421'', ''GREEN PEAS SOUP'', ''2'', ''120000'', ''0'', ''14'', ''APPETIZER'', ''1421'', ''Makanan'', ''DINE IN'', ''120000'', ''6600.02'', ''12660'', ''139260.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', NULL, ''Sun'', NULL, ''1617'', ''TRUFFLE BEEF BURGER'', ''1'', ''121000'', ''0'', ''14'', ''BURGER'', ''1617'', ''Makanan'', ''DINE IN'', ''121000'', ''6655.02'', ''12766'', ''140421.02'', ''121000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''0'', ''TELOR 3/4 MATANG'', ''TELOR 3/4 MATANG'', ''TARI'', NULL, ''Sun'', NULL, ''99003'', ''TELOR 3/4 MATANG'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER TELO'', ''99003'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1507'', ''HOT TUNA'', ''1'', ''82000'', ''0'', ''14'', ''PASTA'', ''1507'', ''Makanan'', ''DINE IN'', ''82000'', ''4510.02'', ''8651'', ''95161.02'', ''82000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000282'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000283'', ''2023-01-06'', ''0'', ''1'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''1136'', ''WALNUT CRUNCH (S)'', ''1'', ''60000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1136'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000283'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000283'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''14'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000283'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''AYU'', ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''14'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''3'', ''P. CHOCOLATE'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', ''P. CHOCOLATE'', ''P. CHOCOLATE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6212'', ''P. CHOCOLATE'', ''1'', ''11000'', ''0'', ''14'', ''NEW MENU'', ''6212'', ''Makanan'', ''DINE IN'', ''11000'', ''605.02'', ''1161'', ''12766.02'', ''11000'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', ''P. ORIGINAL'', ''CHOCO ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1125'', ''COCO BAILEYS (S)'', ''1'', ''68000'', ''0'', ''14'', ''SWEET PANCAKE'', ''1125'', ''Makanan'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1262'', ''FRIED CHCK PANCAKE (S)'', ''1'', ''92000'', ''0'', ''14'', ''SAVOURY PANCA'', ''1262'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', ''W.ORIGINAL'', ''W.ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''97004'', ''W.ORIGINAL'', ''1'', ''0'', ''0'', ''14'', ''MODIFIER SAVO'', ''97004'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''14'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3544'', ''ES KOPI DJAKARTA'', ''1'', ''47000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3544'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000284'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3536'', ''ICE COFFEE HAZELNUT SHAKE'', ''1'', ''62000'', ''0'', ''14'', ''COLD DRINKS\nC'', ''3536'', ''Minuman'', ''DINE IN'', ''62000'', ''3410.02'', ''6541'', ''71951.02'', ''62000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000285'', ''2023-01-06'', ''0'', ''4'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''15'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000285'', ''2023-01-06'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''15'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000285'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''15'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''4'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''15'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''15'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', ''MASHED POTATO'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''15'', ''STEAK'', ''1721'', ''Makanan'', ''DINE IN'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''15'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''15'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000286'', ''2023-01-06'', ''0'', ''0'', ''WITH OUT BLACK PEPER'', ''WITH OUT BLACK PEPER'', ''TARI'', ''DESI'', ''Sun'', ''Fadjar'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''15'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''4'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''15'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', ''TARI'', ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1519'', ''CHICKEN & BLUE CHEESE'', ''1'', ''100000'', ''0'', ''15'', ''PASTA'', ''1519'', ''Makanan'', ''DINE IN'', ''100000'', ''5500.02'', ''10550'', ''116050.02'', ''100000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''15'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''15'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''15'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''15'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''TARI'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''15'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3621'', ''PICCOLO LATTE'', ''1'', ''44000'', ''0'', ''15'', ''COFFEE'', ''3621'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3331'', ''FRESH APPLE'', ''1'', ''45000'', ''0'', ''15'', ''PRESSED JUICE'', ''3331'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000287'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3601'', ''CAPPUCINO'', ''1'', ''42000'', ''0'', ''15'', ''COFFEE'', ''3601'', ''Minuman'', ''DINE IN'', ''42000'', ''2310.02'', ''4431'', ''48741.02'', ''42000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000288'', ''2023-01-06'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''I'', ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''16'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000288'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''I'', ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''16'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000288'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''16'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000288'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''I'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000289'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''G'', ''1520'', ''SALMON PESTO'', ''1'', ''133563'', ''0'', ''16'', ''PASTA'', ''1520'', ''Makanan'', ''DELIVERY'', ''133563'', ''7345.99'', ''14091'', ''154999.99'', ''133563'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000289'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''NANIK'', ''Sun'', ''G'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''16'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DELIVERY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000290'', ''2023-01-06'', ''0'', ''1'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', NULL, ''Sun'', NULL, ''1502'', ''CARBONARA'', ''1'', ''88000'', ''0'', ''17'', ''PASTA'', ''1502'', ''Makanan'', ''DINE IN'', ''88000'', ''4840.02'', ''9284'', ''102124.02'', ''88000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000290'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', NULL, ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''17'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''3'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''18'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''1423'', ''NACHOS BOLOGNAISE'', ''1'', ''78000'', ''0'', ''18'', ''APPETIZER'', ''1423'', ''Makanan'', ''DINE IN'', ''78000'', ''4290.02'', ''8229'', ''90519.02'', ''78000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''1952'', ''GNOCCHI SMOKED BEEF'', ''1'', ''92000'', ''0'', ''18'', ''GNOCCHI'', ''1952'', ''Makanan'', ''DINE IN'', ''92000'', ''5060.02'', ''9706'', ''106766.02'', ''92000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''18'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3703'', ''MANDARIN MOJITO'', ''1'', ''56000'', ''0'', ''18'', ''MOJITO'', ''3703'', ''Minuman'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3201'', ''GRANDMA\'S SECRET RECIPE LEMON'', ''1'', ''50000'', ''0'', ''18'', ''CLASSIC'', ''3201'', ''Minuman'', ''DINE IN'', ''50000'', ''2750.02'', ''5275'', ''58025.02'', ''50000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''18'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''18'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''18'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''NANIK'', ''Sun'', ''A'', ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''18'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000291'', ''2023-01-06'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''TARI'', ''NANIK'', ''Sun'', ''A'', ''3110'', ''SPARKLING WATER'', ''2'', ''72000'', ''0'', ''18'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''72000'', ''3960.02'', ''7596'', ''83556.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''3'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''E'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''18'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''E'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''18'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''NANIK'', ''Sun'', ''E'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''18'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', ''NANIK'', ''Sun'', ''E'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''18'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''NANIK'', ''Sun'', ''E'', ''1601'', ''CHEESE BURGER'', ''1'', ''95000'', ''0'', ''18'', ''BURGER'', ''1601'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', ''MEDIUM'', ''GRILLED POTATO'', ''TARI'', ''NANIK'', ''Sun'', ''E'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''18'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''TARI'', ''NANIK'', ''Sun'', ''E'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''18'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''NANIK'', ''Sun'', ''E'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', ''GRILLED POTATO'', ''GRILLED POTATO'', ''TARI'', ''NANIK'', ''Sun'', ''E'', ''7434'', ''GRILLED POTATO'', ''1'', ''0'', ''0'', ''18'', ''SIDE DISH'', ''7434'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', ''GORGONZOLA'', ''GORGONZOLA'', ''TARI'', ''NANIK'', ''Sun'', ''E'', ''7445'', ''GORGONZOLA'', ''1'', ''0'', ''0'', ''18'', ''SAUCE'', ''7445'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000292'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', ''E'', ''3810'', ''BINTANG (L)'', ''1'', ''68000'', ''0'', ''18'', ''LOCAL BEER'', ''3810'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000293'', ''2023-01-06'', ''0'', ''3'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''19'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000293'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''3216'', ''GINGERONI'', ''1'', ''41000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3216'', ''Minuman'', ''DINE IN'', ''41000'', ''2255.02'', ''4326'', ''47581.02'', ''41000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000293'', ''2023-01-06'', ''0'', ''0'', ''TANPA CABE'', ''TANPA CABE'', ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''1436'', ''UNDER THE SEA PLATTER'', ''1'', ''113000'', ''0'', ''19'', ''APPETIZER'', ''1436'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000293'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''TANIA'', ''Sun'', ''Coyote'', ''1411'', ''FRIED CHIPS (S)'', ''1'', ''51000'', ''0'', ''19'', ''APPETIZER'', ''1411'', ''Makanan'', ''DINE IN'', ''51000'', ''2805.02'', ''5381'', ''59186.02'', ''51000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000293'', ''2023-01-06'', ''0'', ''0'', ''- Less Ice'', ''- Less Ice'', ''TARI'', ''NANIK'', ''Sun'', ''Coyote'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''19'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''4'', ''LESS ICE'', ''LESS ICE'', ''TARI'', NULL, ''Sun'', NULL, ''3415'', ''THAI ICED TEA'', ''1'', ''44000'', ''0'', ''19'', ''TEA'', ''3415'', ''Minuman'', ''DINE IN'', ''44000'', ''2420.02'', ''4642'', ''51062.02'', ''44000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', NULL, ''Sun'', NULL, ''3211'', ''BANANA BOMB'', ''1'', ''58000'', ''0'', ''19'', ''SPECIAL DRINK'', ''3211'', ''Minuman'', ''DINE IN'', ''58000'', ''3190.02'', ''6119'', ''67309.02'', ''58000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', NULL, ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', NULL, ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''TARI'', NULL, ''Sun'', NULL, ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''1523'', ''BLACKPEPPER MEATBALL PASTA'', ''1'', ''95000'', ''0'', ''19'', ''PASTA'', ''1523'', ''Makanan'', ''DINE IN'', ''95000'', ''5225.02'', ''10023'', ''110248.02'', ''95000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''TARI'', NULL, ''Sun'', NULL, ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''19'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', NULL, ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''P. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''TARI'', NULL, ''Sun'', NULL, ''6211'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6211'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''CREPES CAKE'', ''VANILA ICE CREAM'', ''TARI'', NULL, ''Sun'', NULL, ''1832'', ''BERRY CHEESE (CC)'', ''1'', ''81000'', ''0'', ''19'', ''CREPES'', ''1832'', ''Makanan'', ''DINE IN'', ''81000'', ''4455.02'', ''8546'', ''94001.02'', ''81000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000294'', ''2023-01-06'', ''0'', ''0'', ''CREPES CAKE'', ''CREPES CAKE'', ''TARI'', NULL, ''Sun'', NULL, ''97099'', ''CREPES CAKE'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER CREP'', ''97099'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''2'', ''WARM'', ''WARM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1414'', ''CHICKEN HONEY  SALAD'', ''1'', ''84000'', ''0'', ''19'', ''APPETIZER'', ''1414'', ''Makanan'', ''DINE IN'', ''84000'', ''4620.02'', ''8862'', ''97482.02'', ''84000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1540'', ''OCEAN KING'', ''1'', ''113000'', ''0'', ''19'', ''PASTA'', ''1540'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''19'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''19'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''WARM'', ''WARM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6601003'', ''WARM'', ''1'', ''0'', ''0'', ''19'', ''MINERAL WATER'', ''6601003'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''19'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000295'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''TARI'', ''AYU'', ''Sun'', NULL, ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''19'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000296'', ''2023-01-06'', ''0'', ''0'', ''MASHED POTATO'', ''CORN'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''1721'', ''ROAST CHICKEN PORCINI'', ''1'', ''118000'', ''0'', ''19'', ''STEAK'', ''1721'', ''Makanan'', ''TAKE AWAY'', ''118000'', ''6490.02'', ''12449'', ''136939.02'', ''118000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000296'', ''2023-01-06'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7433'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000296'', ''2023-01-06'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''19'', ''SIDE DISH'', ''7435'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000296'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''19'', ''PASTA'', ''1520'', ''Makanan'', ''TAKE AWAY'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000296'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''19'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''TAKE AWAY'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000296'', ''2023-01-06'', ''0'', ''0'', ''- Di Bungkus'', ''- Di Bungkus'', ''NANIK'', ''AYU'', ''Sun'', ''TakeAway'', ''3102'', ''COKE'', ''1'', ''27000'', ''0'', ''19'', ''SOFT DRINKS'', ''3102'', ''Minuman'', ''TAKE AWAY'', ''27000'', ''1485.02'', ''2849'', ''31334.02'', ''27000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000297'', ''2023-01-06'', ''0'', ''2'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''B'', ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''20'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000297'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''B'', ''3546'', ''ICED CRISP COFFEE'', ''1'', ''47000'', ''0'', ''20'', ''COLD DRINKS\nC'', ''3546'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000297'', ''2023-01-06'', ''0'', ''0'', ''DAHULUKAN'', ''DAHULUKAN'', ''GEDE'', ''NANIK'', ''Sun'', ''B'', ''1419'', ''FRIED MUSHROM'', ''1'', ''56000'', ''0'', ''20'', ''APPETIZER'', ''1419'', ''Makanan'', ''DINE IN'', ''56000'', ''3080.02'', ''5908'', ''64988.02'', ''56000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000297'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''NANIK'', ''Sun'', ''B'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000297'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''NANIK'', ''Sun'', ''B'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000297'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''NANIK'', ''Sun'', ''B'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000297'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''GEDE'', ''NANIK'', ''Sun'', ''B'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''4'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''1110'', ''CARAMELIZED BANANA (S)'', ''1'', ''59000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1110'', ''Makanan'', ''DINE IN'', ''59000'', ''3245.02'', ''6225'', ''68470.02'', ''59000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''1140'', ''RICOTTA AND RASPBERRY (S)'', ''1'', ''63000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1140'', ''Makanan'', ''DINE IN'', ''63000'', ''3465.02'', ''6647'', ''73112.02'', ''63000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''VANILA ICE CREAM'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''1138'', ''SALTED CARAMEL (S)'', ''1'', ''60000'', ''0'', ''20'', ''SWEET PANCAKE'', ''1138'', ''Makanan'', ''DINE IN'', ''60000'', ''3300.02'', ''6330'', ''69630.02'', ''60000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''W. ORIGINAL'', ''W. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''6214'', ''W. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''NEW MENU'', ''6214'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''ICE'', ''ICE'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''3403'', ''LEMON TEA'', ''1'', ''45000'', ''0'', ''20'', ''TEA'', ''3403'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''3105'', ''MINERAL WATER'', ''2'', ''36000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''GEDE'', ''DESI'', ''Sun'', ''A'', ''3523'', ''ICED COFFEE LATTE SHAKE'', ''1'', ''61000'', ''0'', ''20'', ''COLD DRINKS\nC'', ''3523'', ''Minuman'', ''DINE IN'', ''61000'', ''3355.02'', ''6436'', ''70791.02'', ''61000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''1255'', ''SAUTEED CHICKEN & MUSHROOM (S)'', ''1'', ''70000'', ''0'', ''20'', ''SAVOURY PANCA'', ''1255'', ''Makanan'', ''DINE IN'', ''70000'', ''3850.02'', ''7385'', ''81235.02'', ''70000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000298'', ''2023-01-06'', ''0'', ''0'', ''P. ORIGINAL'', ''P. ORIGINAL'', ''GEDE'', ''DESI'', ''Sun'', ''A'', ''97001'', ''P. ORIGINAL'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER SAVO'', ''97001'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''4'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1405'', ''CREAMY MUSHROM SOUP'', ''1'', ''66000'', ''0'', ''20'', ''APPETIZER'', ''1405'', ''Makanan'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1428'', ''FRIED MAC & CHEESE'', ''1'', ''67000'', ''0'', ''20'', ''APPETIZER'', ''1428'', ''Makanan'', ''DINE IN'', ''67000'', ''3685.02'', ''7069'', ''77754.02'', ''67000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1904'', ''SALMON RISOTTO'', ''1'', ''126000'', ''0'', ''20'', ''RISOTTO'', ''1904'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1524'', ''TRUFFLE CREAM PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1524'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', ''SALAD'', ''GARLIC MASHED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''1722'', ''GRILL TRUFFLE CHICKEN'', ''1'', ''116000'', ''0'', ''20'', ''STEAK'', ''1722'', ''Makanan'', ''DINE IN'', ''116000'', ''6380.02'', ''12238'', ''134618.02'', ''116000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''20'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3401'', ''ICE TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3401'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3545'', ''COFFEE & CENDOL DUET'', ''1'', ''47000'', ''0'', ''20'', ''COLD DRINKS\nC'', ''3545'', ''Minuman'', ''DINE IN'', ''47000'', ''2585.02'', ''4959'', ''54544.02'', ''47000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000299'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''NANIK'', ''Sun'', ''K'', ''3532'', ''ICE WHITE CHOCOLATE'', ''1'', ''45000'', ''0'', ''20'', ''CHOCOLATE'', ''3532'', ''Minuman'', ''DINE IN'', ''45000'', ''2475.02'', ''4748'', ''52223.02'', ''45000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000300'', ''2023-01-06'', ''0'', ''2'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3110'', ''SPARKLING WATER'', ''1'', ''36000'', ''0'', ''20'', ''SOFT DRINKS'', ''3110'', ''Minuman'', ''DINE IN'', ''36000'', ''1980.02'', ''3798'', ''41778.02'', ''36000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000300'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''3809'', ''BINTANG (S)'', ''1'', ''38000'', ''0'', ''20'', ''LOCAL BEER'', ''3809'', ''Minuman'', ''DINE IN'', ''38000'', ''2090.02'', ''4009'', ''44099.02'', ''38000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000300'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1532'', ''PRAWN & SPINACH PASTA'', ''1'', ''97000'', ''0'', ''20'', ''PASTA'', ''1532'', ''Makanan'', ''DINE IN'', ''97000'', ''5335.02'', ''10234'', ''112569.02'', ''97000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000300'', ''2023-01-06'', ''0'', ''0'', ''FETTUCINI'', ''FETTUCINI'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7411'', ''FETTUCINI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7411'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000300'', ''2023-01-06'', ''0'', ''0'', ''CORN'', ''CHIPS'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''1726'', ''BARAMUNDI & LEMON'', ''1'', ''177000'', ''0'', ''20'', ''STEAK'', ''1726'', ''Makanan'', ''DINE IN'', ''177000'', ''9735.02'', ''18674'', ''205409.02'', ''177000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000300'', ''2023-01-06'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000300'', ''2023-01-06'', ''0'', ''0'', ''CORN'', ''CORN'', ''NANIK'', ''DESI'', ''Sun'', ''Coyote'', ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''2'', ''SYRUP MONIN PISAH'', ''SYRUP MONIN PISAH'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''3405'', ''LYCHEE ICE TEA'', ''1'', ''48000'', ''0'', ''20'', ''TEA'', ''3405'', ''Minuman'', ''DINE IN'', ''48000'', ''2640.02'', ''5064'', ''55704.02'', ''48000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''3105'', ''MINERAL WATER'', ''1'', ''18000'', ''0'', ''20'', ''SOFT DRINKS'', ''3105'', ''Minuman'', ''DINE IN'', ''18000'', ''990.02'', ''1899'', ''20889.02'', ''18000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''COLD'', ''COLD'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''6601001'', ''COLD'', ''1'', ''0'', ''0'', ''20'', ''MINERAL WATER'', ''6601001'', ''Minuman'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''1520'', ''SALMON PESTO'', ''1'', ''113000'', ''0'', ''20'', ''PASTA'', ''1520'', ''Makanan'', ''DINE IN'', ''113000'', ''6215.02'', ''11922'', ''131137.02'', ''113000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''SPAGHETTI'', ''SPAGHETTI'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''7412'', ''SPAGHETTI'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7412'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''MEDIUM'', ''SALAD'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''20'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''MEDIUM'', ''MEDIUM'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''7423'', ''MEDIUM'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER STEA'', ''7423'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''GARLIC MASHED POTATO'', ''GARLIC MASHED POTATO'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''7436'', ''GARLIC MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7436'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''SOMA PALEMBANG'', ''031123-000301'', ''2023-01-06'', ''0'', ''0'', ''MUSHROOM'', ''MUSHROOM'', ''NANIK'', ''DESI'', ''Sun'', ''H'', ''7444'', ''MUSHROOM'', ''1'', ''0'', ''0'', ''20'', ''SAUCE'', ''7444'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000302'', ''2023-01-06'', ''0'', ''1'', NULL, NULL, ''TARI'', ''TARI'', ''Sun'', NULL, ''3402'', ''HOT TEA'', ''1'', ''29000'', ''0'', ''20'', ''TEA'', ''3402'', ''Minuman'', ''DINE IN'', ''29000'', ''1595.02'', ''3060'', ''33655.02'', ''29000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000302'', ''2023-01-06'', ''0'', ''0'', ''CHIPS'', ''CORN'', ''TARI'', ''TARI'', ''Sun'', NULL, ''1712'', ''FISH AND CHIPS'', ''1'', ''126000'', ''0'', ''20'', ''STEAK'', ''1712'', ''Makanan'', ''DINE IN'', ''126000'', ''6930.02'', ''13293'', ''146223.02'', ''126000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000302'', ''2023-01-06'', ''0'', ''0'', ''CORN'', ''CORN'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7433'', ''CORN'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7433'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''TSM MAKASAR'', ''031123-000302'', ''2023-01-06'', ''0'', ''0'', ''CHIPS'', ''CHIPS'', ''TARI'', ''TARI'', ''Sun'', NULL, ''7431'', ''CHIPS'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7431'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''4'', ''PENNE'', ''PENNE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1538'', ''CHICKEN PESTO'', ''1'', ''87000'', ''0'', ''20'', ''PASTA'', ''1538'', ''Makanan'', ''DINE IN'', ''87000'', ''4785.02'', ''9179'', ''100964.02'', ''87000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', ''PENNE'', ''PENNE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7413'', ''PENNE'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER PAST'', ''7413'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', ''WELLDONE'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1727'', ''STRIPLOIN BLACK ANGUS'', ''1'', ''273000'', ''0'', ''20'', ''STEAK'', ''1727'', ''Makanan'', ''DINE IN'', ''273000'', ''15015.02'', ''28802'', ''316817.02'', ''273000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', ''WELLDONE'', ''WELLDONE'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7425'', ''WELLDONE'', ''1'', ''0'', ''0'', ''20'', ''MODIFIER STEA'', ''7425'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', ''SALAD'', ''SALAD'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7432'', ''SALAD'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7432'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', ''MASHED POTATO'', ''MASHED POTATO'', ''TARI'', ''AYU'', ''Sun'', NULL, ''7435'', ''MASHED POTATO'', ''1'', ''0'', ''0'', ''20'', ''SIDE DISH'', ''7435'', ''Makanan'', ''DINE IN'', ''0'', ''0'', ''0'', ''0'', ''0'', ''EXTRA & PR'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''1409'', ''CHICKEN WINGS'', ''1'', ''83000'', ''0'', ''20'', ''APPETIZER'', ''1409'', ''Makanan'', ''DINE IN'', ''83000'', ''4565.02'', ''8757'', ''96322.02'', ''83000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', ''NO BACON NO EGG NO C'', ''NO BACON NO EGG NO C'', ''TARI'', ''AYU'', ''Sun'', NULL, ''1614'', ''BIG BURGER'', ''1'', ''110000'', ''0'', ''20'', ''BURGER'', ''1614'', ''Makanan'', ''DINE IN'', ''110000'', ''6050.02'', ''11605'', ''127655.02'', ''110000'', ''FOOD'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3202'', ''FRESH FRUIT COCKTAIL'', ''1'', ''76000'', ''0'', ''20'', ''SPECIAL DRINK'', ''3202'', ''Minuman'', ''DINE IN'', ''76000'', ''4180.02'', ''8018'', ''88198.02'', ''76000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''BALI'', ''031123-000303'', ''2023-01-06'', ''0'', ''0'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3307'', ''FRESH ORANGE'', ''1'', ''66000'', ''0'', ''20'', ''PRESSED JUICE'', ''3307'', ''Minuman'', ''DINE IN'', ''66000'', ''3630.02'', ''6963'', ''76593.02'', ''66000'', ''BEVERAGES'', ''January'', ''2023'', ''06'', ''Friday''),
(''PVJ BANDUNG'', ''031123-000304'', ''2023-01-06'', ''0'', ''2'', NULL, NULL, ''TARI'', ''AYU'', ''Sun'', NULL, ''3411'', ''EARL GREY MILK TEA'', ''1'', ''68000'', ''0'', ''20'', ''SPECIAL DRINK'', ''3411'', ''Minuman'', ''DINE IN'', ''68000'', ''3740.02'', ''7174'', ''78914.02'', ''68000'', ''BEVERAGE