// File: customHooks.js

window.customHooks = {

    afterDataLoad: async function(vueInstance, tabId, configKey) {
        console.log(`Hook 'afterDataLoad' terpicu untuk config: ${configKey}`);
        xcab='';

        if (configKey === 'Menu') {
            try {
                const currentTab = vueInstance.openTabs.find(tab => tab.id === tabId);
                if (!currentTab) return;

                const record = currentTab.currentRecord[configKey]; // Data dari tabel 'menus'
                
                if (!record || !record.kode) {
                    console.log("Sinkronisasi dilewati: Kode menu tidak ditemukan.");
                    return;
                }
                
                console.log(`Memulai sinkronisasi untuk menu kode: ${record.kode}`);

                // 1. Ambil semua data yang diperlukan dari 6 tabel secara bersamaan
                const kitchenPromise = window.ambil('kitchen', 'id', '0', '99999999999');
                const bprinterPromise = window.ambil('bprinter', 'barang', record.kode, record.kode);
                const toppingsPromise = window.ambil('toppings', 'id', '0', '99999999999');
                const btoppingsPromise = window.ambil('btoppings', 'barang', record.kode, record.kode);
                const cabangPromise = window.ambil('cabang', 'id', '0', '99999999999');      // <-- DATA BARU
                const bcabPromise = window.ambil('bcab', 'barang', record.kode, record.kode); // <-- DATA BARU
                
                const [
                    kitchenData, bprinterData, 
                    toppingsData, btoppingsData, 
                    cabangData, bcabData // <-- DATA BARU
                ] = await Promise.all([
                    kitchenPromise, bprinterPromise,
                    toppingsPromise, btoppingsPromise,
                    cabangPromise, bcabPromise // <-- DATA BARU
                ]);

                // Cek jika ada error saat pengambilan data
                if (!Array.isArray(cabangData) || !Array.isArray(bcabData)) {
                    console.error("Gagal mengambil data 'cabang' atau 'bcab'. Sinkronisasi dibatalkan.");
                    alert("Terjadi kesalahan saat mengambil data referensi cabang. Cek konsol.");
                    return;
                }

                // =============================================================
                // ||           BLOK SINKRONISASI BPRINTER                    ||
                // =============================================================
               
                console.log(`Memproses sinkronisasi 'bprinter'...`);
                const existingPrinters = new Set(bprinterData.map(p => p.printer));
                for (const kitchen of kitchenData) {
                    if (!existingPrinters.has(kitchen.kode)) {
                        await window.tambahjson('bprinter', {
                            barang: record.kode, printer: kitchen.kode, nprinter: kitchen.nama,
                            ya: '1', brand: window.xbrand, cab: window.xcab
                        });
                    }
                }
                console.log(`Sinkronisasi 'bprinter' selesai.`);

                // =============================================================
                // ||           BLOK SINKRONISASI BTOPPINGS                   ||
                // =============================================================
                console.log(`Memproses sinkronisasi 'btoppings'...`);
                const existingToppings = new Set(btoppingsData.map(t => t.toppings));
                for (const topping of toppingsData) {
                    if (!existingToppings.has(topping.kode)) {
                        await window.tambahjson('btoppings', {
                            barang: record.kode, toppings: topping.toping, nama: topping.groupname
                        });
                    }
                }
                console.log(`Sinkronisasi 'btoppings' selesai.`);

                // =============================================================
                // ||           BLOK SINKRONISASI bcab (BARU)                ||
                // =============================================================
                console.log(`Memproses sinkronisasi 'bcab'...`);

                // Siapkan format tanggal hari ini (YYYY-MM-DD)
                const today = new Date();
                const year = today.getFullYear();
                const month = String(today.getMonth() + 1).padStart(2, '0');
                const day = String(today.getDate()).padStart(2, '0');
                const todayFormatted = `${year}-${month}-${day}`;

                const existingCabang = new Set(bcabData.map(c => c.cabang));
                for (const cabang of cabangData) {
                    if (!existingCabang.has(cabang.kode)) {
                        console.log(`Menambahkan cabang baru ke bcab: Menu=${record.kode}, Cabang=${cabang.kode}`);
                        const newCabangRecord = {
                            barang: record.kode,       // dari menus.kode
                            cabang: cabang.kode,       // dari cabang.kode
                            nama: cabang.nama,         // dari cabang.nama
                            // Jika cabang.dt ada isinya, gunakan itu. Jika tidak, gunakan tanggal hari ini.
                            dt: cabang.dt || todayFormatted, 
                            // Jika cabang.st ada isinya, gunakan itu. Jika tidak, gunakan tanggal '2099-12-31'.
                            st: cabang.st || '2099-12-31',
                            no: false
                        };
                        await window.tambahjson('bcab', newCabangRecord);
                    }
                }
                console.log(`Sinkronisasi 'bcab' selesai.`);

                
                // Refresh semua detail grid setelah semua sinkronisasi selesai
                console.log("Memanggil refresh untuk semua detail grid...");
                vueInstance.refreshDetailGrids(tabId, configKey);

            } catch (error) {
                console.error("Terjadi error serius pada proses sinkronisasi:", error);
                alert("Terjadi error saat sinkronisasi. Lihat konsol untuk detail.");
            }
        };

        if (configKey === 'g_user') {
            console.log(`Hook 'afterDataLoad' terpicu untuk config: ${configKey}`);
            try {
                const currentTab = vueInstance.openTabs.find(tab => tab.id === tabId);
                if (!currentTab) return;

                // Ambil record g_user yang sedang dibuka
                const record = currentTab.currentRecord[configKey]; 
                
                if (!record || !record.kode) {
                    console.log("Sinkronisasi dilewati: Kode grup pengguna (g_user) tidak ditemukan.");
                    return;
                }
                
                console.log(`Memulai sinkronisasi otorisasi untuk g_user kode: ${record.kode}`);

                // 1. Ambil data referensi (otor) dan data anak yang sudah ada (botor)
                const otorPromise = window.ambil('otor', 'id', '0', '99999999999');
                const botorPromise = window.ambil('botor', 'g_user', record.kode, record.kode);
                
                const [otorData, botorData] = await Promise.all([otorPromise, botorPromise]);

                // Validasi data
                if (!Array.isArray(otorData) || !Array.isArray(botorData)) {
                    console.error("Gagal mengambil data 'otor' atau 'botor'. Sinkronisasi dibatalkan.");
                    alert("Terjadi kesalahan saat mengambil data otorisasi. Cek konsol.");
                    return;
                }

                // 2. Buat Set dari otorisasi yang sudah ada di 'botor' untuk pengecekan cepat
                console.log(`Memproses sinkronisasi 'botor'...`);
                const existingOtor = new Set(botorData.map(b => b.otor));

                // 3. Loop melalui semua data referensi 'otor'
                for (const otor of otorData) {
                    // 4. Jika otorisasi belum ada untuk g_user ini, tambahkan
                    if (!existingOtor.has(otor.kode)) {
                        console.log(`Menambahkan otorisasi baru ke botor: Grup=${record.kode}, Otorisasi=${otor.kode}`);
                        const newOtorRecord = {
                            g_user: record.kode,    // dari g_user.kode
                            otor: otor.kode,        // dari otor.kode
                            nama: otor.nama,        // dari otor.nama
                            ya: '0',                // Nilai default '0' (tidak aktif)
                            brand: window.xbrand,
                            cab: window.xcab
                        };
                        await window.tambahjson('botor', newOtorRecord);
                    }
                }
                console.log(`Sinkronisasi 'botor' untuk grup ${record.kode} selesai.`);

                // 5. Refresh grid detail untuk menampilkan data yang baru ditambahkan
                console.log("Memanggil refresh untuk detail grid 'botor'...");
                vueInstance.refreshDetailGrids(tabId, configKey);

            } catch (error) {
                console.error(`Terjadi error serius pada proses sinkronisasi g_user:`, error);
                alert("Terjadi error saat sinkronisasi otorisasi. Lihat konsol untuk detail.");
            }
        }        
    },

    beforeSave: function(vueInstance, tabId, configKey) {
        // ... (isi fungsi ini tetap sama)
        return true;
    }
};