// PropertiesPanel.js

const PropertiesPanel = {
    props: {
        selectedElement: {
            type: Object,
            required: true
        }
    },
    emits: ['update-property', 'delete-element'],
    setup(props, { emit }) {

        // Fungsi ini sekarang ada di dalam komponen, bekerja pada 'props.selectedElement'
        const getElementProperty = (path) => {
            if (!props.selectedElement) return '';
            const keys = path.split('.');
            let value = props.selectedElement;
            for (const key of keys) {
                if (value === undefined || value === null) return '';
                value = value[key];
            }
            if (typeof value === 'string' && value.endsWith('px')) {
                return parseFloat(value) || 0;
            }
            return value === undefined ? '' : value;
        };

        // Fungsi ini sekarang MENGEMISIKAN event, bukan mengubah data secara langsung
        const updateElementProperty = (path, value) => {
            const pixelProps = ['top', 'left', 'width', 'height', 'fontSize'];
            const lastKey = path.split('.').pop();
            
            if (pixelProps.includes(lastKey) && !isNaN(parseFloat(value))) {
                value = `${value}px`;
            }
            emit('update-property', { path, value });
        };
        
        const removeElement = () => {
            emit('delete-element');
        }

        return {
            getElementProperty,
            updateElementProperty,
            removeElement
        };
    },
    template: `
      <div id="properties-panel" class="ve-floating-window">
          <div class="ve-window-header"><i class="fa-solid fa-sliders"></i> Properti</div>
          <div class="ve-window-content" v-if="selectedElement">
              <div id="selected-info">ID: <span>{{ selectedElement.id }}</span></div>
              <div class="ve-panel-actions">
                  <button @click="removeElement" id="delete-button"><i class="fa-solid fa-trash"></i> Hapus</button>
              </div>
              <fieldset>
                  <legend>Konten</legend>
                  <template v-if="['h1','h2','h3','h4','h5','h6','p','div','span'].includes(selectedElement.tag) && !selectedElement.isDatabaseField">
                      <label>Teks</label>
                      <textarea :value="getElementProperty('content')" @input="updateElementProperty('content', $event.target.value)"></textarea>
                  </template>
                  <template v-if="selectedElement.tag === 'img'">
                      <label>URL Gambar</label>
                      <input type="text" :value="getElementProperty('src')" @input="updateElementProperty('src', $event.target.value)">
                  </template>
              </fieldset>
              <fieldset v-if="selectedElement.style.position === 'absolute'">
                  <legend>Posisi & Ukuran</legend>
                  <label>Top ({{ getElementProperty('style.top') || '0px' }})</label>
                  <input type="range" min="0" max="1120" step="1" :value="getElementProperty('style.top')" @input="updateElementProperty('style.top', $event.target.value)">
                  <label>Left ({{ getElementProperty('style.left') || '0px' }})</label>
                  <input type="range" min="0" max="780" step="1" :value="getElementProperty('style.left')" @input="updateElementProperty('style.left', $event.target.value)">
                  <label>Width ({{ getElementProperty('style.width') || '0px' }})</label>
                  <input type="range" min="10" max="800" step="1" :value="getElementProperty('style.width')" @input="updateElementProperty('style.width', $event.target.value)">
                  <label>Height ({{ getElementProperty('style.height') || '0px' }})</label>
                  <input type="range" min="10" max="1120" step="1" :value="getElementProperty('style.height')" @input="updateElementProperty('style.height', $event.target.value)">
              </fieldset>
              <fieldset>
                  <legend>Teks & Warna</legend>
                  <label>Font Size ({{ getElementProperty('style.fontSize') || '0px' }})</label>
                  <input type="range" min="8" max="100" step="1" :value="getElementProperty('style.fontSize')" @input="updateElementProperty('style.fontSize', $event.target.value)">
                  <label>Text Color</label>
                  <input type="color" :value="getElementProperty('style.color')" @input="updateElementProperty('style.color', $event.target.value)">
                  <label>Background Color</label>
                  <input type="color" :value="getElementProperty('style.backgroundColor')" @input="updateElementProperty('style.backgroundColor', $event.target.value)">
              </fieldset>
          </div>
      </div>
    `
};