<?php
// ========== PENGATURAN KONEKSI DATABASE ==========
$host = 'localhost';
$user = 'root';
$pass = ''; // Kosongkan jika tidak ada password
$db   = 'pos_m'; // <-- GANTI DENGAN NAMA DATABASE ANDA
// ===============================================

// Set header untuk memberitahu browser bahwa responsnya adalah JSON
header('Content-Type: application/json');

// Buat koneksi ke database
$conn = new mysqli($host, $user, $pass, $db);

// Cek jika koneksi gagal
if ($conn->connect_error) {
    // Kirim pesan error dalam format JSON dan hentikan script
    echo json_encode(['error' => 'Koneksi database gagal: ' . $conn->connect_error]);
    exit();
}

// Ambil query SQL yang dikirim dari JavaScript
$query = isset($_POST['query']) ? $_POST['query'] : '';

if (empty($query)) {
    echo json_encode(['error' => 'Query tidak boleh kosong']);
    exit();
}

// Jalankan query SQL
$result = $conn->query($query);

// Cek apakah query berhasil dijalankan
if ($result) {
    $data = [];
    // Ambil setiap baris data dan masukkan ke dalam array
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    // Kirim data yang berhasil didapat dalam format JSON
    echo json_encode($data);
} else {
    // Kirim pesan error jika query gagal
    echo json_encode(['error' => 'Eksekusi query gagal: ' . $conn->error]);
}

// Tutup koneksi database
$conn->close();
?>