<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Client Pengirim Data Transaksi</title>
    <style>
        body { font-family: sans-serif; margin: 2em; background-color: #f0f2f5; }
        .container { max-width: 800px; margin: auto; background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        textarea { width: 100%; height: 300px; box-sizing: border-box; font-family: monospace; font-size: 14px; }
        button { width: 100%; padding: 12px; font-size: 16px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; margin-top: 10px; }
        button:hover { background-color: #0056b3; }
        pre { background-color: #222; color: #fff; padding: 15px; border-radius: 5px; white-space: pre-wrap; word-wrap: break-word; }
        .sukses { color: #28a745; }
        .error { color: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <h1>📲 Client Pengirim Transaksi ke Cloud</h1>
        <h2>Data Transaksi (Format JSON)</h2>
        <textarea id="jsonData"></textarea>
        <button id="sendButton">Kirim Transaksi ke Server Cloud</button>
        <h2>Respons dari Server</h2>
        <pre id="apiResponse">Menunggu pengiriman...</pre>
    </div>

    <script>
        // --- PENTING: GANTI URL INI DENGAN URL API DI SERVER CLOUD ANDA ---
        const apiUrl = 'http://localhost/bener/pos2/coba/terima.php';

        const jsonDataEl = document.getElementById('jsonData');
        const sendButton = document.getElementById('sendButton');
        const apiResponseEl = document.getElementById('apiResponse');

        // Contoh data satu transaksi
        const testData = {
          "jual_data": { "brand": "001", "cab": "006", "tipe": "01", "komplit": "1", "mesin": "03", "nomor": "001-006-25-03000455", "tanggal": "2025-08-24", "jamm": "2025-08-24 21:41:56", "jams": "2025-08-24 21:41:56", "shift": 1, "guest": "", "cover": 2, "jumlah": 188001.00, "bayar": 188001.00, "meja": "03", "ttax": 17091.00, "ttot": 162000.00, "tserv": 8910.00, "user": "Budi", "batal": 0, "kasir": "3", "register": "001-006-03-XX000010", "deliver": "0", "cash": 0.00, "card": 188001.00, "voucher": 0.00, "house": 0.00, "gift": 0.00, "usia": "0", "sex": "0", "kembali": 0.00, "rounding": 0, "pvoucher": 0, "diskrupiah": 0.00 },
          "pesani_data": [
            { "brand": "001", "cab": "006", "nomor": "001-006-25-03000455", "sub": "0", "payment": "", "tglo": "2025-08-24 21:41:56", "kode": "0424", "name": "Chicken Katsu Don", "kgroup": "04", "group_name": "Donburi", "quantity": 1, "harga": 51000.00, "price": 51000.00, "discp": 0, "discr": 0, "netto": 51000.00, "disc": 0, "ppn": 10.00, "pajak": 0, "serv": 5.50, "service": 0, "jumlah": 51000.00, "meja": "03", "ket": "", "edc": "", "nocard": "", "user": "Budi", "split": "", "dname": "", "note": "", "cetak": "1" },
            { "brand": "001", "cab": "006", "nomor": "001-006-25-03000455", "sub": "0", "payment": "12", "tglo": "2025-08-24 21:41:56", "kode": "", "name": "BCA", "kgroup": "", "group_name": "", "quantity": 1, "harga": 188001.00, "price": 0, "discp": 0, "discr": 0, "netto": 188001.00, "disc": 0, "ppn": 0, "pajak": 0, "serv": 0, "service": 0, "jumlah": 188001.00, "meja": "03", "ket": "", "edc": "BCA", "nocard": "", "user": "Budi", "split": "", "dname": "", "note": "", "cetak": "" }
          ]
        };

        // Tampilkan contoh data di textarea
        jsonDataEl.value = JSON.stringify(testData, null, 2);

        // Tambahkan event listener ke tombol
        sendButton.addEventListener('click', async () => {
            apiResponseEl.className = '';
            apiResponseEl.textContent = 'Mengirim...';

            try {
                // Menggunakan Fetch API untuk mengirim data
                const response = await fetch(apiUrl, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: jsonDataEl.value // Ambil data dari textarea
                });

                const result = await response.json();

                // Tampilkan hasil dari server
                apiResponseEl.textContent = JSON.stringify(result, null, 2);

                if (response.ok) { // HTTP status 200-299
                    apiResponseEl.classList.add('sukses');
                } else {
                    apiResponseEl.classList.add('error');
                }
            } catch (error) {
                // Menangani error jaringan
                apiResponseEl.className = 'error';
                apiResponseEl.textContent = 'Gagal terhubung ke server. Error: ' + error.message;
            }
        });
    </script>
</body>
</html>