<?php
// Tampilkan semua error untuk diagnosis
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set header ke JSON
header('Content-Type: application/json');

try {
    // Mencoba memuat file konfigurasi database
    // Jika baris ini gagal, error akan ditampilkan
    require_once 'db_config.php';

    // Jika require_once berhasil dan variabel $conn ada
    if (isset($conn) && $conn->ping()) {
        echo json_encode([
            'status'  => 'sukses',
            'message' => 'Koneksi ke database BERHASIL.',
            'host_info' => $conn->host_info
        ]);
        $conn->close();
    } else {
        // Ini terjadi jika db_config.php ada, tapi tidak membuat variabel $conn
        throw new Exception("File db_config.php berhasil dimuat, tetapi variabel koneksi (\$conn) tidak ditemukan atau koneksi gagal.");
    }

} catch (Throwable $e) {
    // Menangkap semua jenis error (termasuk error fatal dari require_once)
    // dan menampilkannya dalam format JSON
    http_response_code(500);
    echo json_encode([
        'status'  => 'error',
        'message' => 'Terjadi error fatal.',
        'detail'  => $e->getMessage(),
        'file'    => $e->getFile(),
        'line'    => $e->getLine()
    ]);
}
?>