<?php
// Tampilkan semua error
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set header ke JSON
header('Content-Type: application/json');

// Cek metode request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Metode harus POST.']);
    exit();
}

// Ambil data JSON dari body request
$data = json_decode(file_get_contents('php://input'), true);

// Cek apakah JSON valid
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error', 
        'message' => 'Data JSON yang dikirim tidak valid.'
    ]);
    exit();
}

// Jika sampai di sini, artinya data berhasil diterima dan di-decode
http_response_code(200);
echo json_encode([
    'status'  => 'sukses',
    'message' => 'Data JSON berhasil diterima dan di-decode oleh server.',
    'jumlah_transaksi_diterima' => isset($data['transaksi']) ? count($data['transaksi']) : 0
]);
?>