<?php
// kiosk_server.php

// Izinkan akses dari mana saja (Cross-Origin Resource Sharing)
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Muat konfigurasi database Anda
require 'config.php'; 

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Connection failed: ' . $conn->connect_error]);
    exit();
}

try {
    $products = [];
    // Query utama untuk mengambil semua produk
    $sql_products = "SELECT * FROM products ORDER BY id";
    $result_products = $conn->query($sql_products);

    if ($result_products) {
        while ($product = $result_products->fetch_assoc()) {
            $product_id = $product['id'];

            // Konversi tipe data agar konsisten
            $product['is_best_seller'] = (bool)$product['is_best_seller'];
            $product['base_price'] = (float)$product['base_price'];

            // 1. Ambil Varian Produk
            $stmt_variants = $conn->prepare("SELECT * FROM product_variants WHERE product_id = ?");
            $stmt_variants->bind_param("i", $product_id);
            $stmt_variants->execute();
            $variants_result = $stmt_variants->get_result();
            $variants = [];
            while ($variant_row = $variants_result->fetch_assoc()) {
                $variant_row['attributes'] = json_decode($variant_row['attributes'], true);
                $variant_row['stock'] = (int)$variant_row['stock'];
                $variants[] = $variant_row;
            }
            $product['variants'] = $variants ?: [];
            
            // 2. Ambil Addons Produk
            $stmt_addons = $conn->prepare("SELECT * FROM product_addons WHERE product_id = ?");
            $stmt_addons->bind_param("i", $product_id);
            $stmt_addons->execute();
            $addons_result = $stmt_addons->get_result();
            $addons = [];
            while ($addon_row = $addons_result->fetch_assoc()) {
                $addon_row['price'] = (float)$addon_row['price'];
                $addons[] = $addon_row;
            }
            $product['addons'] = $addons ?: [];
            
            // 3. Ambil Grup Kustomisasi (Condiment Groups) dan Opsi-nya
            $stmt_groups = $conn->prepare("SELECT * FROM condiment_groups WHERE product_id = ?");
            $stmt_groups->bind_param("i", $product_id);
            $stmt_groups->execute();
            $groups_result = $stmt_groups->get_result();
            $condiment_groups = [];
            
            while($group = $groups_result->fetch_assoc()){
                $group_id = $group['id'];
                $group['is_required'] = (bool)$group['is_required'];

                // Ambil Opsi untuk setiap grup
                $stmt_options = $conn->prepare("SELECT * FROM condiment_options WHERE group_id = ?");
                $stmt_options->bind_param("i", $group_id);
                $stmt_options->execute();
                $options_result = $stmt_options->get_result();
                $options = [];
                while ($option_row = $options_result->fetch_assoc()) {
                    $option_row['price'] = (float)$option_row['price'];
                    $options[] = $option_row;
                }
                $group['options'] = $options ?: [];
                $condiment_groups[] = $group;
            }
            $product['condiment_groups'] = $condiment_groups;

            // Masukkan produk yang sudah lengkap ke array utama
            $products[] = $product;
        }
    }
    
    // Kembalikan semua data produk sebagai satu JSON besar
    echo json_encode($products);

} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

$conn->close();
?>