/**
 * Fungsi untuk menampilkan status proses pada halaman HTML.
 * @param {string} message - Pesan yang akan ditampilkan.
 * @param {string} type - 'info', 'success', atau 'error' untuk pewarnaan.
 */
function tampilkanStatus(message, type = 'info') {
    const statusArea = document.getElementById('statusArea');
    if (statusArea) {
        statusArea.textContent = message;
        statusArea.className = 'status ' + type;
        statusArea.style.display = 'block';
    } else {
        // Fallback jika elemen tidak ditemukan

        //alert(message);
    }
}

/**
 * Fungsi utama untuk mengirim data transaksi manual berdasarkan nomor jual.
 * @param {string} nomorJual - Nomor transaksi yang akan dicari dan dikirim.
 */
async function kirimTransaksiManual(nomorJual) {
    // 1. Validasi Input
    if (!nomorJual || nomorJual.trim() === '') {
        tampilkanStatus('Error: Nomor Jual tidak boleh kosong!', 'error');
        return;
    }
    nomorJual = nomorJual.trim();
    //tampilkanStatus(`Mencari data untuk nomor transaksi: ${nomorJual}...`, 'info');

    // **PENTING**: Konfigurasi URL server pusat Anda di sini
    qq=vm.pos.url_server_pusat;
    const serverUrl = qq; // Ganti dengan URL server Anda

    try {
        // 2. Ambil Data dari Database Lokal
        const queryJual = `SELECT * FROM jual WHERE nomor = '${nomorJual}'`;
        const dataJualArr = JSON.parse(await ambil_select('jual', queryJual));

        if (dataJualArr.length === 0) {
            tampilkanStatus(`Error: Transaksi dengan nomor ${nomorJual} tidak ditemukan.`, 'error');
            return;
        }
        const dataJual = dataJualArr[0];

        // Cek apakah sudah pernah dikirim
        if (dataJual.kirim == '1') {
             if (!confirm(`Transaksi ${nomorJual} sudah pernah dikirim. Tetap kirim ulang?`)) {
                 tampilkanStatus('Proses dibatalkan oleh pengguna.', 'info');
                 return;
             }
        }

        const queryPesani = `SELECT * FROM pesani WHERE nomor = '${nomorJual}'`;
        const dataPesani = JSON.parse(await ambil_select('pesani', queryPesani));

        // 3. Gabungkan data menjadi format JSON yang sesuai
        const paketData = {
            jual: dataJual,
            pesani: dataPesani
        };

        tampilkanStatus(`Data ditemukan. Mengirim ke server...`, 'info');

        // 4. Kirim Data ke Server (logika dari kirim.html)
        const response = await fetch(serverUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(paketData)
        });

        if (!response.ok) {
            throw new Error(`Gagal terhubung ke server. Status: ${response.status}`);
        }

        const result = await response.json();

        // 5. Handle Respon dari Server
        if (result.success) {
            
            // Jika berhasil, update status 'kirim' di database lokal
            await rubahjson('jual', { kirim: 1 }, nomorJual, 'nomor');
            tampilkanStatus(`✅ Sukses! Transaksi ${nomorJual} berhasil dikirim dan ditandai sebagai terkirim.`, 'success');
        } else {
            alert('gagal');
            throw new Error(`Server merespon dengan error: ${result.message}`);
        }

    } catch (error) {
        console.error('Detail Error:', error);
        tampilkanStatus(`❌ Gagal! ${error.message}`, 'error');
    }
}