<?php
// Asumsikan Anda punya file koneksi.php untuk menghubungkan ke database
// include 'koneksi.php'; 

// --- Ganti bagian ini dengan koneksi database Anda ---
$host = 'localhost';
$dbname = 'mobile';
$user = 'root';
$pass = '';
require 'config.php';
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Koneksi ke database gagal: " . $e->getMessage());
}
// --- Akhir bagian koneksi ---


// 1. Ambil kode transaksi dari URL
$transaction_code = isset($_GET['kode']) ? $_GET['kode'] : '';

$transaction = null;

if ($transaction_code) {
    // 2. Cari transaksi di database menggunakan prepared statement untuk keamanan
    $stmt = $pdo->prepare("SELECT * FROM transactions WHERE transaction_code = ?");
    $stmt->execute([$transaction_code]);
    $transaction = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Fungsi untuk format Rupiah
function formatRupiah($number) {
    return 'Rp ' . number_format($number, 0, ',', '.');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Transaksi</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; background-color: #f4f4f5; margin: 0; padding: 20px; color: #333; }
        .container { max-width: 600px; margin: auto; background: white; padding: 25px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        h1 { color: #00885a; text-align: center; border-bottom: 2px solid #00885a; padding-bottom: 10px; margin-top: 0;}
        .info-grid { display: grid; grid-template-columns: 150px 1fr; gap: 8px 15px; }
        .info-grid strong { color: #555; }
        .item-list { margin-top: 25px; border-top: 1px solid #eee; padding-top: 15px; }
        .item { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #f0f0f0; }
        .item:last-child { border-bottom: none; }
        .item .name { font-weight: 500; }
        .total-summary { text-align: right; margin-top: 20px; }
        .total-summary div { margin-bottom: 5px; }
        .grand-total { font-size: 1.2em; font-weight: bold; color: #00885a; }
        .not-found { text-align: center; color: #d9534f; font-size: 1.2em; }
    </style>
</head>
<body>

    <div class="container">
        <h1>Detail Transaksi</h1>

        <?php if ($transaction): ?>
            <div class="info-grid">
                <strong>No. Transaksi:</strong>
                <span><?php echo htmlspecialchars($transaction['transaction_code']); ?></span>

                <!-- <strong>Tanggal:</strong>
                <span><?php echo date("d F Y H:i", strtotime($transaction['created_at'])); ?></span> -->

                <strong>Nama Pelanggan:</strong>
                <span><?php echo htmlspecialchars($transaction['customer_name']); ?></span>

                <strong>Status Pembayaran:</strong>
                <span>Lunas (Contoh)</span>
            </div>

            <div class="item-list">
                <h3>Rincian Pesanan</h3>
                <?php 
                // Mengambil detail keranjang dari kolom cart_snapshot
                // Kolom ini dibuat oleh processCheckout di main.js
                $cart_items = json_decode($transaction['cart_snapshot'], true);
                if ($cart_items):
                    foreach ($cart_items as $item):
                ?>
                    <div class="item">
                        <span class="name"><?php echo htmlspecialchars($item['quantity']); ?>x <?php echo htmlspecialchars($item['name']); ?></span>
                        <span class="price"><?php echo formatRupiah($item['finalPrice'] * $item['quantity']); ?></span>
                    </div>
                <?php 
                    endforeach;
                endif;
                ?>
            </div>

            <div class="total-summary">
                <div>Subtotal: <?php echo formatRupiah($transaction['total_amount']); ?></div>
                <div>Diskon: -<?php echo formatRupiah($transaction['discount_amount']); ?></div>
                <div class="grand-total">Total: <?php echo formatRupiah($transaction['final_amount']); ?></div>
            </div>

        <?php else: ?>
            <p class="not-found">Transaksi dengan kode "<?php echo htmlspecialchars($transaction_code); ?>" tidak ditemukan.</p>
        <?php endif; ?>

    </div>

</body>
</html>
