// sw.js - Service Worker
// File ini diperlukan agar aplikasi dianggap sebagai PWA dan bisa "diinstal".
// Untuk saat ini, kita hanya akan menambahkan event listener dasar.

self.addEventListener('install', (event) => {
  console.log('Service Worker: Menginstal...');
  // Lewati fase 'waiting' agar SW baru segera aktif
  self.skipWaiting();
});

self.addEventListener('activate', (event) => {
  console.log('Service Worker: Aktif.');
  // Mengambil alih kontrol halaman dengan segera
  event.waitUntil(self.clients.claim());
});

self.addEventListener('fetch', (event) => {
  // Untuk saat ini, kita hanya akan mengembalikan permintaan jaringan seperti biasa.
  // Nantinya, ini bisa dikembangkan untuk caching offline.
  event.respondWith(fetch(event.request));
});