// --- FUNGSI-FUNGSI BARU UNTUK LAPORAN ---

// Fungsi untuk mengambil data Laporan Stok
function getStockReport(month, sortBy) {
    let result = [];
    $.ajax({
        type: "POST",
        async: false,
        url: "crud.php",
        data: {
            action: 'get_stock_report_data',
            month: month,
            sortBy: sortBy
        },
        success: function(response) {
            try {
                result = JSON.parse(response);
            } catch (e) {
                console.error("Gagal parse JSON Laporan Stok:", response);
                result = [];
            }
        },
        error: function(error) {
            console.error("AJAX Error Laporan Stok:", error);
            result = [];
        }
    });
    return result;
}

// Fungsi untuk mengambil data Laporan Pembelian
function getPurchaseReport(month) {
    let result = [];
    $.ajax({
        type: "POST",
        async: false,
        url: "crud.php",
        data: {
            action: 'get_purchase_report_data',
            month: month
        },
        success: function(response) {
            try {
                result = JSON.parse(response);
            } catch (e) {
                console.error("Gagal parse JSON Laporan Pembelian:", response);
                result = [];
            }
        },
        error: function(error) {
            console.error("AJAX Error Laporan Pembelian:", error);
            result = [];
        }
    });
    return result;
}


// --- FUNGSI-FUNGSI LAMA DARI FILE ANDA ---
// Catatan: Variabel xbrand dan xcab mungkin perlu didefinisikan secara global di halaman HTML Anda
// Contoh: <script> const xbrand = 'some_brand'; const xcab = 'some_cab'; </script>

function hapus(table, idField, idValue) {
    let result = 0;
    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php", 
        data: {
            action: 'hapus',
            table: table,
            idField: idField,
            idValue: idValue,
            xbrand : typeof xbrand !== 'undefined' ? xbrand : '',
            xcab   : typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            console.log(response);
            result = response;
        },
        error: function(error) {
            console.error(error);
        }
    });
    return result;
}

function tambahjson(table, jsonData) {
    let result = 0;
    jsonData.brand = typeof xbrand !== 'undefined' ? xbrand : '';
    jsonData.cab = typeof xcab !== 'undefined' ? xcab : '';
    jsonData = JSON.stringify(jsonData);

    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php",
        data: {
            action: 'tambahjson',
            table: table,
            jsonData: jsonData,
            xbrand : typeof xbrand !== 'undefined' ? xbrand : '',
            xcab   : typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            result = response;
        },
        error: function(error) {
            console.error(error);
        }
    });
    if ( result==0 ) {
        // Mungkin ada variabel vm yang perlu didefinisikan
        if (typeof vm !== 'undefined' && vm.pesan) {
            vm.pesan='Koneksi error ';
        }
    };
    return result;
}

function rubahjson(table, jsonData, id, ff) {
    let result = 0;
    jsonData = JSON.stringify(jsonData);
    jsonData = jsonData.replace(/"top":/g, '"`top`":').replace(/"left":/g, '"`left`":');
    jsonData = jsonData.replace(/:null/g, ':""');
           
    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php",
        data: {
            action: 'rubahjson',
            table: table,
            jsonData: jsonData,
            id:id,
            ff:ff,
            xbrand : typeof xbrand !== 'undefined' ? xbrand : '',
            xcab   : typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            result = response;
        },
        error: function(error) {
            console.error(error);
        }
    });
    return result;
}

function ambil_select(table, sql) {
    let result = "[]";
    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php",
        data: {
            action: 'ambil_select',
            sql: sql,
            xbrand: typeof xbrand !== 'undefined' ? xbrand : '',
            xcab: typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            try {
                JSON.parse(response);
                result = response;
            } catch (e) {
                console.error("Invalid JSON from server:", response);
                result = "[]";
            }
        },
        error: function(xhr, status, error) {
            console.error("AJAX Error:", error);
            console.log("Response:", xhr.responseText);
            result = "[]";
        }
    });
    return result;
}

function yambil_select(table, sql) {
    let result = "[]";
    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php",
        data: {
            action: 'yambil_select',
            sql: sql,
            xbrand: '',
            xcab: ''
        },
        success: function(response) {
            try {
                JSON.parse(response);
                result = response;
            } catch (e) {
                console.error("Invalid JSON from server:", response);
                result = "[]";
            }
        },
        error: function(xhr, status, error) {
            console.error("AJAX Error:", error);
            console.log("Response:", xhr.responseText);
            result = "[]";
        }
    });
    return result;
}

function ambil(table, field, value1, value2) {
    let result = [];
    if (!value2) {value2=value1};
    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php",
        data: {
            action: 'ambil',
            table: table,
            field: field,
            value: [value1, value2],
            xbrand : typeof xbrand !== 'undefined' ? xbrand : '',
            xcab   : typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            result = response;
        },
        error: function(error) {
            console.error(error);
        }
    });
    return result;
}

function xambil(table, field, value1, value2) {
    let result = [];
    if (!value2) {value2=value1};
    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php",
        data: {
            action: 'xambil',
            table: table,
            field: field,
            value: [value1, value2],
            xbrand : typeof xbrand !== 'undefined' ? xbrand : '',
            xcab   : typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            result = response;
        },
        error: function(error) {
            console.error(error);
        }
    });
    return result;
}

function ambilakhir(table, field, value1, value2) {
    let result = [];
    if (!value2) {value2=value1};
    $.ajax({
        type: "POST",
        async: false,
        url:  "crud.php",
        data: {
            action: 'ambilakhir',
            table: table,
            field: field,
            value: [value1, value2],
            xbrand : typeof xbrand !== 'undefined' ? xbrand : '',
            xcab   : typeof xcab !== 'undefined' ? xcab : ''
        },
        success: function(response) {
            result = response;
        },
        error: function(error) {
            console.error(error);
        }
    });
    return result;
}