<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

error_reporting(E_ALL);
ini_set('display_errors', 1);

// --- Konfigurasi Database ---
$servername = "localhost";
$username = "dmoxnpnp_pos";
$password = "jakarta183";
$dbname = "dmoxnpnp_pivot";

// Buat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Periksa koneksi
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

// --- Router Aksi ---
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    $table = isset($_POST['table']) ? $_POST['table'] : '';

    // -- RUTE BARU UNTUK LAPORAN --
    if ($action === 'get_stock_report_data') {
        get_stock_report_data($conn);
    } elseif ($action === 'get_purchase_report_data') {
        get_purchase_report_data($conn);
    
    // -- RUTE LAMA DARI FILE ANDA --
    } elseif ($action === 'hapus') {
        hapus($conn, $table);
    } elseif ($action === 'tambahjson') {
        tambahjson($conn, $table);
    } elseif ($action === 'rubahjson') {
        rubahjson($conn, $table);
    } elseif ($action === 'ambil_select') {
        ambil_select($conn);
    } elseif ($action === 'yambil_select') {
        yambil_select($conn);
    } elseif ($action === 'ambil') {
        ambil($conn, $table);
    } elseif ($action === 'xambil') {
        xambil($conn, $table);
    } elseif ($action === 'ambilakhir') {
        ambilakhir($conn, $table);
    }
    
    else {
        echo json_encode(["error" => "Invalid action specified."]);
    }
} else {
    echo json_encode(["error" => "No action specified."]);
}

// Tutup koneksi di akhir
$conn->close();


// --- FUNGSI-FUNGSI BARU UNTUK LAPORAN ---

function get_stock_report_data($conn) {
    $month = $_POST['month'];
    $sortBy = $_POST['sortBy'] ?? 'name_asc';
    $startDate = $month . '-01';
    $endDate = date("Y-m-t", strtotime($startDate));
    $opnameStartDate = $startDate;
    $opnameEndDate = date('Y-m-d', strtotime($endDate . ' +1 day'));
    
    $awalData = [];
    $sql_awal = "SELECT BARANG, STOK_FISIK FROM stock_opname WHERE TANGGAL = ?";
    $stmt_awal = $conn->prepare($sql_awal);
    $stmt_awal->bind_param("s", $opnameStartDate);
    $stmt_awal->execute();
    $result_awal = $stmt_awal->get_result();
    while ($row = $result_awal->fetch_assoc()) {
        $awalData[$row['BARANG']] = $row['STOK_FISIK'];
    }
    $stmt_awal->close();

    $sql_barang = "SELECT KODE, NAMA, JENIS, SATUAN, HARGA AS hargaJual, HARGA_BELI AS hargaBeli FROM barang WHERE JENIS IS NOT NULL AND JENIS != ''";
    $products = [];
    $result_barang = $conn->query($sql_barang);
    while ($row = $result_barang->fetch_assoc()) {
        $products[$row['KODE']] = $row;
    }

    $mutations = [];
    $sql_pembelian = "SELECT BARANG, TANGGAL, SUM(QTT) as total_in FROM pembelian WHERE TANGGAL BETWEEN ? AND ? GROUP BY BARANG, TANGGAL";
    $stmt_pembelian = $conn->prepare($sql_pembelian);
    $stmt_pembelian->bind_param("ss", $startDate, $endDate);
    $stmt_pembelian->execute();
    $result_pembelian = $stmt_pembelian->get_result();
    while ($row = $result_pembelian->fetch_assoc()) {
        $day = (int)date('j', strtotime($row['TANGGAL']));
        $mutations[$row['BARANG']][$day]['in'] = ($mutations[$row['BARANG']][$day]['in'] ?? 0) + (int)$row['total_in'];
    }
    $stmt_pembelian->close();

    $sql_penjualan = "SELECT BARANG, TANGGAL, SUM(QTT) as total_out, SUM(QTT * HARGA) as total_sales, SUM(QTT * (HARGA * DISKP / 100 + DISKRUPIAH)) as total_discount FROM penjualan WHERE TANGGAL BETWEEN ? AND ? GROUP BY BARANG, TANGGAL";
    $stmt_penjualan = $conn->prepare($sql_penjualan);
    $stmt_penjualan->bind_param("ss", $startDate, $endDate);
    $stmt_penjualan->execute();
    $result_penjualan = $stmt_penjualan->get_result();
    while ($row = $result_penjualan->fetch_assoc()) {
        $day = (int)date('j', strtotime($row['TANGGAL']));
        $mutations[$row['BARANG']][$day]['out'] = ($mutations[$row['BARANG']][$day]['out'] ?? 0) + (int)$row['total_out'];
        $mutations[$row['BARANG']][$day]['sales'] = ($mutations[$row['BARANG']][$day]['sales'] ?? 0) + (float)$row['total_sales'];
        $mutations[$row['BARANG']][$day]['discount'] = ($mutations[$row['BARANG']][$day]['discount'] ?? 0) + (float)$row['total_discount'];
    }
    $stmt_penjualan->close();

    $opnameData = [];
    $sql_opname = "SELECT BARANG as KODE_BARANG, STOK_FISIK, DIPINJAM FROM stock_opname WHERE TANGGAL = ?";
    $stmt_opname = $conn->prepare($sql_opname);
    $stmt_opname->bind_param("s", $opnameEndDate);
    $stmt_opname->execute();
    $result_opname = $stmt_opname->get_result();
    while($row = $result_opname->fetch_assoc()){
        $opnameData[$row['KODE_BARANG']] = $row;
    }
    $stmt_opname->close();

    $reportData = [];
    $daysInMonth = (int)date('t', strtotime($startDate));
    foreach ($products as $kode => $product) {
        $stockAwal = $awalData[$kode] ?? 0;
        $item = [
            'category' => $product['JENIS'], 'name' => $product['NAMA'], 'code' => $product['KODE'],
            'unit' => $product['SATUAN'], 'hargaBeli' => (float)$product['hargaBeli'], 'hargaJual' => (float)$product['hargaJual'],
            'stockAwal' => (int)$stockAwal, 'daily' => [], 'total_out_qty' => 0
        ];
        $sisaStok = $stockAwal;
        for ($d = 1; $d <= $daysInMonth; $d++) {
            $in_qty = $mutations[$kode][$d]['in'] ?? 0;
            $out_qty = $mutations[$kode][$d]['out'] ?? 0;
            $item['daily'][$d] = [
                'in' => $in_qty, 'out' => $out_qty,
                'sales' => $mutations[$kode][$d]['sales'] ?? 0,
                'discount' => $mutations[$kode][$d]['discount'] ?? 0
            ];
            $sisaStok += $in_qty - $out_qty;
            $item['total_out_qty'] += $out_qty;
        }
        $fisik = $opnameData[$kode]['STOK_FISIK'] ?? 0;
        $dipinjam = $opnameData[$kode]['DIPINJAM'] ?? 0;
        $totalFisik = (int)$fisik + (int)$dipinjam;
        $selisihQty = $totalFisik - $sisaStok;
        $item['opname'] = [
            'pos' => $sisaStok, 'fisik' => (int)$fisik, 'dipinjam' => (int)$dipinjam,
            'totalFisik' => $totalFisik, 'selisihQty' => $selisihQty,
            'selisihRp' => $selisihQty * $item['hargaBeli']
        ];
        $reportData[] = $item;
    }

    usort($reportData, function($a, $b) use ($sortBy) {
        if ($sortBy === 'name_asc') { return strcmp($a['name'], $b['name']); }
        if ($sortBy === 'group_asc') { return strcmp($a['category'], $b['category']) ?: strcmp($a['name'], $b['name']); }
        if ($sortBy === 'total_out_desc') { return $b['total_out_qty'] <=> $a['total_out_qty']; }
        return 0;
    });
    echo json_encode($reportData);
}

function get_purchase_report_data($conn) {
    $month = $_POST['month'];
    $startDate = $month . '-01';
    $endDate = date("Y-m-t", strtotime($startDate));

    // Ambil data header pembelian (per nota)
    $sql_header = "SELECT 
                NOMOR, TANGGAL, RELASI
            FROM pembelian
            WHERE TANGGAL BETWEEN ? AND ?
            GROUP BY NOMOR, TANGGAL, RELASI
            ORDER BY TANGGAL, NOMOR";
    
    $stmt_header = $conn->prepare($sql_header);
    $stmt_header->bind_param("ss", $startDate, $endDate);
    $stmt_header->execute();
    $result_header = $stmt_header->get_result();

    $purchases = [];
    while ($row = $result_header->fetch_assoc()) {
        $purchases[] = [
            'NOMOR' => $row['NOMOR'],
            'TANGGAL' => $row['TANGGAL'],
            'RELASI' => $row['RELASI'],
            'items' => []
        ];
    }
    $stmt_header->close();

    // Ambil detail barang untuk setiap nota
    foreach ($purchases as &$purchase) {
        $sql_items = "SELECT 
                        p.BARANG, 
                        b.NAMA, 
                        p.QTT
                    FROM pembelian p
                    LEFT JOIN barang b ON p.BARANG = b.KODE
                    WHERE p.NOMOR = ?
                    ORDER BY p.BARANG";
        
        $stmt_items = $conn->prepare($sql_items);
        $stmt_items->bind_param("s", $purchase['NOMOR']);
        $stmt_items->execute();
        $result_items = $stmt_items->get_result();
        
        while ($item = $result_items->fetch_assoc()) {
            $purchase['items'][] = [
                'BARANG' => $item['BARANG'],
                'NAMA' => $item['NAMA'] ?? 'Nama tidak tersedia',
                'QTT' => (float)$item['QTT']
            ];
        }
        $stmt_items->close();
    }
    
    echo json_encode($purchases);
}

// --- FUNGSI-FUNGSI LAMA DARI FILE ANDA ---

function hapus($conn, $table) {
    $idField = $_POST['idField'];
    $idValue = $_POST['idValue'];
    $sql = "DELETE FROM $table WHERE $idField = '$idValue'";
    if ($conn->query($sql) === TRUE) {
        echo "Record deleted successfully";
    } else {
        echo "Error deleting record: " . $conn->error;
    }
}

function tambahjson($conn, $table) {
    $jsonData = json_decode($_POST['jsonData'], true);
    $columns = implode(", ", array_keys($jsonData));
    $values = implode("', '", array_values($jsonData));
    $sql = "INSERT INTO $table ($columns) VALUES ('$values')";
    if ($conn->query($sql) === TRUE) {
        echo $conn->insert_id;
    } else {
        echo "Error: " . $sql . "<br>" . $conn->error;
    }
}

function rubahjson($conn, $table) {
    $jsonData = json_decode($_POST['jsonData'], true);
    $id = $_POST['id'];
    $ff = $_POST['ff'];
    $setPart = "";
    foreach ($jsonData as $key => $value) {
        $setPart .= "$key = '" . $conn->real_escape_string($value) . "', ";
    }
    $setPart = rtrim($setPart, ", ");
    $sql = "UPDATE $table SET $setPart WHERE $ff = '$id'";
    if ($conn->query($sql) === TRUE) {
        echo "Record updated successfully";
    } else {
        echo "Error updating record: " . $conn->error;
    }
}

function ambil_select($conn) {
    $sql = $_POST['sql'];
    $result = $conn->query($sql);
    $data = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
    }
    echo json_encode($data);
}

function yambil_select($conn) {
    $sql = $_POST['sql'];
    $result = $conn->query($sql);
    $data = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
    }
    echo json_encode($data);
}

function ambil($conn, $table) {
    $field = $_POST['field'];
    $values = $_POST['value'];
    $sql = "SELECT * FROM $table WHERE $field BETWEEN '{$values[0]}' AND '{$values[1]}'";
    $result = $conn->query($sql);
    $data = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
    }
    echo json_encode($data);
}

function xambil($conn, $table) {
    $field = $_POST['field'];
    $values = $_POST['value'];
    $sql = "SELECT * FROM $table WHERE $field BETWEEN '{$values[0]}' AND '{$values[1]}'";
    $result = $conn->query($sql);
    $data = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
    }
    echo json_encode($data);
}

function ambilakhir($conn, $table) {
    $field = $_POST['field'];
    $values = $_POST['value'];
    $sql = "SELECT * FROM $table WHERE $field BETWEEN '{$values[0]}' AND '{$values[1]}' ORDER BY $field DESC LIMIT 1";
    $result = $conn->query($sql);
    $data = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
    }
    echo json_encode($data);
}
?>