<?php
/**
 * PHP Proxy untuk VFP Windows 7 - PENJUALAN
 * File ini langsung include jual.php di server yang sama
 * Upload ke: /public_html/sahabat/proxy_jual.php
 */

// Set header response sebagai JSON
header('Content-Type: application/json; charset=utf-8');

// Allow dari semua origin (CORS)
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-Requested-With');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Hanya terima POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed. Only POST accepted.'
    ]);
    exit;
}

// Baca data JSON dari VFP
$jsonData = file_get_contents('php://input');

// Validasi data tidak kosong
if (empty($jsonData)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'No data received from VFP client'
    ]);
    exit;
}

// Validasi format JSON
$testDecode = json_decode($jsonData, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Invalid JSON format: ' . json_last_error_msg()
    ]);
    exit;
}

// Optional: Log untuk debugging
// Uncomment jika mau tracking request penjualan
/*
$logFile = __DIR__ . '/proxy_jual_log.txt';
$logData = sprintf(
    "[%s] Received %d bytes from IP: %s\n",
    date('Y-m-d H:i:s'),
    strlen($jsonData),
    $_SERVER['REMOTE_ADDR'] ?? 'unknown'
);
file_put_contents($logFile, $logData, FILE_APPEND);
*/

// Langsung include jual.php (di folder yang sama)
// jual.php akan membaca php://input dan process data
include(__DIR__ . '/jual.php');
?>